#ifndef _BNX2_COMPAT_H_
#define _BNX2_COMPAT_H_

#ifndef __VMKERNEL_MODULE__
#define napi_enable(napi) netif_poll_enable(bp->dev)
#define napi_disable(napi) netif_poll_disable(bp->dev)
#define netif_napi_add(_netdev, _napi, _poll, _weight) \
    do { \
        _netdev->poll = &(_poll); \
        _netdev->weight = (_weight); \
    } while (0)

#endif

#ifdef __VMKERNEL_MODULE__
#define vmalloc(size) kmalloc(size, GFP_KERNEL)
#define vfree(x)   kfree(x)
#endif

#ifdef __VMKERNEL_MODULE__
#define msleep_interruptible(x) mdelay(x)
#else
#define msleep_interruptible(x) do {set_current_state(TASK_INTERRUPTIBLE); \
                                        schedule_timeout((x * HZ)/1000); \
                                } while(0)
#endif

#ifdef __VMKERNEL_MODULE__
#define msleep(x)       mdelay(x)
#else
#define msleep(x)   do { set_current_state(TASK_UNINTERRUPTIBLE); \
                schedule_timeout((x * HZ)/1000); \
            } while (0)
#endif // __VMKERNEL_MODULE__

#ifdef __VMKERNEL_MODULE__
#undef spin_lock_bh
#define spin_lock_bh(x)		spin_lock_irq(x)

#undef spin_unlock_bh
#define spin_unlock_bh(x)	spin_unlock_irq(x)
#endif

#if (LINUX_VERSION_CODE < 0x2060c)
static inline int skb_header_cloned(struct sk_buff *skb) { return 0; }
#endif

/**
 *  skb_copy_from_linear_data_offset - copy the data of specified length from a
 *  specified offset in sk_buff to a buffer
 *  @skb: pointer to the sk_buff containing the data
 *  @offset: offset in the sk_buff data
 *  @to: buffer where the data should be copied to
 *  @len: number of bytes to be copied
 *
 *  Copy the data of specified length @len from offset @offset in sk_buff @skb
 *  to a buffer @to.
 *
 *  RETURN VALUE:
 *  None
 *
 */
 /* _VMKLNX_CODECHECK_: skb_copy_from_linear_data_offset */

static inline void skb_copy_from_linear_data_offset(const struct sk_buff *skb,
                                                    const int offset, void *to,
                                                    const unsigned int len)
{
        memcpy(to, skb->data + offset, len);
}

#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,5,28) )
#define schedule_work schedule_task
#define flush_scheduled_work flush_scheduled_tasks
#endif
#endif //_BNX2_COMPAT_H_
