#ifndef __BNX2X_COMPAT_H__
#define __BNX2X_COMPAT_H__

#ifdef __VMKERNEL_MODULE__
/* Definitions for ESX35 */
#include <asm/page.h>
#include <linux/smp.h>
#include <linux/ip.h>
#include <linux/tcp.h>
#include "vmklinux_dist.h"

#undef CONFIG_BNX2X_NAPI	/* Undefine NAPI in ESX35 */
#define __VMKERNEL_NO_SLEEP_MSLEEP__	/* msleep can not sleep in ESX35 */
#define __VMKERNEL_NO_SLEEP_MUTEX__	/* mutex can not sleep in ESX35 */

extern spinlock_t ertnl_lock;

#endif /* __VMKERNEL_MODULE__ */

#if (LINUX_VERSION_CODE < 0x020617)

#define skb_copy_from_linear_data_offset(skb, pad, new_skb_data, len) \
				memcpy(new_skb_data, skb->data + pad, len)

#define netif_rx_schedule(dev, X)	netif_rx_schedule(dev)
#define netif_rx_complete(X, Y)		netif_rx_complete(dev)

/* skb_buff accessors */
#define ip_hdr(skb)			(skb)->nh.iph
#define ipv6_hdr(skb)			(skb)->nh.ipv6h
#define ip_hdrlen(skb)			(ip_hdr(skb)->ihl * 4)
#define tcp_hdr(skb)			(skb)->h.th
#define tcp_hdrlen(skb)			(tcp_hdr(skb)->doff * 4)
#define udp_hdr(skb)			(skb)->h.uh
#define skb_mac_header(skb)		((skb)->mac.raw)
#define skb_network_header(skb)		((skb)->nh.raw)
#define skb_transport_header(skb)	((skb)->h.raw)

#endif

#if (LINUX_VERSION_CODE < 0x020600) /* Kernel 2.4 */

#define __NO_TPA__ 1

#define num_online_cpus()	1

#ifndef MODULE_INFO
#define MODULE_INFO(version, _version)
#endif /* !MODULE_INFO */

#ifndef module_param
#define module_param(v, t, p) MODULE_PARM(v, "i");
#endif /* !module_param */

static inline void __bc_synchronize_irq(void) { synchronize_irq(); }
#undef synchronize_irq
#define synchronize_irq(X)		__bc_synchronize_irq()

#define BNX2X_POLLING_QUOTA 1

#define flush_scheduled_work flush_scheduled_tasks

#define pci_dma_sync_single_for_cpu	pci_dma_sync_single
#define pci_dma_sync_single_for_device	pci_dma_sync_single_for_cpu

#ifndef __VMKERNEL_MODULE__
/* Only for COS */
static inline u8 __bc_reg_rd8(void *addr)
{
	u8 val;
	val = readb(addr);
	mb();
	return val;
}

static inline u32 __bc_reg_rd(void *addr)
{
	u32 val;
	val = readl(addr);
	mb();
	return val;
}

#endif /* !__VMKERNEL_MODULE__ */

#endif /* Kernel 2.4 */

/***********************
 * Special for ESX35
 ***********************/
#ifdef __VMKERNEL_MODULE__

#undef synchronize_irq
#ifdef CONFIG_PCI_MSI
/* We don't support IRQ sync for MSI-X */
#define synchronize_irq(x)	do {} while (0)
#else /* INTA */
#define synchronize_irq(x)	vmk_synchronize_irq(x)
#endif /* CONFIG_PCI_MSI */

#ifndef rtnl_lock
#define rtnl_lock()	spin_lock(&ertnl_lock);
#define rtnl_unlock()	spin_unlock(&ertnl_lock);
#endif /* !rtnl_lock */

#ifndef signal_pending
#define signal_pending(x)	0
#endif /* !signal_pending */

#ifndef skb_fill_page_desc
static inline void skb_fill_page_desc(struct sk_buff *skb, int i,
				struct page *page, int off, int size)
{
	skb_frag_t *frag = &skb_shinfo(skb)->frags[i];
	frag->page = page;
	frag->page_offset = off;
	frag->size = size;
	skb_shinfo(skb)->nr_frags = i + 1;
}
#endif /* !skb_fill_page_desc */

#ifndef skb_copy_bits
static inline void *
kmap_skb_frag(const skb_frag_t *frag)
{
   return vmk_phys_to_kmap(page_to_phys(frag->page), PAGE_SIZE);
}

static inline void
kunmap_skb_frag(void *vaddr)
{
   vmk_phys_to_kmap_free(vaddr);
}

static int
skb_copy_bits(const struct sk_buff *skb, int offset, void *to, int len)
{
   int i, copy;
   int start = skb_headlen(skb);
   
   if (offset > (int)skb->len - len) {
      goto fault;
   }

   if ((copy = start - offset) > 0) {

      if (copy > len) {
	 copy = len;
      }

      memcpy(to, skb->data + offset, copy);

      if ((len -= copy) == 0) {
	 return 0;
      }

      offset += copy;
      to     += copy;
   }
   
   for (i = 0; i < skb_shinfo(skb)->nr_frags; i++) {
      int end;
      
      end = start + skb_shinfo(skb)->frags[i].size;
      if ((copy = end - offset) > 0) {
	 u8 *vaddr;
	 
	 if (copy > len) {
	    copy = len;
	 }

	 vaddr = kmap_skb_frag(&skb_shinfo(skb)->frags[i]);
	 memcpy(to,
		vaddr + skb_shinfo(skb)->frags[i].page_offset+
		offset - start, copy);
	 kunmap_skb_frag(vaddr);
	 
	 if ((len -= copy) == 0) {
	    return 0;
	 }

	 offset += copy;
	 to     += copy;
      }
      start = end;
   }
   
   if (!len) {
      return 0;
   }
   
 fault:
   return -EFAULT;
}

#endif /* !skb_copy_bits */

#ifndef skb_linearize
#define SKB_DATA_ALIGN(X)	(((X) + (SMP_CACHE_BYTES-1)) & ~(SMP_CACHE_BYTES-1))
static inline int __skb_linearize(struct sk_buff *skb)
{
        return __pskb_pull_tail(skb, skb->data_len) ? 0 : -ENOMEM;
}

/**
 *  * skb_linearize - convert paged skb to linear one
 *   * @skb: buffer to linarize
 *    *
 *     * If there is no free memory -ENOMEM is returned, otherwise zero
 *      * is returned and the old skb data released.
 *       */
static inline int skb_linearize(struct sk_buff *skb,  int gfp_mask)

{
        return skb_is_nonlinear(skb) ? __skb_linearize(skb) : 0;
}
#endif

#include <vm_assert.h>

static inline unsigned char *skb_end_pointer(const struct sk_buff *skb)
{
	return skb->end;
}

extern int numPCPUs;

#undef num_online_cpus
#define num_online_cpus()	(numPCPUs)

#ifndef MAX_WBITS
#  define MAX_WBITS   15 /* 32K LZ77 window */
#endif /* !MAX_WBITS */

#define csum_roll(sum)		(((sum) > 0xffff) ?                  \
				(((sum) & 0xffff) + ((sum) >> 16)) : \
				(sum))

static inline unsigned int csum_partial(const unsigned char *buff, int len,
					unsigned int sum)
{
	int nlong;
	int nbytes;
	unsigned int add;

	if ((unsigned long) buff & 0x0002) {
		/* Align buff onto a 4 byte boundary */
		add = (unsigned int) *((unsigned short *) buff);
		buff += 2;
		len -= 2;

		sum += add;
		sum = csum_roll(sum);
	}

	nlong = len / 4;
	nbytes = len % 4;

	while (nlong-- > 0) {
		add = *((unsigned int *) buff);
		buff += sizeof(unsigned int);

		add = csum_roll(add);
		sum += add;
		sum = csum_roll(sum);
	}

	if (nbytes > 1) {
		add = (unsigned int) *((unsigned short *) buff);
		sum += add;
		sum = csum_roll(sum);
		buff += sizeof(unsigned short);
	}
	if (nbytes % 2) {
		add = (unsigned int) *buff;
		sum += add;
		sum = csum_roll(sum);
	}
	return sum;
}

#ifndef BUG_TRAP
#define BUG_TRAP(x) do { \
	if (unlikely(!(x))) { \
		printk(KERN_ERR "KERNEL: assertion (%s) failed at %s (%d)\n", \
			#x,  __FILE__ , __LINE__); \
	} \
} while (0)
#endif /* !BUG_TRAP */

#ifndef min_t
#define min_t(type, x, y) \
	({ type __x = (x); type __y = (y); __x < __y ? __x: __y; })
#endif /* !min_t */
#ifndef max_t
#define max_t(type, x, y) \
	({ type __x = (x); type __y = (y); __x > __y ? __x: __y; })
#endif /* !max_t */

#endif /* __VMKERNEL_MODULE__ */

#ifndef CHECKSUM_PARTIAL
#define CHECKSUM_PARTIAL		CHECKSUM_HW
#endif


#ifndef SET_MODULE_OWNER
#define SET_MODULE_OWNER(dev)
#endif


#if (LINUX_VERSION_CODE < 0x020604)
#define MODULE_VERSION(version)
#endif


#if (LINUX_VERSION_CODE < 0x020600)
#define might_sleep()

#define dev_info(dev, format, args...) \
				printk(KERN_INFO "bnx2x: " format, ##args)

#define dev_err(dev, format, args...) \
				printk(KERN_ERR "bnx2x: " format, ##args)

static inline int dma_mapping_error(dma_addr_t mapping)
{
	return 0;
}

#endif


#if (LINUX_VERSION_CODE < 0x020547)
#define pci_set_consistent_dma_mask(X, Y)	(0)
#endif


#ifdef __VMKERNEL_NO_SLEEP_MSLEEP__
#undef msleep
#define msleep(ms) msec_delay(ms)
#undef msleep_interruptible
#define msleep_interruptible(ms) msec_delay(ms)
#else /* Linux Kernel, normal sleepable */

#if (LINUX_VERSION_CODE < 0x020607)
#define msleep(x) \
	do { \
		current->state = TASK_UNINTERRUPTIBLE; \
		schedule_timeout((HZ * (x)) / 1000); \
	} while (0)

#endif

#if (LINUX_VERSION_CODE < 0x020609)
#define msleep_interruptible(x) \
	do{ \
		current->state = TASK_INTERRUPTIBLE; \
		schedule_timeout((HZ * (x)) / 1000); \
	} while (0)

#endif

#endif /* __VMKERNEL_NO_SLEEP_MSLEEP__ */

#ifndef ADVERTISE_1000XPAUSE
static inline struct mii_ioctl_data *if_mii(struct ifreq *rq)
{
	return (struct mii_ioctl_data *)&rq->ifr_ifru;
}
#endif

#ifndef __VMKERNEL_MODULE__
#define pci_enable_msix(X, Y, Z)	(-1)
#endif /* !__VMKERNEL_MODULE__ */

#if (LINUX_VERSION_CODE < 0x02060b)
#define pm_message_t			u32
#define pci_power_t			u32
#define PCI_D0				0
#define PCI_D3hot			3
#define pci_choose_state(pdev, state)	state
#endif


#if (LINUX_VERSION_CODE < 0x02060e)
#define touch_softlockup_watchdog()
#endif


#if (LINUX_VERSION_CODE < 0x020612)
static inline struct sk_buff *netdev_alloc_skb(struct net_device *dev,
					       unsigned int length)
{
#ifndef __VMKERNEL_MODULE__
	struct sk_buff *skb = dev_alloc_skb(length);
#else /* ESX35 */
	struct sk_buff *skb = alloc_skb(length, GFP_ATOMIC);
#endif /* !__VMKERNEL_MODULE__ */

	if (skb)
		skb->dev = dev;
	return skb;
}
#endif


#ifndef IRQ_HANDLED
typedef void irqreturn_t;
#define IRQ_HANDLED
#define IRQ_NONE
#endif


#ifndef IRQF_SHARED
#define IRQF_SHARED			SA_SHIRQ
#endif


#ifndef NETIF_F_GSO
static inline void netif_tx_lock(struct net_device *dev)
{
	spin_lock(&dev->xmit_lock);
	dev->xmit_lock_owner = smp_processor_id();
}

static inline void netif_tx_unlock(struct net_device *dev)
{
	dev->xmit_lock_owner = -1;
	spin_unlock(&dev->xmit_lock);
}
#endif


#ifndef skb_shinfo
#define skb_shinfo(SKB)	((struct skb_shared_info *)(skb_end_pointer(SKB)))
#endif


#ifdef NETIF_F_TSO
#ifndef NETIF_F_GSO

static inline int skb_is_gso(const struct sk_buff *skb)
{
	return skb_shinfo(skb)->tso_size;
}

#define gso_size			tso_size

#endif /* NETIF_F_GSO */

#ifndef NETIF_F_GSO_SOFTWARE
#define NETIF_F_GSO_SOFTWARE		(NETIF_F_TSO)
#endif

#endif /* NETIF_F_TSO */

#ifndef NETIF_F_TSO_ECN
#define NETIF_F_TSO_ECN			0
#endif


#if !defined(mmiowb)
#ifdef CONFIG_IA64
#define mmiowb() asm volatile ("mf.a" ::: "memory")
#else /* IA32 */
#define mmiowb()
#endif /* CONFIG_IA64 */
#endif

#if !defined(__iomem)
#define __iomem
#endif

#ifndef noinline
#define noinline
#endif

#ifndef WARN_ON
#define WARN_ON(X)
#endif

#if !defined(INIT_WORK)
/* Work queue compat definitions */
#include <linux/tqueue.h>
#define INIT_WORK INIT_TQUEUE
#define schedule_work			schedule_task
#define work_struct			tq_struct
#endif


#if !defined(HAVE_NETDEV_PRIV) && (LINUX_VERSION_CODE != 0x020603) && (LINUX_VERSION_CODE != 0x020604) && (LINUX_VERSION_CODE != 0x020605)
#define netdev_priv(dev)		(dev)->priv
#endif

/* Missing defines */
#ifndef SPEED_2500
#define SPEED_2500			2500
#endif

#ifndef SUPPORTED_Pause
#define SUPPORTED_Pause			(1 << 13)
#endif
#ifndef SUPPORTED_Asym_Pause
#define SUPPORTED_Asym_Pause		(1 << 14)
#endif

#ifndef ADVERTISED_Pause
#define ADVERTISED_Pause		(1 << 13)
#endif

#ifndef ADVERTISED_Asym_Pause
#define ADVERTISED_Asym_Pause		(1 << 14)
#endif

#ifndef NETDEV_TX_BUSY
#define NETDEV_TX_BUSY			1 /* driver tx path was busy */
#endif

#ifndef NETDEV_TX_OK
#define NETDEV_TX_OK			0 /* driver took care of packet */
#endif


#ifndef DMA_64BIT_MASK
#define DMA_64BIT_MASK			((u64) 0xffffffffffffffffULL)
#define DMA_32BIT_MASK			((u64) 0x00000000ffffffffULL)
#endif

#ifndef PCI_CAP_ID_EXP
#define PCI_CAP_ID_EXP			0x10
#endif

#ifndef PCI_EXP_DEVCTL
#define PCI_EXP_DEVCTL			8	/* Device Control */
#endif

#ifndef PCI_EXP_DEVCTL_PAYLOAD
#define PCI_EXP_DEVCTL_PAYLOAD		0x00e0	/* Max_Payload_Size */
#endif

#ifndef PCI_EXP_DEVCTL_READRQ
#define PCI_EXP_DEVCTL_READRQ		0x7000	/* Max_Read_Request_Size */
#endif


#if (LINUX_VERSION_CODE < 0x020618)

#ifndef NETIF_F_HW_CSUM
#define NETIF_F_HW_CSUM			8
#endif

static inline int bnx2x_set_tx_hw_csum(struct net_device *dev, u32 data)
{
	if (data)
		dev->features |= NETIF_F_HW_CSUM;
	else
		dev->features &= ~NETIF_F_HW_CSUM;
	return 0;
}
#endif

#ifdef __VMKERNEL_NO_SLEEP_MUTEX__

#define mutex				spinlock_t
#define mutex_lock(x)			spin_lock(x)
#define mutex_unlock(x)			spin_unlock(x)
#define mutex_init(x)			spin_lock_init(x)

#else
/* If mutex is not available, use semaphore */
#ifndef __LINUX_MUTEX_H
#define mutex				semaphore
#define mutex_lock(x)			down(x)
#define mutex_unlock(x)			up(x)
#define mutex_init(x)			sema_init(x,1)
#endif
#endif /* __VMKERNEL_NO_SLEEP_MUTEX__ */


#ifndef KERN_CONT
#define KERN_CONT
#endif


#if (LINUX_VERSION_CODE < 0x020606) || defined(BNX2X_DRIVER_DISK) || defined(__VMKLNX__)

#define CRC32C_POLY_LE			0x82F63B78

static inline u32 crc32c_le(u32 crc, unsigned char const *p, size_t len)
{
	int i;

	while (len--) {
		crc ^= *p++;
		for (i = 0; i < 8; i++)
			crc = (crc >> 1) ^ ((crc & 1) ? CRC32C_POLY_LE : 0);
	}
	return crc;
}
#endif

#endif /* __BNX2X_COMPAT_H__ */
