#ifndef _E1000_STRESS_H_
#define _E1000_STRESS_H_
#ifdef __VMKERNEL_MODULE__
#include "e1000.h"
#include "linux_stress.h"

/*
 * VMWARE_STRESS_ONLY_STOP_QUEUE
 *
 * The macro takes two parameters. The first one is the 
 * device for which queuing is to be disabled. The second
 * parameter is a hack to specify where control should
 * be transferred when the stress counter is hit. Typically,
 * it is either a continue or a return statement.
 *
 * Enable this option when the cable is unpluged would trigger log spew
 * 'tx unit hang' see PR 91530.
 *
 * There is still a very small window for race if we disable the stress option 
 * between VMK_STRESS_DEBUG_OPTION returns 0 and VMK_STRESS_DEBUG_OPTION is 
 * called again. In this case, the tx queue would be stopped, tx pkts will be
 * dropped
 */
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)                   \
if (VMK_STRESS_DEBUG_OPTION(NET_HW_STOP_QUEUE)) {                          \
   if (VMK_STRESS_DEBUG_COUNTER(NET_HW_STOP_QUEUE)) {                      \
      netif_stop_queue(dev);                                               \
      CONTINUE_CMD;                                                        \
   } else {                                                                \
      if (netif_running(netdev)) {                                         \
         netif_wake_queue(dev);                                            \
      }                                                                    \
   }                                                                       \
} else {                                                                   \
}                                                                          \

static
void LinuxStress_StressIntrRate(unsigned long data)
{
	struct e1000_adapter *adapter = (struct e1000_adapter *)data;
	uint32_t rctl;
	
	adapter->rx_int_delay = VMK_STRESS_DEBUG_VALUE(NET_HW_INTR_RATE);
	adapter->tx_int_delay = adapter->rx_int_delay;
	
	rctl = E1000_READ_REG(&adapter->hw, E1000_RCTL);
	E1000_WRITE_REG(&adapter->hw, E1000_RCTL, rctl & ~E1000_RCTL_EN);
	
	printk(KERN_EMERG " Changing NIC interrupt rate to %u\n", adapter->rx_int_delay);

	E1000_WRITE_REG(&adapter->hw, E1000_RDTR, adapter->rx_int_delay);
	E1000_WRITE_REG(&adapter->hw, E1000_TIDV, adapter->tx_int_delay);
	
	if (adapter->hw.mac.type >= e1000_82540) {
		adapter->rx_abs_int_delay = adapter->rx_int_delay;
		adapter->tx_abs_int_delay = adapter->rx_int_delay;
		E1000_WRITE_REG(&adapter->hw, E1000_RADV, adapter->rx_abs_int_delay);
		E1000_WRITE_REG(&adapter->hw, E1000_TADV, adapter->tx_abs_int_delay);
		if (adapter->rx_abs_int_delay > 0xff) {
			adapter->itr = 100000;
		} else {
			adapter->itr = 1;
		}
		if (adapter->itr > 1) {
			E1000_WRITE_REG(&adapter->hw, E1000_ITR,
					1000000000 / (adapter->itr * 256));
		}
	}
	
	E1000_WRITE_REG(&adapter->hw, E1000_RCTL, rctl);
}
#else
#define VMWARE_STRESS_RETAIN_BUFFER(skb, CONTINUE_CMD, ELSE_CMD) ELSE_CMD;
#define VMWARE_STRESS_ONLY_STOP_QUEUE(dev, CONTINUE_CMD)
#define VMWARE_STRESS_ONLY_SET_INTR_RATE(param, compare)
#define VMWARE_STRESS_ONLY_CORRUPT_BUFFER(COUNTER, skb, len)
#define VMWARE_STRESS_ONLY_FAIL_BUFFER(COUNTER, skb, FREE_SKB, CONTINUE_CMD)
#endif //__VMKERNEL_MODULE__
#define NO_ELSE_CMD
#define NO_CONTINUE_CMD
#endif // _E1000_STRESS_H_
