#ifndef _KCOMPAT_H_
#define _KCOMPAT_H_

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0)
#include<linux/tqueue.h>
#else
#include<linux/workqueue.h>
#endif

/*
 * Macros for msleep and msleep_interruptible for kernel versions in which
 * they are not defined.
 */
#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,6,8) )
#ifdef __VMKERNEL_MODULE__
#define msleep(x)       mdelay(x)
#else
#define msleep(x)	do { set_current_state(TASK_UNINTERRUPTIBLE); \
                                schedule_timeout((x * HZ)/1000 + 2); \
                        } while(0)
#endif
#endif

#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,6,9) )
#ifdef __VMKERNEL_MODULE__
#define msleep_interruptible(x) mdelay(x)
#else
#define msleep_interruptible(x) do {set_current_state(TASK_INTERRUPTIBLE); \
                                        schedule_timeout((x * HZ)/1000); \
                                } while(0)
#endif
#endif

/* Use pci_name instead of slot_name for kernel versions > 2.4.22 */
#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,4,22) )
#define pci_name(x)     ((x)->slot_name)
#endif

/* pci_save_state */
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,10))
#define pci_save_state(x,y)	pci_save_state(x)
#endif

/* pci_restore_state */
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,6,10))
#define pci_restore_state(x,y)	pci_restore_state(x);
#endif

/* Macros to ensure the code is backward compatible with 2.4.x kernels. */
#ifndef NET_IP_ALIGN
#define NET_IP_ALIGN 2
#endif

#ifndef SET_NETDEV_DEV
#define SET_NETDEV_DEV(a, b)    do {} while(0)
#endif

#ifndef HAVE_FREE_NETDEV
#define free_netdev(x) kfree(x)
#endif

#ifndef IRQ_NONE
typedef void irqreturn_t;
#define IRQ_NONE
#define IRQ_HANDLED
#define IRQ_RETVAL(x)
#endif

#ifdef INIT_TQUEUE
#define schedule_work schedule_task
#define flush_scheduled_work flush_scheduled_tasks
#define INIT_WORK INIT_TQUEUE
#endif

#ifndef __iomem
#define __iomem
#endif

#ifndef DMA_64BIT_MASK
#define DMA_64BIT_MASK  0xffffffffffffffffULL
#define DMA_32BIT_MASK  0x00000000ffffffffULL
#endif

#ifndef S2IO_ALIGN
#define S2IO_ALIGN(x,a) (((x)+(a)-1)&~((a)-1))
#endif

#if ( LINUX_VERSION_CODE < KERNEL_VERSION(2,6,0) )
#define GET_SOCK_SLEEP_CALLBACK(sk)     sk->sleep
#define GET_SOCK_SOCKET_DESC(sk)        sk->socket
#else
#define GET_SOCK_SLEEP_CALLBACK(sk)     sk->sk_sleep
#define GET_SOCK_SOCKET_DESC(sk)        sk->sk_socket
#endif

#ifdef module_param
#define S2IO_PARM_INT(X, def_val) \
        static unsigned int X = def_val;\
	        module_param(X , uint, 0);
#else
#define S2IO_PARM_INT(X, def_val) \
        static unsigned int X = def_val;\
	        MODULE_PARM(X, "i");
#endif

#ifdef NETIF_F_UFO
#define TXDS_SET_UFO_EN(txdp, skb) \
	if (skb_shinfo(skb)->ufo_size)\
		txdp->Control_1 |= TXD_UFO_EN;
#else 
#define TXDS_SET_UFO_EN(txdp, skb) 
#endif

#ifdef __VMKERNEL_MODULE__
#define dev_alloc_skb(size) 	alloc_skb(size, GFP_ATOMIC)
/* 
 * Since vmkernel doesn't support currently skb pull/push kernel functions
 * we are defining the functions here. FIXME in the future.
 */
static inline unsigned char *skb_push(struct sk_buff *skb, unsigned int len)
{
	skb->data-=len;
	skb->len+=len;
	if(skb->data<skb->head) 
		out_of_line_bug();
	return skb->data;
}

static inline unsigned char * skb_pull(struct sk_buff *skb, unsigned int len)
{
	if (len > skb->len)
		return NULL;
	skb->len-=len;
	if (skb->len < skb->data_len)
		out_of_line_bug();
	return  skb->data+=len;
}


#endif

#endif /* _KCOMPAT_H_ */
