#include <stdio.h>
#include <fcntl.h>
#include <sys/ioctl.h>
#include <sys/socket.h>
#include <net/if.h>
#include <stdlib.h>
#include <unistd.h>
#include<netinet/in.h>
#include<sys/types.h>
#include<sys/un.h>
#include <strings.h>
#include <linux/types.h>
#include <linux/netlink.h>
#include <malloc.h>
#include "util.h"
#include "spdm_cfg.h"

extern char *optarg;

#define SPDM_GET 1
#define SPDM_SET 2
int spdm_config(char * dev, int cmd);

void usage(void)
{
	printf("util -i <interface name>  [OPTIONS] \n");
	printf("OPTIONS\n");
	printf("\t -d txds\n");
		printf("\t\tDumps Tx Descriptors\n");
	printf("\t -d rxds\n");
		printf("\t\tDumps Rx Descriptors\n");
	printf("\t -d stats\n");
		printf("\t\tDumps Xframe Statistics\n");
	printf("\t -d regs\n");
		printf("\t\tDumps Xframe Registers\n");
	printf("\t -r <offset>\n");
		printf("\t\tPrints register at offset <offset>\n");
	printf("\t -w <offset> -v <value>\n");
		printf("\t\tWrites register at offset <offset> with value <value>\n");
	printf("\t -s get\n");
		printf("\t\tGet SPDM configuration\n");
	printf("\t -s set\n");
		printf("\t\tSet SPDM configuration\n");
	exit(0);
}

int main(int argc, char **argv)
{
	int sock = socket(AF_INET,SOCK_DGRAM,0);
	int fp,j;
	struct ifreq rq;
	ioctlInfo_t io;
	unsigned char dev[10],path[30];
	int ch;
	int cmd, i, offset;
	unsigned long long val64;

	if(argc <= 1)
		usage();
	while ((ch = getopt(argc, argv, "i:d:r:w:v:s:")) != -1) {
		switch (ch) {
		case 'd' :
			if (strcmp(optarg, "txds") == 0)
				cmd = 1;
			else if (strcmp(optarg, "rxds") == 0)
				cmd = 2;
			else if (strcmp(optarg, "stats") == 0)
				cmd = 3;
			else if (strcmp(optarg, "regs") == 0)
				cmd = 4;
			break;
		case 'i':
			strcpy(dev, optarg);
			break;
		case 'r':
			cmd = 11;
			offset =  strtoul(optarg, NULL, 16);
			break;
		case 'w':
			cmd = 12;
			offset =  strtoul(optarg, NULL, 16);
			break;
		case 'v':
			val64 =  strtoull(optarg, NULL, 16);
			break;
		case 's':
			if (strcmp(optarg, "get") == 0)
				cmd = 21;
			else
				cmd = 22;
		}
	}
	io.buffer  = (unsigned char *)malloc(0x300000);
	if (io.buffer == NULL) {
		printf("Malloc failed exiting \n");
		exit(1);
	}
	system("/bin/rm -f /tmp/dump");
	fp = open("/tmp/dump",  O_CREAT| O_RDWR),j;
	if (fp < 1) {
		if (cmd <= 3) {
			printf("open of /tmp/dump failed \n");
			exit(1);
		}
	}
	strcpy(rq.ifr_name,dev);
	rq.ifr_data = (char *)&io;
	switch (cmd) {
	case 1:
		if(!(ioctl(sock, (SIOCDEVPRIVATE + 4), &rq))) {
			printf("TXD data, size: %d\n", io.size);
			fflush(stdout);
			write(fp, io.buffer, io.size);
			close(fp);
			system("hexdump -C -v /tmp/dump");
		} else
			printf("Ioctl failed\n");
		break;
	case 2:
		if(!(ioctl(sock, (SIOCDEVPRIVATE + 7), &rq))) {
			printf("RxD data, size: %d\n", io.size);
			fflush(stdout);
			write(fp, io.buffer, io.size);
			close(fp);
			system("hexdump -C -v /tmp/dump");
		} else
			printf("Ioctl failed\n");
		break;
	case 3:
		if(!(ioctl(sock, (SIOCDEVPRIVATE + 5), &rq))) {
			printf("Stat data, size: %d\n",io.size);
			fflush(stdout);
			write(fp, io.buffer, io.size);
			close(fp);
			system("hexdump -C -v /tmp/dump");
		} else
			printf("Ioctl failed\n");
		break;
	case 4:
		for ( i = 0 ; i < 0x3108 ; i += 8) {
			io.offset = i;
			if(!(ioctl(sock, (SIOCDEVPRIVATE + 9), &rq))) {
				printf("offset: 0x%04x Value: 0x%016llx\n", i,io.value);
			} else {
				printf("Ioctl failed for offset %d\n",i);
				break;
			}
		}
		break;
	case 11:
		io.offset = offset;
		if(!(ioctl(sock, (SIOCDEVPRIVATE + 9), &rq))) {
			printf("Read offset: 0x%04x Value: 0x%016llx\n", offset,io.value);
		} else
			printf("Ioctl failed for offset %d\n",i);
		break;
	case 12:
		io.offset = offset;
		io.value = val64;
		if(!(ioctl(sock, SIOCDEVPRIVATE+10, &rq))) {
			printf("Write offset: 0x%04x Value: 0x%016llx\n", offset,io.value);
		} else
			printf("Ioctl failed for offset %d\n",i);
		break;
	case 21:
		spdm_config(dev,SPDM_GET);
		break;
	case 22:
		spdm_config(dev,SPDM_SET);
		break;
	default:
		usage();
	}
	return 0;
}


#define	CHECK_OPT(in) strcmp(in, "yes")
#define NETLINK_S2IO	18
#define	BIT_SWAP(x, y, l)	do {				\
					unsigned long long tmp;	\
					tmp = (x & 0x1);	\
					x >>= 1;		\
					tmp <<= (l-1);		\
					y |= tmp;		\
					l--;			\
				} while(x);

typedef unsigned int ub4; /* unsigned 4-byte quantities */
typedef unsigned char ub1;
#define mix(a,b,c) { \
	a -= b; a -= c; a ^= (c>>13); \
	b -= c; b -= a; b ^= (a<<8); \
	c -= a; c -= b; c ^= (b>>13); \
	a -= b; a -= c; a ^= (c>>12); \
	b -= c; b -= a; b ^= (a<<16); \
	c -= a; c -= b; c ^= (b>>5); \
	a -= b; a -= c; a ^= (c>>3); \
	b -= c; b -= a; b ^= (a<<10); \
	c -= a; c -= b; c ^= (b>>15); \
}

ub4 hash( message, length, golden_ratio, init_value)
	register ub1 *message;
	register ub4 length;
	register ub4 golden_ratio;
	register ub4 init_value;
{
	register ub4 a,b,c,len;
	len = length;
	a = b = golden_ratio;
	c = init_value;
	while (len >= 12) {
		a += (message[0] +((ub4)message[1]<<8) +((ub4)message[2]<<16)
		      +((ub4)message[3]<<24));
		b += (message[4] +((ub4)message[5]<<8) +((ub4)message[6]<<16)
		      +((ub4)message[7]<<24));
		c += (message[8] +((ub4)message[9]<<8)
		      +((ub4)message[10]<<16)+((ub4)message[11]<<24));
		mix(a,b,c);
		message += 12; len -= 12;
	}
	c += length;
	/* all the case statements fall through, such that all message bytes contribute*/
	switch(len) {
	case 11: c+=((ub4)message[10]<<24);
	case 10: c+=((ub4)message[9]<<16);
	case 9 : c+=((ub4)message[8]<<8);
	case 8 : b+=((ub4)message[7]<<24);
	case 7 : b+=((ub4)message[6]<<16);
	case 6 : b+=((ub4)message[5]<<8);
	case 5 : b+=message[4];
	case 4 : a+=((ub4)message[3]<<24);
	case 3 : a+=((ub4)message[2]<<16);
	case 2 : a+=((ub4)message[1]<<8);
	case 1 : a+=message[0];
	}
	mix(a,b,c);
	return c;
}

void spdm_display(spdm_cfg_t inf)
{
	switch(inf.ret) {
		case SPDM_NO_DATA:
			printf("Driver not loaded or the data pointer was NULL!!\n");
			break;
		case SPDM_XENA_IF:
			printf("The device selected is XFRAME I");
			printf(" which does not support SPDM\n");
			break;
		case SPDM_HW_UNINITIALIZED:
			printf("Up the device using ifconfig before ");
			printf("making this call\n");
			break;
		case SPDM_INCOMPLETE_SOCKET:
			printf("The socket info passed was incorrect\n");
			break;
		case SPDM_TABLE_ACCESS_FAILED:
			printf("I/O register access failed\n");
			break;
		case SPDM_TABLE_FULL:
			printf("All elements of the table are full\n");
			break;
		case SPDM_TABLE_MALLOC_FAIL:
			printf("Mem allocation in the driver to retrieve");
			printf(" SPDM table data failed\n");
			break;
		case SPDM_CONF_SUCCESS:
			printf("SPDM configuration successful!\n");
			break;
		default:
			printf("Unknown error!!\n");
			break;
	}
}

int spdm_config(char * dev, int cmd)
{
	int s_d, ret, i;
	struct ifreq rq;
	spdm_cfg_t inf;
	char inp[20], tmp[20];
	unsigned char msg[12], *x, *y = NULL;
	unsigned int ip_mask = 0xFFFFFFFF;
	unsigned short port_mask = 0xFFFF;
	struct sockaddr_nl src_addr, dest_addr;
	struct nlmsghdr *nlm;
	struct iovec iov;
	struct msghdr nlmsg;

	if (cmd == SPDM_SET) {
		memset(&inf, 0, sizeof(inf));

		printf("Enter Src IP: ");
		scanf("%s", inp);
		inf.sip = (unsigned int)inet_addr(inp);

		printf("Enter Dst IP: ");
		scanf("%s", inp);
		inf.dip = (unsigned int)inet_addr(inp);

		printf("Enter Src TCP port: ");
		scanf("%s", inp);
		inf.sprt = (unsigned short)(strtol(inp, NULL, 10));
		/**
		 *
		inf.sprt = port_mask;
		*/

		printf("Enter Dst TCP port: ");
		scanf("%s", inp);
		inf.dprt = (unsigned short)(strtol(inp, NULL, 10));

		printf("Enter target Queue (between 0 - 7): ");
		scanf("%s", inp);
		inf.t_queue = strtol(inp, NULL, 10);
		if (inf.t_queue > 7) {
			printf("Error: target Queue # has to be between 0 - 7\n");
			return 0;
		}
		inf.ret = SPDM_NO_DATA;

		for (i=0; i<12; i++, x++) {
			switch(i) {
			case 0:
				x = (unsigned char *)&inf.sip;
				break;
			case 4:
				x = (unsigned char *)&inf.dip;
				break;
			case 8:
				x = (unsigned char *)&inf.sprt;
				y = (x+1);
				break;
			case 10:
				x = (unsigned char *)&inf.dprt;
				y = (x+1);
				break;
			}
			if (y) {
				msg[i] = *y;
				msg[i+1] = *x;
				x++; i++;
			} else {
				msg[i] = *x;
			}
		}
		inf.hash = hash(msg, 12, 0, 0);
		printf("Hash: 0x%x\n", inf.hash);
	} else {
		memset(inf.data, 0, MAX_SPDM_ENTRIES_SIZE);
		inf.ret = SPDM_GET_CFG_DATA;
	}

	s_d = socket(AF_NETLINK, SOCK_RAW, NETLINK_S2IO);
	if (s_d < 0) {
		printf("Socket creation failed\n");
		return -1;
	}

	inf.sip = htonl(inf.sip);
	inf.dip = htonl(inf.dip);
	strcpy(inf.dev_name, dev);

	//NETLINK based communication

	memset(&src_addr, 0, sizeof(src_addr));
	src_addr.nl_family = AF_NETLINK;
	src_addr.nl_pid = getpid();
	src_addr.nl_groups = 0;
	if (bind(s_d, (struct sockaddr *)&src_addr, sizeof(src_addr)) < 0) {
		printf("Bind() call failed..\n");
		return -1;
	}

        memset(&dest_addr, 0, sizeof(struct sockaddr_nl));
        dest_addr.nl_family = AF_NETLINK;
        dest_addr.nl_pid = 0; /* Kernel */
        dest_addr.nl_groups = 0;

        nlm = (struct nlmsghdr *)malloc(NLMSG_SPACE(sizeof(inf)));
        if (nlm == NULL) {
                printf("Mem allocation failed\n");
                return -1;
        }

	nlm->nlmsg_len = NLMSG_SPACE(sizeof(inf));
        nlm->nlmsg_pid = getpid();
        nlm->nlmsg_flags = 0;

        memcpy(NLMSG_DATA(nlm), &inf, sizeof(spdm_cfg_t));
        iov.iov_base = (void *)nlm;
        iov.iov_len = nlm->nlmsg_len;

        memset(&nlmsg, 0, sizeof(nlmsg));
        nlmsg.msg_name = (void *)&dest_addr;
        nlmsg.msg_namelen = sizeof(dest_addr);
        nlmsg.msg_iov = &iov;
        nlmsg.msg_iovlen = 1;

        if (sendmsg(s_d, &nlmsg, 0) < 0) {
                printf("ERROR: sendmsg over netlink sock failed!!\n");
                return -1;
        }

        /* Read message from kernel */
        memset(nlm, 0, NLMSG_SPACE(sizeof(inf)));
        recvmsg(s_d, &nlmsg, 0);

	if (cmd == SPDM_GET) {
		int i=0, j=0;
		unsigned long long *line;

		memcpy(&inf, NLMSG_DATA(nlm), sizeof(inf));
		if (inf.ret != SPDM_CONF_SUCCESS) {
			spdm_display(inf);
			return 0;
		}

		line = (unsigned long long *)inf.data;
		printf("\n###SPDM Table ###\n\n");
		for (i=0; i<inf.data_len; i++) {
			printf("Entry %d -\n", i);
			for (j=0; j<8; j++, line++) {
				unsigned long long disp = 0;
				int sz = 64;
				//BIT_SWAP(*line, disp, sz);
				//printf("Line %d - 0x%llx\n", j, disp);
				printf("Line %d - 0x%llx\n", j, *line);
			}
		}
	} else {
		memcpy(&inf, NLMSG_DATA(nlm), sizeof(inf));
		spdm_display(inf);
	}

	close(s_d);
	return 0;
}
