#ifndef __TG3_COMPAT_H__
#define __TG3_COMPAT_H__

typedef void irqreturn_t;
#define IRQ_NONE
#define IRQ_HANDLED
#define IRQ_RETVAL(x)

typedef irqreturn_t (*irq_handler_t)(int, void*, struct pt_regs *);

#ifndef __iomem
#define __iomem
#endif

#ifndef module_param
#define module_param(v,t,p) MODULE_PARM(v, "i");
#endif

#ifndef mmiowb
#define mmiowb()
#endif

#ifndef MODULE_VERSION
#define MODULE_VERSION(_version)
#endif

static inline void *netdev_priv(struct net_device *dev)
{
	return dev->priv;
}

#ifndef pci_dma_sync_single_for_cpu 
#define pci_dma_sync_single_for_cpu pci_dma_sync_single
#define pci_dma_sync_single_for_device pci_dma_sync_single
#endif

#ifndef NETDEV_TX_OK
#define NETDEV_TX_OK 0 /* driver took care of the packet */
#endif

#ifndef NETDEV_TX_BUSY
#define NETDEV_TX_BUSY 1 /* driver tx path was busy */
#endif

#ifndef NETDEV_TX_LOCKED
#define NETDEV_TX_LOCKED -1 /* driver tx lock was already taken */
#endif

#ifdef NETIF_F_TSO
#ifndef NETIF_F_GSO
#define gso_size tso_size
#define gso_segs tso_segs
#endif
#ifndef NETIF_F_TSO6
#define NETIF_F_TSO6    0
#define BCM_NO_TSO6     1
#endif

#if (LINUX_VERSION_CODE < 0x020616)
static inline int skb_transport_offset(const struct sk_buff *skb)
{
		    return (int) (skb->h.raw - skb->data);
}

static inline struct iphdr *ip_hdr(const struct sk_buff *skb)
{
		    return skb->nh.iph;
}

static inline unsigned int ip_hdrlen(const struct sk_buff *skb)
{
		    return ip_hdr(skb)->ihl * 4;
}

static inline struct tcphdr *tcp_hdr(const struct sk_buff *skb)
{
		    return skb->h.th;
}

static inline unsigned int tcp_optlen(const struct sk_buff *skb)
{
		    return (tcp_hdr(skb)->doff - 5) * 4;
}
#endif
#endif

#ifndef IRQF_SHARED
#define IRQF_SHARED SA_SHIRQ
#endif

#ifndef IRQF_SAMPLE_RANDOM
#define IRQF_SAMPLE_RANDOM SA_SAMPLE_RANDOM
#endif


#ifndef WARN_ON
#define WARN_ON(condition) do { \
        if (unlikely((condition)!=0)) { \
                printk("Badness in %s at %s:%d\n", __FUNCTION__, __FILE__, __LINE__); \
                dump_stack(); \
        } \
} while (0)
#endif
#define if_mii(_rq)  (struct mii_ioctl_data *) &(_rq)->ifr_ifru;

#if (LINUX_VERSION_CODE < 0x020600)
#define pci_get_device(x, y, z) pci_find_device(x, y, z)
#define pci_get_slot(x, y)  pci_find_slot((x)->number, y)
#define pci_dev_put(x)
#endif

#define pci_set_consistent_dma_mask(...) 0

#ifndef NETIF_F_LLTX
#define NETIF_F_LLTX            4096    /* LockLess TX */
#endif

#ifdef __VMKERNEL_MODULE__
#define spin_lock_irq(_lck)                                                  \
   {                                                                         \
      unsigned long __flags;                                                 \
      spin_lock_irqsave(_lck, __flags);

#define spin_unlock_irq(_lck)                                                \
      spin_unlock_irqrestore(_lck, __flags);                                 \
   }

#define dump_stack(...)
#endif

#if (LINUX_VERSION_CODE < 0x020612)
static inline struct sk_buff *netdev_alloc_skb(struct net_device *dev,
				        unsigned int length)
{
		    struct sk_buff *skb = dev_alloc_skb(length);
			    if (skb)
						        skb->dev = dev;
				    return skb;
}
#endif

#ifndef NETIF_F_GSO
static inline void netif_tx_lock(struct net_device *dev)
{
		    spin_lock(&dev->xmit_lock);
			    dev->xmit_lock_owner = smp_processor_id();
}

static inline void netif_tx_unlock(struct net_device *dev)
{
		    dev->xmit_lock_owner = -1;
			    spin_unlock(&dev->xmit_lock);
}
#endif


#if (LINUX_VERSION_CODE < 0x2060c)
static inline int skb_header_cloned(struct sk_buff *skb) { return 0; }
#endif

#if (LINUX_VERSION_CODE >= 0x20418) && (LINUX_VERSION_CODE < 0x2060c)
static int tg3_set_tx_hw_csum(struct net_device *dev, u32 data)
{
    if (data)
        dev->features |= NETIF_F_HW_CSUM;
    else
        dev->features &= ~NETIF_F_HW_CSUM;

    return 0;
}
#endif

static inline void vlan_group_set_device(struct vlan_group *vg, int vlan_id,
                     struct net_device *dev)
{
    if (vg)
        vg->vlan_devices[vlan_id] = dev;
}

#if (LINUX_VERSION_CODE < 0x2060e)
static inline void tg3_enable_intx(struct pci_dev *pdev)
{
    u16 pci_command;

    pci_read_config_word(pdev, PCI_COMMAND, &pci_command);
    if (pci_command & PCI_COMMAND_INTX_DISABLE)
        pci_write_config_word(pdev, PCI_COMMAND,
                      pci_command & ~PCI_COMMAND_INTX_DISABLE);
}
#endif

#if 1 // __VMKERNEL_MODULE__
#define TG3_FLAG_IN_RESET_TASK          0x04000000
#endif



#if (LINUX_VERSION_CODE <= 0x020600)
#define schedule_work(x)    schedule_task(x)
#define work_struct     tq_struct
#define INIT_WORK(x, y, z)  INIT_TQUEUE(x, y, z)
#endif

#endif /* __TG3_COMPAT_H__ */
