/*
** File: pegnet_inc.h
** Description:
**  This header contains definitions used by the pegnet code.
*/

#ifndef __PEGNET_INC_H
#define __PEGNET_INC_H

#include <linux/socket.h> /* struct sockaddr */
#include <linux/net.h> /* struct socket */
#include <linux/in.h> /* struct sockaddr_in */
#include <linux/skbuff.h> /*struct sk_buff */


#include <pegnet_config.h>

/*
** Messages from the host to the card's network stack go through
** the following [major, minor] pegos queue.
*/
#define PEGNET_H2C_MAJOR        UNM_MSGQ_SQM_TYPE1
#define PEGNET_H2C_MINOR        PEGOS_PEGNET_CORE

#if !defined(PEGNET_QUEUE_ADDR_T)
#define PEGNET_QUEUE_ADDR_T
/*
** Identity (address) of the queue.
** NB: See also linux/net.h
*/
typedef union pegnet_queue_addr_s {
    struct {
        __uint32_t
#if defined(__LITTLE_ENDIAN_BITFIELD)
            major: 4,      /* Major queue number (0-15) */
            minor: 18,      /* Minor queue number (0-256K) */
            side:1;
#elif defined(__BIG_ENDIAN_BITFIELD)
            side:1,
            minor: 18,      /* Minor queue number (0-256K) */
            major: 4;      /* Major queue number (0-15) */
#else
#error  "Please fix <asm/byteorder.h>"
#endif
    };
    __uint32_t word;
} pegnet_queue_addr_t;
#endif

#if defined(__LITTLE_ENDIAN_BITFIELD)
#define null_queue(qid) (((*((__uint32_t *)&(qid))) & 0x7fffff) == 0)
#elif defined(__BIG_ENDIAN_BITFIELD)
#define null_queue(qid) (((*((__uint32_t *)&(qid))) & 0xfffffe00) == 0)
#else
#error  "Please fix <asm/byteorder.h>"
#endif

#define PEGNET_HOST_ADDR (1ULL<<63)

#if (UNM_X_HARDWARE==UNM_X_ASIC)
/* Native build */
#define PEGNET_XPTR_ADDR(A) ((void*)(((__uint64_t)(A)) & ~(1ULL<<63)))
#define PEGNET_IS_NONLOCAL_ADDR(A) (((__uint64_t)(A)) & (1ULL<<63))
#define PEGNET_MARK_NONLOCAL(A) (((__uint64_t)(A)) | (1ULL<<63))
#elif (UNM_X_HARDWARE==UNM_X_FPGA)
/* x86 Sim */
#define PEGNET_IS_NONLOCAL_ADDR(A) ((((__uint32_t)(A)) & (1<<31)))
#define PEGNET_XPTR_ADDR(A) ((void*)(((__uint32_t)(A)) & ~(1<<31)))
#define PEGNET_MARK_NONLOCAL(A) (((__uint32_t)(A)) | (1ULL<<31))
#elif (UNM_X_HARDWARE==UNM_X_SIMULATED)
/* pure simulation */
#define PEGNET_IS_NONLOCAL_ADDR(A) 0
#define PEGNET_XPTR_ADDR(A) (A)
#define PEGNET_MARK_NONLOCAL(A) (A)
#else
#error Unknown hardware platform
#endif

/*
 * Well - known object queues
 */
#define PEGOS_PEGNET_CORE	(UNM_MSGQ_TYPE1_FIRST_AVAIL+3)

#define PEGOS_LD_Q0		16 /*  64k -> queue 0 */
#define PEGOS_PAGE_SIZE		(1 << PEGOS_LD_Q0)

#endif  /* __PEGNET_INC_H */
