/*
 *	Adaptec AAC series RAID controller driver
 *	(c) Copyright 2001 Red Hat Inc.	<alan@redhat.com>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * This file is for backwards compatibility with older kernel versions
 */
#include <linux/version.h>

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,9)) && (!defined(SCSI_HAS_SSLEEP))
#define ssleep scsi_sleep
#endif
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0))
 typedef unsigned long dma_addr_t;
#include <linux/kcomp.h>
#define PCI_ANY_ID (~0)
#define SCSI_DATA_UNKNOWN	0
#define SCSI_DATA_WRITE		1
#define SCSI_DATA_READ		2
#define SCSI_DATA_NONE		3
 /* Sigh ... a *lot* more needs to be done for this Grandpa */
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,5,0))
#include <linux/time.h>
static inline unsigned long get_seconds(void)
{
	struct timeval now;
	do_gettimeofday(&now);
	return now.tv_sec;
}
#define scsi_host_template SHT
#define DMA_BIDIRECTIONAL	SCSI_DATA_UNKNOWN
#define DMA_TO_DEVICE		SCSI_DATA_WRITE
#define DMA_FROM_DEVICE		SCSI_DATA_READ
#define DMA_NONE		SCSI_DATA_NONE
#define iminor(x) MINOR(x->i_rdev)
#define scsi_host_alloc(t,s) scsi_register(t,s)
#define scsi_host_put(s) scsi_unregister(s)
#ifndef pci_set_consistent_dma_mask
#define pci_set_consistent_dma_mask(d,m) 0
#endif
#define scsi_scan_host(s)
#define scsi_add_host(s,d) 0
#if (defined(MODULE))
# define scsi_remove_host(s) \
	for (index = 0; (index < aac_count) \
	 || !aac_devices[index] \
	 || (aac_devices[index] == (struct aac_dev *)s->hostdata); ++index); \
	if (index < aac_count) scsi_unregister_module(MODULE_SCSI_HA,s->hostt)
#else
# define scsi_remove_host(s)
#endif
#if (!defined(__devexit_p))
# if (defined(MODULE))
#  define __devexit_p(x) x
# else
#  define __devexit_p(x) NULL
# endif
#endif
#define __user
#endif
#if ((LINUX_VERSION_CODE < KERNEL_VERSION(2,6,6)) && (!defined(SCSI_HAS_SCSI_DEVICE_ONLINE)))
#define scsi_device_online(d) ((d)->online)
#endif
#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,6,9))
#define __iomem
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,18)) && (LINUX_VERSION_CODE != KERNEL_VERSION(2,4,9)) && (LINUX_VERSION_CODE != KERNEL_VERSION(2,4,13))
# define dma_handle ptr
#endif

#if (LINUX_VERSION_CODE < KERNEL_VERSION(2,4,11))
#include <linux/blk.h>

static inline unsigned int block_size(kdev_t dev)
{
	int retval = BLOCK_SIZE;
	int major = MAJOR(dev);

	if (blksize_size[major]) {
		int minor = MINOR(dev);
		if (blksize_size[major][minor])
			retval = blksize_size[major][minor];
	}
	return retval;
}
#endif

#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2,4,7))

#ifndef COMPLETION_INITIALIZER

#include <linux/wait.h>

struct completion {
	unsigned int done;
	wait_queue_head_t wait;
};
#define COMPLETION_INITIALIZER(work) \
	{ 0, __WAIT_QUEUE_HEAD_INITIALIZER((work).wait) }

#define DECLARE_COMPLETION(work) \
	struct completion work = COMPLETION_INITIALIZER(work)
#define INIT_COMPLETION(x)	((x).done = 0)

static inline void init_completion(struct completion *x)
{
	x->done = 0;
	init_waitqueue_head(&x->wait);
}
#endif

#ifndef complete_and_exit
static inline void complete_and_exit(struct completion *comp, long code)
{
	/*
	if (comp)
		complete(comp);

	do_exit(code);
	*/
}
#endif

#endif

#if (LINUX_VERSION_CODE <= KERNEL_VERSION(2,4,2))

static inline void scsi_set_pci_device(struct Scsi_Host *SHpnt,
                                       struct pci_dev *pdev)
{
//	SHpnt->pci_dev = pdev;
}

static inline void wait_for_completion(struct completion *x)
{
	spin_lock_irq(&x->wait.lock);
	if (!x->done) {
		DECLARE_WAITQUEUE(wait, current);

#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
		wait.flags |= WQ_FLAG_EXCLUSIVE;
#endif
		__add_wait_queue_tail(&x->wait, &wait);
		do {
			__set_current_state(TASK_UNINTERRUPTIBLE);
			spin_unlock_irq(&x->wait.lock);
			schedule();
			spin_lock_irq(&x->wait.lock);
		} while (!x->done);
		__remove_wait_queue(&x->wait, &wait);
	}
	x->done--;
	spin_unlock_irq(&x->wait.lock);
}

static inline int pci_set_dma_mask(struct pci_dev *dev, dma_addr_t mask)
{
#if (LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,0))
    dev->dma_mask = mask;
#endif

    return 0;
}

#endif
    
