/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/*
 *
 *  Common Debug code for driver
 *
 */

/*  The beep code needed debugging firmware hang */
#define __beep() asm("movb $0x3,%al; outb %al,$0x61") 
#define __nobeep() asm("movb $0x0,%al; outb %al,$0x61") 
#define __beepwait() scsi_sleep(50)
#define __beeponce() __beep(); __beepwait(); __nobeep()

/*  Assertions and KDB codes  */
#ifdef ASA72XX_DEBUG
/*#define KDBENTER() __asm__ volatile ("int $3");*/
/*#define ASSERT() KDBENTER() */
#define KDBENTER() panic()
#define ASSERT(x)
#else
#define KDBENTER() panic()
#define ASSERT(x)
#endif

#ifdef ASA72XX_DBG_SERIAL

   #ifdef printk
      #undef printk
   #endif 

   #ifdef ASA72XX_DEBUG
      #define printk ser_printk
   #else
      #ifdef ASA72XX_DBG_FUNC
          #define printk ser_printk
      #endif
   #endif
/*
 *
 *  Below code taken from linux/drivers/scsi/gdth.c
 *  and is unmodified.
 */

/*  The serial port code */
#define MAX_SERBUF 160
static void ser_init(void);
static void ser_puts(char *str);
static void ser_putc(char c);
static int  ser_printk(const char *fmt, ...);
static char strbuf[MAX_SERBUF + 1];

#ifdef __COM2__
#define COM_BASE 0x2f8
#else
#define COM_BASE 0x3f8
#endif

static void ser_init()
{
	unsigned port = COM_BASE;

	outb_p(0x80, port + 3);
	outb(0, port + 1);
	/*
		formula is 115200/x = baud.
		so 115200/6 = 19200 Baud,
		if 9600: outb(12, port)
	*/
	outb(1, port);
	outb(3, port + 3);
	outb(0, port + 1);
	/*
	ser_putc('I');
	ser_putc(' ');
	*/
}

static void
ser_puts(char *str)
{
	char *ptr;

	ser_init();

	for (ptr = str ; *ptr ; ptr++)
	{
		ser_putc(*ptr);
	}
}

static void
ser_putc(char c)
{
	unsigned port = COM_BASE;

	while ((inb(port + 5) & 0x20) == 0)
		continue;

	outb(c, port);

	if (c == 0x0a)
	{
		while ((inb(port + 5) & 0x20) == 0)
			continue;

		outb(0x0d, port);
	}
}

static int ser_printk(const char *fmt, ...)
{
	va_list args;
	int i;

	va_start(args, fmt);
	i = vsprintf(strbuf, fmt, args);
	ser_puts(strbuf);
	va_end(args);
	return i;
}
#endif

/*
 * Debugging Macros.
 */ 
#ifdef ASA72XX_DEBUG

extern U32	debug_level;

#define PDEBUG(debug_mask, fmt, args...){\
	if (debug_mask & debug_level)\
	{\
		printk("<d>Function: %s  Line: %d ", __FUNCTION__,__LINE__);\
		printk(fmt, ##args);\
		printk("</d>");\
	}\
}

#define PCRIT(debug_mask, fmt, args...){\
	if (debug_mask & debug_level)\
	{\
		printk("<c>");\
		printk(fmt, ##args);\
		printk("</c>");\
	}\
}

#define PERROR(fmt, args...) printk(fmt, ##args)
#define PINFO(fmt, args...) printk(fmt, ##args)
#define PWARN(fmt, args...) printk(fmt, ##args)
static void 	adpt_print_queue(adpt_cmnd **pQueueHead);
	
#else

#define PDEBUG(debug_mask, fmt, args...)	/**/
#define PCRIT(debug_mask, fmt, args...)	/**/
#define PERROR(fmt, args...) printk(fmt, ##args)
#define PINFO(fmt, args...) 
#define PWARN(fmt, args...) 

#endif /* ifdef ASA72XX_DEBUG */

#ifdef ASA72XX_DBG_FUNC

#define BEGIN		printk("<%s>", __FUNCTION__)
#define END		printk("</%s>", __FUNCTION__)
#define ERROR_END	printk("<!- %s (%d)>", __FUNCTION__, __LINE__)

#else

#define BEGIN		/**/
#define END		/**/
#define ERROR_END	/**/

#endif /* ifdef ASA72XX_DBG_FUNC */

/*
 * Debugging switch level.
 */ 
#define DBG_ALL		0x0fff		/* All DBG msg turned on, except ISR */
#define DBG_NONE	0x0000

#define DBG_INIT	0x0001		/* Driver initialization messages */
#define DBG_UNLOAD	0x0002		/* Driver unload/shutdown messages */
#define DBG_SCSI	0x0004		/* SCSI command related messages */
#define DBG_I2O_POST	0x0008		/* SCSI command related messages */
#define DBG_ERR_HNDL	0x0010		/* Error recovery routine messages */
#define DBG_TIMEOUT	0x0020		/* Messages timeout */
#define DBG_LCT		0x0040		/* LCT related messages */
#define DBG_REPARSE	0x0080		/* LCT related messages for REPARSE*/
#define DBG_POST	0x0100		/* Error message of posting I20 msg
					 * to IOP */
#define DBG_DEVICE	0x0200		/* I2O devices error messages */
#define DBG_IOCTL	0x0400		/* IOCTL related messages */
#define DBG_EVENT	0x0800		/* Private Event related message */
#define DBG_ISR		0x1000		/* Interrupt Service Routine message */
#define DBG_MISC	0x2000		/* Misc. Informational messages */

#define CRIT_Q	        0x4000		/* Critical Queue messages */

#define DBG_VOLUME_0    DBG_NONE        /* Define runtime volume level */
#define DBG_VOLUME_1    DBG_ERR_HNDL
#define DBG_VOLUME_2    DBG_VOLUME_1 | DBG_TIMEOUT
#define DBG_VOLUME_3    DBG_VOLUME_2 | DBG_LCT
#define DBG_VOLUME_4    DBG_VOLUME_3 | DBG_INIT | DBG_UNLOAD
#define DBG_VOLUME_5    DBG_VOLUME_4 | DBG_ISR
#define DBG_VOLUME_6    DBG_VOLUME_5 | CRIT_Q 
#define DBG_VOLUME_7    DBG_VOLUME_6 | DBG_EVENT 
#define DBG_VOLUME_8    DBG_ALL 
#define YES 1
#define NO  0

#define ASA72XX_STABLE_CODE NO

#if ASA72XX_STABLE_CODE
 #define RETRY_CODE NO
#else
 #define RETRY_CODE YES 
#endif

