/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef IOCDEF_H
#define IOCDEF_H

#ifdef ARIES
#define      MAX_TARGETS_ALLOWED      80
#else
#define      MAX_TARGETS_ALLOWED      6    
#endif
#define          USER_MAX_TARGETS_ALLOWED   (MAX_TARGETS_ALLOWED/2)

#define MAX_ITCP_CONNECTIONS     4
#define MAX_ISCSI_SESSIONS       1

#define MAX_INITIATOR_PORTALS    1         /* maximum number of portals that can be created */
                                                /* for an initiator or HBA                             */

#ifdef DRAFT08
#define ISCSI_VERSION            "ISCSI v.8\0"
#elif defined DRAFT13
#define ISCSI_VERSION            "ISCSI v.13\0"
#elif defined DRAFT15
#define ISCSI_VERSION            "ISCSI v.15\0"
#else
#define ISCSI_VERSION            "ISCSI v.9\0"
#endif

#define      MAX_LUNS                 128
#define      MAX_LUN_SIZE             8

#ifdef ARIES
#define      TARGET_MAX_NAME_LEN      256       /* IP4 address + : + portNumber */ 
#define      INITIATOR_MAX_NAME_LEN   256
#else
#define      TARGET_MAX_NAME_LEN      64        /* IP4 address + : + portNumber */ 
#define      INITIATOR_MAX_NAME_LEN   64
#endif



#ifdef DRAFT08
#define      ISID_LENGTH                   2
#else
#define      ISID_LENGTH                   6
#endif

#define DIGEST_KEY_LEN      12
#define SECURITY_KEY_LEN    30        /* DO NOT change SECURITY_KEY_LEN value, this */
                                           /* value has dependency on autherization algorithm */


#ifdef ARIES
#define      MAX_USER_ASSIGNED_STRING INITIATOR_MAX_NAME_LEN
#else
#define      MAX_USER_ASSIGNED_STRING 64 
#endif

#define NODE_MAX_NAME_LEN           256

#define      MAX_MANUFACTURER_STRING       64
#define      MAX_MODEL_NUMBER_STRING       16
#define      MAX_CTLR_DESCRIPTION_STRING   64
#define      MAX_CTLR_SERIALNO_STRING      16
#define      MAX_EEPROM_VERSION_STRING     8
#define      MAX_FW_VERSION_STRING         12
#define      MAX_IP_VERSION_STRING         7
#define	     MAX_ISCSI_VERSION_STRING	   16
#define      MAX_SCOPE_LIST_LENGTH         256
#define      MAX_QUERY_LIST_LENGTH         256
#define      MAX_NUM_TIMEOUTS              5
#define      IPV6_ADDRESS_LEN              16
#define      IPV4_ADDRESS_LEN              4
#define      IPV4_SUBNET_MASK_LEN          4
#define      IPV6_SUBNET_MASK_LEN          16

//IOCTL Command Opcodes
#define      CONTROLLER_ATTRIBUTES         0x20
#define      ETHERNET_PORT_DETAILS         0x21
#define      SCSI_CONFIGURATION            0x22		/* not implemented */
#define      GET_SET_IP_ADDRESS            0x23
#define      DIRECTORY_OF_ES_TARGETS       0x24		/* not implemented */
#define      RESCAN_SCSI_BUS               0x25		/* not implemented */
#define      READ_WRITE_EEPROM             0x26
#define      CLEAR_EVENT_LOG               0x27
#define      READ_EVENT_LOG                0x28
#define      REPORT_LUNS                   0x29		/* not implemented */
#define      TARGET_ZONING_INFO            0x2a		/* not implemented */	
#define      INITIATOR_ZONING_INFO         0x2b
#define      GET_SET_TIME                  0x2f
#define      HBA_ISCSI_NAME                0x30

#define      DEVICE_OPEN                   0x31		/* not implemented */
#define      DEVICE_CLOSE                  0x32		/* not implemented */
#define      GET_SET_DISCOVERY_PARAM       0x40

#define      RESET_IOP                     0x66		/* not implemented */

#define      HOST_CONFIGURATION_VERIFIED   0x70
#define      ARP_CACHE_TABLE               0x71
#define      ROUTE_TABLE                   0x72
#define      PORT_STATISTICS               0x73
#define      ISCSI_CONNECTION_INFO         0x74 
#define      GET_DEVICE_LIST               0x75
#define      RESCAN_TARGETS                0x76
#define      DNS_SERVER_CMD                0x77 

#define      DRIVER_SPECIFIC_IOCTL         0x7F //page code for OS specific IOCTL's
#define      GET_NUM_CONTROLLERS           0x01
#define      GET_CONTROLLER_INFO           0x02
#define      GET_BTL_MAPPING               0x03

/******************************************
 * 
 * Error Codes
 *
 ******************************************/

// status for IOCTL_SET_ETHERNET_PORT_DETAILS_REPLY 
#define      UNKNOWN_PORT                  0x84

//status for ISCSI Connection Info
#define      NO_CONNECTION_INFO            0x90 // Initiator ethernet port disabled, no connection info available.

//status for GET_DEVICE_LIST
/* reasons of error status:
         * a. Initiator ethernet port is disabled
         * b. No Targets are connected.
         * c. Targets have no LUNS connected to them.
*/
#define      NO_DEVICE_LIST                0x91

//status for RESCAN_TARGETS 
//#define      OPEN_SESSION_FAILED           0x92

//status for RESCAN_TARGETS 
#define      OPEN_SESSION_FAILED           0x98
#define      SESSION_NOT_OPEN	           0x99	 /* if target is configured but ip may not be resolved */
											     /* then cannot open session during rescan targets */
												 /* also used for rescanning luns on a target */
												 /* if target session is not open then cannot scan luns */
												
#define      NO_LINK			           0x9a	/* also used for rescaning luns on a target */
												/* For rescan luns if target is not connected */
												/* this error is returned in response header status */
												/* field.										*/

//status for rescanning Luns
#define		 TARGET_NOT_FOUND			   0x9b

/* rescan Targets */
#define		CONFIG_VERIFICATION_FAILED	   0x9c	/* cannot perform rescan targets since configuration */
												/* cannot be verified on this initiator (mainly cannot */
												/* identify initiator, machine name saved in the flash rom */
												/* is not same as the current machine name. The initiator HBA */
												/* may have been swapped from other system.				*/
#if LINUX_VERSION_CODE == KERNEL_VERSION(2,4,7)
#define      STATUS_MASK                   0x7F
#endif

//IOCTL DIRECTION BIT
#define      GET_DATA            0x00
#define      SET_DATA            0x01
#define      DIRECTION_BIT_MASK  0x7F

#define      TRUE      1
#define      FALSE     0

#define      BYTE512_BLOCK  0x200
#define      K64_BLOCK      0x10000



/********************************************************************************+ 
 *   ES_IP_VERSION
-********************************************************************************/
typedef enum _ES_IP_VERSION{
    IPV4,
    IPV6
} ES_IP_VERSION;

#define  ES_CURRENT_IP_VERSION             IPV4

#define  CURRENT_IP_VERSION                IPV4

#endif   /* ifndef IOCDEF_H */


