/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef _dpti_ioctl_h
#define _dpti_ioctl_h

#include "asa72xx_iocdef.h"

/* 
 * IOCTL interface commands
 */
#ifndef _IOWR
# define _IOWR(x,y,z)	(((x)<<8)|y)
#endif
#ifndef _IOW
# define _IOW(x,y,z)	(((x)<<8)|y)
#endif
#ifndef _IOR
# define _IOR(x,y,z)	(((x)<<8)|y)
#endif
#ifndef _IO
# define _IO(x,y)	(((x)<<8)|y)
#endif
/* EATA PassThrough Command	*/
#define EATAUSRCMD      _IOWR('D',65,EATA_CP)
/* Set Debug Level If Enabled	*/
#define DPT_DEBUG       _IOW('D',66,int)
/* Get Signature Structure	*/
#define DPT_SIGNATURE   _IOR('D',67,dpt_sig_S)
#if defined __bsdi__
#define DPT_SIGNATURE_PACKED   _IOR('D',67,dpt_sig_S_Packed)
#endif
/* Get Number Of DPT Adapters	*/
#define DPT_NUMCTRLS    _IOR('D',68,int)
/* Get Adapter Info Structure	*/
#define DPT_CTRLINFO    _IOR('D',69,CtrlInfo)
/* Get Statistics If Enabled	*/
#define DPT_STATINFO    _IO('D',70)
/* Clear Stats If Enabled	*/
#define DPT_CLRSTAT     _IO('D',71)
/* Get System Info Structure	*/
#define DPT_SYSINFO     _IOR('D',72,sysInfo_S)
/* Set Timeout Value		*/
#define DPT_TIMEOUT     _IO('D',73)
/* Get config Data  		*/
#define DPT_CONFIG      _IO('D',74)
/* Get Blink LED Code	        */
#define DPT_BLINKLED    _IOR('D',75,int)
/* Get Statistical information (if available) */
#define DPT_STATS_INFO        _IOR('D',80,STATS_DATA)
/* Clear the statistical information          */
#define DPT_STATS_CLEAR       _IO('D',81)
/* Get Performance metrics */
#define DPT_PERF_INFO        _IOR('D',82,dpt_perf_t)
/* Send an I2O command */
#define I2OUSRCMD	_IO('D',76)
/* Inform driver to re-acquire LCT information */
#define I2ORESCANCMD	_IO('D',77)
/* Inform driver to reset adapter */
#define I2ORESETCMD	_IO('D',78)
/* See if the target is mounted */
#define DPT_TARGET_BUSY	_IOR('D',79, TARGET_BUSY_T)

/* ASA72XX Management IOCTL Command */
#define	ASA72XX_MGMT_IOCTL_CMD		0x4580	
#define	ASA72XX_NUM_CTRLS		0x4581

/* ES IOCTL Direction bits */
#define	IOCTL_SET_DATA	1
#define	IOCTL_GET_DATA	0
#define	HBA_HANDLE	0

/* Required for Persistent Binding */
#define USER_NAME_LEN	128
#define CHAP_NAME_LEN	128
#define USER_SECRET_LEN	64
#define CHAP_SECRET_LEN	64

/* Structure Returned From Get Controller Info */
typedef struct {
	uCHAR    state;            /* Operational state               */
	uCHAR    id;               /* Host adapter SCSI id            */
	int      vect;             /* Interrupt vector number         */
	int      base;             /* Base I/O address                */
	int      njobs;            /* # of jobs sent to HA            */
	int      qdepth;           /* Controller queue depth.         */
	int      wakebase;         /* mpx wakeup base index.          */
	uLONG    SGsize;           /* Scatter/Gather list size.       */
	unsigned heads;            /* heads for drives on cntlr.      */
	unsigned sectors;          /* sectors for drives on cntlr.    */
	uCHAR    do_drive32;       /* Flag for Above 16 MB Ability    */
	uCHAR    BusQuiet;         /* SCSI Bus Quiet Flag             */
	char     idPAL[4];         /* 4 Bytes Of The ID Pal           */
	uCHAR    primary;          /* 1 For Primary, 0 For Secondary  */
	uCHAR    eataVersion;      /* EATA Version                    */
	uLONG    cpLength;         /* EATA Command Packet Length      */
	uLONG    spLength;         /* EATA Status Packet Length       */
	uCHAR    drqNum;           /* DRQ Index (0,5,6,7)             */ 
	uCHAR    flag1;            /* EATA Flags 1 (Byte 9)           */
	uCHAR    flag2;            /* EATA Flags 2 (Byte 30)          */
} CtrlInfo;

typedef struct {
	uSHORT 	length;		// Remaining length of this
	uSHORT 	drvrHBAnum;	// Relative HBA # used by the driver
	uLONG 	baseAddr;	// Base I/O address
	uSHORT 	blinkState;	// Blink LED state (0=Not in blink LED)
	uCHAR 	pciBusNum;	// PCI Bus # (Optional)
	uCHAR 	pciDeviceNum;	// PCI Device # (Optional)
	uSHORT 	hbaFlags;	// Miscellaneous HBA flags
	uSHORT 	Interrupt;	// Interrupt set for this device.
#if (defined(_DPT_ARC))
	uLONG 		baseLength;
	ADAPTER_OBJECT 	*AdapterObject;
	LARGE_INTEGER 	DmaLogicalAddress;
	PVOID 		DmaVirtualAddress;
	LARGE_INTEGER 	ReplyLogicalAddress;
	PVOID 		ReplyVirtualAddress;
#else
	uLONG reserved1;	// Reserved for future expansion
	uLONG reserved2;	// Reserved for future expansion
	uLONG reserved3;	// Reserved for future expansion
#endif
} drvrHBAinfo_S;

typedef struct TARGET_BUSY {
  uLONG channel;
  uLONG id;
  uLONG lun;
  uLONG isBusy;
} TARGET_BUSY_T;

#endif

#ifndef _es_ioctl_h
#define _es_ioctl_h

#define	CONTROLLER_ATTRIBUTES		0x20
#define TARGET_LIST			0x2B
#define	HOST_CONFIG_VERIFY		0x70
#define CONFIG_ALREADY_VERIFIED		0x87
#define	GET_DEVICE_LIST			0x75

#define	DRIVER_SPECIFIC_IOCTL		0x7F
#define	GET_NUM_CONTROLLERS		0x01
#define	GET_CONTROLLER_INFO		0x02
#define	GET_BTL_MAPPING			0x03

#define	AUTH_DATA_LEN			80
#define MAX_TARGETS_SUPPORTED		40
#define SESSION_ID_LEN			6

typedef	struct	_ioctl_request_header {
	U8	pagecode:7;
	U8	rwbit:1;
	U8	reserved1;
	U16	reserved2;
	U16	expectedlength;
	U8	reserved3;
	U8	reserved4;
	U16	devicehandle;
	U16	reserved5;
	U32	reserved6;
} ioctl_request_header, *pioctl_request_header;

typedef	struct	_ioctl_response_header {
	U8	pagecode:7;
	U8	rwbit:1;
	U8	reserved1;
	U16	pagelength;
	U16	expectedlength;
	U8	status;
	U8	additionalstatus;
	U16	devicehandle;
	U16	reserved2;
	U32	reserved3;
} ioctl_response_header, *pioctl_response_header;

typedef	union	_ioctl_header {
	ioctl_request_header	ioctlrequestheader;
	ioctl_response_header	ioctlresponseheader;
} ioctl_header, *pioctl_header;

typedef	struct _get_controller_attributes_reply {
	S8	eepromversionstring[MAX_EEPROM_VERSION_STRING];
	S8	userassignedname[MAX_USER_ASSIGNED_STRING];
	S8	manufacturername[MAX_MANUFACTURER_STRING];
	S8	controllermodelnumber[MAX_MODEL_NUMBER_STRING];
	S8	controllerdscription[MAX_CTLR_DESCRIPTION_STRING];
	S8	controllerserialnumber[MAX_CTLR_SERIALNO_STRING];
	S8	ipversionstring[MAX_IP_VERSION_STRING];
	S8	firmwareversionstring[MAX_FW_VERSION_STRING];
	U16	romchecksum;
	U8	deviftype:4;
	U8	numberofdevicesideports:4;
	U8	hostiftype:4;
	U8	numberofhostsideports:4;
	U16	pcivendorid;
	U16	pcideviceid;
	U16	pcisubvendorid;
	U16	pcisubsystemid;
	U8	reserved1;
	U32	uniqueid;
	U8	isidstart[6];
	U16	maxsessions;
} get_controller_attributes_reply, *pget_controller_attributes_reply;

typedef	struct _get_controller_attributes {
	ioctl_header			ioctlheader;
	get_controller_attributes_reply	getctlrattribreply;
} get_controller_attributes, *pget_controller_attributes;

typedef struct _ioctl_get_set_time {
	ioctl_header	ioctlheader;
	U32		time;
	S8		time_zone[4];
	U8		dst:1;
	U8		reserved:7;
	U8		reserved1[15];
} ioctl_get_set_time, *pioctl_get_set_time;	
	
typedef	struct	_host_config_verification {
	ioctl_header	ioctlheader;
	U8		VerificationMismatched;
	U8		reserved[3];
} host_config_verification, *phost_config_verification;	

typedef	struct	_controller_info {
	U16	pciBusNum;
	U16	pciDeviceNum;
	U16	pciFunctionNum;
	U32	pciBaseAddr;
	U8	pciIntrVector;
	S8	driverVersion[12];
	S8	driverName[256];
} controller_info, *pcontroller_info;

typedef	struct	_ip_address_format {
	U16	sizeofstructure;
	U8	reserved1;
	U8	ipversion;
	U8	ipaddress[IPV6_ADDRESS_LEN];
	/* changed post-b89
	 * U8	subnetmask[IPV6_SUBNET_MASK_LEN];
	*/
} ip_address_format, *pip_address_format;

#pragma pack(push,1)
typedef struct _ioctl_target_info {
   	ip_address_format   	ip_address;
	// This is required as the latest FW treats IP address Format
	// as a union of multiple things
	U8			pad_data[IPV6_ADDRESS_LEN];
   	U16        		port_number;
   	U8             		session_id[SESSION_ID_LEN];
   	U16		  	reserved_pad1;
   	U8             		target_name[NODE_MAX_NAME_LEN];   /* Target ISCSI name */
    	U8            		initial_r2t;    /*   <yes|no> default=yes */
    	U8                 	immediate_data;  /*    <yes|no> default=yes */
    	U8                 	header_digest;/*<enable (set to 1)/disable (set to 0)> flag */
    	U8                 	data_digest;/* <enable (set to 1)/disable (0)> flag */
    	U32           		max_send_DS_length; 
    	U32           		max_recv_DS_length;/*<1-to-65535> default=128 */
    	U32           		first_burst_length; /*<1-to-65535> default=128 units */
    	U32           		max_burst_length;/*<1-to-65535> default=512 units */
   	U8             		target_auth_required;/* <yes|no> default=no              */
   	U8             		reserved_pad2[3];
   	U8  			auth_data[AUTH_DATA_LEN]; /*Auth Data flag and buffer */
	// The ioctl.h has more data then just the 80 bytes 
	// 38 bytes have been appended with the new structure
	U8			dummy_compiler_buffer[38];

   /* The Firmware will resolve the Target DNS name name to IP Address. */
   	U8              	target_DNS_name[NODE_MAX_NAME_LEN]; /* name of the Target dns name*/
   	U8             		ip_resolved; /* 1 => resolved, 0 -> fail to resolve */
   	U8             		io_retry_count; /*from 0 to 10 retries with a default of 1*/
   	U16            		sessionRecoveryTimeout;   /*from 0 to 600 seconds with a default of 0*/
   	U8             		target_flags;
	U8			reserverd_pad3[3];	
} ioctl_target_info, *pioctl_target_info;

typedef	struct	_ioctl_targetlist_header {
	U16			number_of_entries;
	U8			address_type;
	U8			append:1;
	U8			edit:1;
	U8			delete:1;
	U8			reserved4:5;
} ioctl_targetlist_header, *pioctl_targetlist_header;

typedef	struct	_ioctl_targetlist{
	ioctl_targetlist_header	config_table;
	ioctl_target_info	target_list[MAX_TARGETS_SUPPORTED];
} ioctl_targetlist, *pioctl_targetlist;

typedef struct _lun_entry
{
	U32			tid;
	U8			SRA[MAX_LUN_SIZE];
	ip_address_format	ip_address;	
	U16			port_number;
	U16			reserved1;
	U32			dev_status;
	U16			os_bus;
	U16			os_tgt;
	U16			os_lun;	
	U8			reserved2[6];
	U8              	target_name[256];
}lun_entry, *plun_entry;

typedef struct _device_list
{
	U32			number_of_devices;
	lun_entry		device_list[MAX_LUNS];
}device_list, *pdevice_list;
#pragma pack(pop)

typedef	struct	_get_device_list {
	ioctl_header		ioctlheader;
	device_list		device_list_info;	
} get_device_list, *pget_device_list;	

typedef	struct	_target_list {
	ioctl_header		ioctlheader;
	ioctl_targetlist	target_list_info;	
} get_target_list, *pget_target_list;	

typedef	struct	_device_entry {
	U32			tid;
	U8			sra[MAX_LUN_SIZE];
	ip_address_format	ipaddress;
	U16			portnumber;
	U16         reserved1;
	U32			devstatus;
	U16			osBus;
	U16			osTgt;
	U16			osLun;	
	U8			reserved2[6];
	U8          TargetName[256];
} device_entry, *pdevice_entry;

typedef	struct	_target_device_list {
	U32			numdevices;
	device_entry		deventry[MAX_LUNS];
} target_device_list, *ptarget_device_list;

typedef	struct	_ioctl_get_device_list_reply {
	ioctl_header		ioctlheader;
	target_device_list	tgtdevlist;
} ioctl_get_device_list_reply, *pioctl_get_device_list_reply;

typedef	struct	_btl_entry {
	U16	busno;
	U16	targetid;
	U16	lun;
} btl_entry, *pbtl_entry;

typedef	struct	_target_lun_list {
	target_device_list	tgtdevlist;
	btl_entry		btlentry[MAX_LUNS];
} target_lun_list, *ptarget_lun_list;

typedef	struct	_ioctl_get_btl_mapping {
	ioctl_header		ioctlheader;
	target_lun_list		tgtlunlist;
	btl_entry		btlentry[MAX_LUNS];
} ioctl_get_btl_mapping, *pget_btl_mapping;

#endif
