/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/


#ifndef LINUX_VERSION_CODE
#include <linux/version.h>
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#error "This driver only support kernel 2.4 and greater"
#endif

#include "sys_info.h"

#ifndef _KTHREAD_H
#define _KTHREAD_H
#include <linux/config.h>
#include <linux/version.h>

#include <linux/kernel.h>
#include <linux/sched.h>
#include <linux/tqueue.h>
#include <linux/wait.h>

#include <asm/unistd.h>
#include <asm/semaphore.h>

/* a structure to store all information we need
   for our thread */
typedef struct kthread_struct
{
        /* private data */

        /* Linux task structure of thread */
        struct task_struct *thread;
        /* Task queue need to launch thread */
        struct tq_struct tq;
        /* function to be started as thread */
        void (*function) (struct kthread_struct *kthread);
        /* semaphore needed on start and creation of thread. */
        struct semaphore startstop_sem;

        /* public data */

        /* queue thread is waiting on. Gets initialized by
           init_kthread, can be used by thread itself.
        */
        wait_queue_head_t queue;
        /* flag to tell thread whether to die or not.
           When the thread receives a signal, it must check
           the value of terminate and call exit_kthread and terminate
           if set.
        */
        int terminate;
        /* additional data to pass to kernel thread */
        void *arg;
} kthread_t;

/* prototypes */

/* start new kthread (called by creator) */
void start_kthread(void (*func)(kthread_t *), kthread_t *kthread);

/* stop a running thread (called by "killer") */
void stop_kthread(kthread_t *kthread);

/* setup thread environment (called by new thread) */
void init_kthread(kthread_t *kthread, char *name);

/* cleanup thread environment (called by thread upon receiving termination signal) */
void exit_kthread(kthread_t *kthread);

#endif

/*
 * Generic Types Definition.
 */
typedef char			S8;
typedef short			S16;
typedef int				S32;
typedef long			S32_64;
typedef long long 		S64;

typedef unsigned char		U8;
typedef unsigned short		U16;
typedef unsigned int		U32;
typedef unsigned long		U32_64;
typedef unsigned long long	U64;


/*
 * Function Prototypes
 */
S32 		adpt_proc_info(S8 *buffer, S8 **start, off_t offset,
		  	S32 length, S32 inode, S32 inout);
S32			adpt_detect(Scsi_Host_Template *sht);
S32 		adpt_queue(Scsi_Cmnd *cmd, void (*scsi_done) (Scsi_Cmnd *));
S32 		adpt_abort(Scsi_Cmnd *cmd);
S32 		adpt_reset(Scsi_Cmnd *cmd);
S32 		adpt_release(struct Scsi_Host *host);
S32 		adpt_bios_param(Disk *disk, kdev_t dev, S32 geom[]);
S32 		adpt_bus_reset(Scsi_Cmnd *cmd);
S32 		adpt_device_reset(Scsi_Cmnd *cmd);
const S8 	*adpt_info(struct Scsi_Host *host);


/*
 * Scsi_Host_Template (see hosts.h) - some fields
 * to do with card config are filled in after the card is detected.
 */
#define	ASA72XX_DRIVER_NAME	"asa72xx"

#define MAX_TO_IOP_MESSAGES	210
#define MAX_FROM_IOP_MESSAGES 	MAX_TO_IOP_MESSAGES

/* Need to accomodate 128 CMD
#define MAX_FROM_IOP_MESSAGES 	70
*/

#define SG_LIST_ELEMENTS	16      

#define ASA72XX_MAX_Q_DEPTH	128
#define ASA72XX_MAX_DEV_Q_DEPTH ASA72XX_MAX_Q_DEPTH
#define ASA72XX_MAX_INTERNAL_CMD ASA72XX_MAX_Q_DEPTH*2

/* Need to accomodate 128 CMD
#define ASA72XX_MAX_Q_DEPTH	32
#define ASA72XX_MAX_INTERNAL_CMD 64	
#define ASA72XX_MAX_DEV_Q_DEPTH 128
*/

#define ASA72XX_CMD_PER_LUN	2

#if  defined(ASA72XX_VARYIO_SHT_EXT) || defined(ASA72XX_VARYIO_SHT)
#define ASA72XX_SHT { 							  \
	next: NULL,							  \
	module: NULL,							  \
	proc_dir: NULL,							  \
	proc_info: adpt_proc_info,					  \
	name: ASA72XX_DRIVER_NAME,					  \
	detect: adpt_detect,						  \
	release: adpt_release,						  \
	info: adpt_info,						  \
	queuecommand: adpt_queue,					  \
	eh_strategy_handler: NULL,					  \
	eh_abort_handler: adpt_abort,					  \
	eh_device_reset_handler: adpt_device_reset,			  \
	eh_bus_reset_handler: adpt_bus_reset,				  \
	eh_host_reset_handler: NULL,					  \
	abort: NULL,							  \
	reset: NULL,							  \
	slave_attach: NULL,						  \
	bios_param: adpt_bios_param,					  \
	can_queue: ASA72XX_MAX_Q_DEPTH,	/* max simultaneous cmds */  	  \
	this_id: -1,			/* scsi id of host adapter */     \
	sg_tablesize: SG_LIST_ELEMENTS,	/* max scatter-gather cmds */     \
	cmd_per_lun: ASA72XX_CMD_PER_LUN,/* cmds per lun (linked cmds) */ \
	unchecked_isa_dma: 0,		/* no restrictions on DMA space */\
	use_clustering: DISABLE_CLUSTERING,/* Limit to 64K Transfer*/	  \
	use_new_eh_code: 1,						  \
	can_do_varyio: 1,						  \
	proc_name: "asa72xx"						  \
}
#else

#define ASA72XX_SHT { 							  \
	next: NULL,							  \
	module: NULL,							  \
	proc_dir: NULL,							  \
	proc_info: adpt_proc_info,					  \
	name: ASA72XX_DRIVER_NAME,					  \
	detect: adpt_detect,						  \
	release: adpt_release,						  \
	info: adpt_info,						  \
	queuecommand: adpt_queue,					  \
	eh_strategy_handler: NULL,					  \
	eh_abort_handler: adpt_abort,					  \
	eh_device_reset_handler: adpt_device_reset,			  \
	eh_bus_reset_handler: adpt_bus_reset,				  \
	eh_host_reset_handler: NULL,					  \
	abort: NULL,							  \
	reset: NULL,							  \
	slave_attach: NULL,						  \
	bios_param: adpt_bios_param,					  \
	can_queue: ASA72XX_MAX_Q_DEPTH,	/* max simultaneous cmds */  	  \
	this_id: -1,			/* scsi id of host adapter */     \
	sg_tablesize: SG_LIST_ELEMENTS,	/* max scatter-gather cmds */     \
	cmd_per_lun: ASA72XX_CMD_PER_LUN,/* cmds per lun (linked cmds) */ \
	unchecked_isa_dma: 0,		/* no restrictions on DMA space */\
	use_clustering: DISABLE_CLUSTERING,/* Limit to 64K Transfer*/	  \
	use_new_eh_code: 1,						  \
	proc_name: "asa72xx"						  \
}

#endif

#include <linux/wait.h>
#include "asa72xx_i2o.h"
#include "asa72xx_ioctl.h"
#include "release.h"

#define ASA72XX_I2O_VERSION	BUILDNUM

#define ASA72XX_REVISION	'0'
#define ASA72XX_SUBREVISION	'1'
#define ASA72XX_BETA		""
#define ASA72XX_MONTH		01 
#define ASA72XX_DAY		03
#define ASA72XX_YEAR		(1980-2004)

#define ASA72XX_DRIVER		"asa72xx"
#define ASA72XX_I2O_MAJOR	151

#define DPT_ORGANIZATION_ID 	0x1B        /* For Private Messages */

#define DPTI_MAX_HBA		4

#define MAX_CHANNEL     	8	/* Maximum Channel # Supported */
#define MAX_ID        		80	/* Maximum Target ID Supported */
#define MAX_ID_PER_CHANNEL	10	/* 10 Targets per Channel */
#define	MAX_LUN			128	/* Maximum LUNs Supported */

#define I2O_HBR_MAX_TID_COUNT 	64 	

#define REPLY_FRAME_SIZE 	128
#define MAX_MESSAGE_SIZE  	512
#define OP_BLOCK_SIZE		12 	/* Used for I2O_UTIL_PARAMS_GET */
#define RES_BLOCK_SIZE		280 	/* Used for I2O_UTIL_PARAMS_GET */

#define EMPTY_QUEUE           	0xffffffff

#define I2O_INTERRUPT_PENDING_B		0x08

#define	INITIATOR_ID			7    	/* Host Adapter ID */
#define	DIRECT_ACCESS_DEVICE		0    	/* Mass Storage Device 
						 * Class Type */

/* I2O register offsets */
#define	I2O_INTR_STATUS_REG		0x30
#define	I2O_INTR_MASK_REG		0x34
#define	I2O_INBOUND_QUEUE_REG		0x40
#define	I2O_OUTBOUND_QUEUE_REG		0x44

#define SHUTDOWN_SIGS	(sigmask(SIGKILL)|sigmask(SIGINT)|sigmask(SIGTERM))

#define I2O_LCT_SUBCLASS_MASK	0x0000FFFF

/*
 * Private Events Mask
 */
#define LINK_STATUS_MASK	0x0F
#define DO_LCT_NOTIFY_MASK	0xF0

/* 
 * Max Retry for SCSI Block Command
 */
#define MAX_CMD_RETRY		3
#define MAX_RTTH		10
#define MAX_FTO			600 	/* Max FTO is 10 mins */
#define EXTENDED_TIMEOUT	10	/* Extended Timeout 10 secs */

/* Interrupt Batching */
#define IB_DEFAULT 1

/* Internal Timer interval in sec */
#define INTERNAL_TICK 1

/* Internal scsi status, good for kernel 2.4.x */
#define DID_BUS_LINKDOWN 0xd

/*
 * I2O Message timeout values in seconds
 */
#define FOREVER					(0)
#define TMOUT_ABORT				(15)
#define TMOUT_ASYNC_EVENT		(5)
#define TMOUT_DEV_RESET			(2)
#define TMOUT_FLUSH				(360/45)
#define TMOUT_GET_CTRL_ATTRIB	(15)
#define TMOUT_GET_STATUS		(15)
#define TMOUT_GET_TARGET_INFO	(15)
#define TMOUT_HBA_SCAN			(10)
#define TMOUT_INIT_OUTBOUND		(360)
#define TMOUT_INQUIRY 			(20)
#define TMOUT_IOP_RESET			(360)
#define TMOUT_IOP_FIRST_RESET	(25)
#define TMOUT_LCTGET			(220)
#define TMOUT_LINKDOWN  		(20)
#define TMOUT_POST				(30)
#define TMOUT_SEND_NOP			(5)
#define TMOUT_SCSI				(60)
#define TMOUT_SESS_RECOVERY		(120)
#define TMOUT_SYS_SHUTDOWN		(15)
#define TMOUT_UTIL_PARAMS		(120)

#define I2O_SCSI_DSC_MASK                   0xFF00
#define I2O_SCSI_DSC_SUCCESS                0x0000
#define I2O_SCSI_DSC_REQUEST_ABORTED        0x0200
#define I2O_SCSI_DSC_UNABLE_TO_ABORT        0x0300
#define I2O_SCSI_DSC_COMPLETE_WITH_ERROR    0x0400
#define I2O_SCSI_DSC_ADAPTER_BUSY           0x0500
#define I2O_SCSI_DSC_REQUEST_INVALID        0x0600
#define I2O_SCSI_DSC_PATH_INVALID           0x0700
#define I2O_SCSI_DSC_DEVICE_NOT_PRESENT     0x0800
#define I2O_SCSI_DSC_UNABLE_TO_TERMINATE    0x0900
#define I2O_SCSI_DSC_SELECTION_TIMEOUT      0x0A00
#define I2O_SCSI_DSC_COMMAND_TIMEOUT        0x0B00
#define I2O_SCSI_DSC_COMMAND_ABORTED        0x0C00
#define I2O_SCSI_DSC_MR_MESSAGE_RECEIVED    0x0D00
#define I2O_SCSI_DSC_SCSI_BUS_RESET         0x0E00
#define I2O_SCSI_DSC_PARITY_ERROR_FAILURE   0x0F00
#define I2O_SCSI_DSC_AUTOSENSE_FAILED       0x1000
#define I2O_SCSI_DSC_NO_ADAPTER             0x1100
#define I2O_SCSI_DSC_DATA_OVERRUN           0x1200
#define I2O_SCSI_DSC_UNEXPECTED_BUS_FREE    0x1300
#define I2O_SCSI_DSC_SEQUENCE_FAILURE       0x1400
#define I2O_SCSI_DSC_REQUEST_LENGTH_ERROR   0x1500
#define I2O_SCSI_DSC_PROVIDE_FAILURE        0x1600
#define I2O_SCSI_DSC_BDR_MESSAGE_SENT       0x1700
#define I2O_SCSI_DSC_REQUEST_TERMINATED     0x1800
#define I2O_SCSI_DSC_IDE_MESSAGE_SENT       0x3300
#define I2O_SCSI_DSC_RESOURCE_UNAVAILABLE   0x3400
#define I2O_SCSI_DSC_UNACKNOWLEDGED_EVENT   0x3500
#define I2O_SCSI_DSC_MESSAGE_RECEIVED       0x3600
#define I2O_SCSI_DSC_INVALID_CDB            0x3700
#define I2O_SCSI_DSC_LUN_INVALID            0x3800
#define I2O_SCSI_DSC_SCSI_TID_INVALID       0x3900
#define I2O_SCSI_DSC_FUNCTION_UNAVAILABLE   0x3A00
#define I2O_SCSI_DSC_NO_NEXUS               0x3B00
#define I2O_SCSI_DSC_SCSI_IID_INVALID       0x3C00
#define I2O_SCSI_DSC_CDB_RECEIVED           0x3D00
#define I2O_SCSI_DSC_LUN_ALREADY_ENABLED    0x3E00
#define I2O_SCSI_DSC_BUS_BUSY               0x3F00
#define I2O_SCSI_DSC_QUEUE_FROZEN           0x4000

#define I2O_PAGE_SIZE	4096

#define CMD_STATUS 	87
#define IN_PROGRESS	0x01
#define REJECTED	0x02
#if LINUX_VERSION_CODE == KERNEL_VERSION(2,4,7)
#define FAILED		0x03
#endif
#define COMPLETE	0x04

#define CMD_REQ_ACTIVE	0x01
#define CMD_REQ_DONE	0x02
#define CMD_REQ_ABORT	0x04
#define CMD_REQ_EXTENDED_COMPLETION 0x20/* due to linkdown timeout is extended*/

#define DRV_SUCCESS	0x2002
#define DRV_FAILED	0x2003

#ifndef TRUE
#define TRUE		1
#define FALSE		0
#endif

/*
 * Private Events flags 
 */
#define IMMEDIATE_REPLY		0x00
#define NORMAL_REPLY		0x01


/* Device state flags */
#define ADPT_DEV_UNSCANNED 		0x01
#define ADPT_DEV_OFFLINE   		0x02
#define ADPT_DEV_ABSENT			0x04
#define ADPT_TARGET_RESET   		0x10
#define ADPT_TARGET_SESS_RECOVERY	0x20

/* delay timings */
#define	ONE_SECOND		1000
#define	TEN_SECONDS		10 * ONE_SECOND

typedef struct _adpt_setup {
	S8			machine_name[256];
	U16			command_timeout;
	U8			device_q_depth;
	U8			interrupt_batching;
	U32			linkdown_timeout;
	U8			persistent_host_no;
	S8			persistent_name[256];
	U8			persistent_channel_no;
	U8			persistent_scsi_id;
} adpt_setup;

struct adpt_queue_info {
	Scsi_Cmnd		*cmd;
	void			(*scsi_done) (Scsi_Cmnd *);
	struct timer_list	timerlist;
};

typedef struct _adpt_cmnd {
	struct _adpt_cmnd	*next;
	struct _adpt_cmnd	*prev;
	Scsi_Cmnd		*command;
	struct _adpt_target	*target;
	struct timer_list	cmd_timer;
	dma_addr_t		bus_addr;
	U32			xfer_len;
	U32			fto_tick;
	U32			cmd_timeout;
	U8			cmd_state;
	U8			retries;
} adpt_cmnd;
	
typedef struct _adpt_device {
	struct _adpt_device	*next_lun;
	U32			capacity;
	U32			block_size;
	U16			tid;
	U16			parent_tid;
	U8			scsi_channel;
	U8			scsi_id;
	U8 			scsi_lun;
	U8			state;
	U8			flags;
	U32			target_context;
	Scsi_Device 		*pScsi_dev;
} adpt_device;

typedef struct _adpt_target {
	adpt_device 		*device;	
	adpt_cmnd		*PendingQueueHead;
	adpt_cmnd		*PendingQueueTail;
	U32			state;
	U32			reset_target_threshold;	
	U32			flexible_timeout;
	U32			current_sr_timeout;
	U16			tid;
	U8			channel_no;
	U8			scsi_id;
	U8			type;
	U8			iscsi_name[256];
	U8			sess_recovery_by_fw;
	U8			sess_recovery_by_drv;
} adpt_target;

typedef struct _adpt_channel {
	/* used as an array of 40 targets */
	adpt_target		*target[MAX_ID];
	S32			host_no;
} adpt_channel;


/* 
 * HBA state flags 
 */
#define ADPT_STATE_IOP_RESET			0x01
#define ADPT_STATE_IOCTL				0x02
#define ADPT_STATE_BUS_RESET			0x04
#define ADPT_STATE_SHUTDOWN				0x08
#define ADPT_STATE_LINK_DOWN			0x10
#define ADPT_STATE_LINK_UP				0x20
#define ADPT_STATE_RESCAN_IN_PROGRESS	0x40
#define ADPT_STATE_LCT_GET				0x80

typedef struct _adpt_btl {
	U32	tid;
	U8	bus_no;
	U8	target_no;
	U8	used;
	U8	reserved;
}adpt_btl,*padpt_btl;

typedef struct _adpt_command_request {
	struct _adpt_command_request 	*prev;
	struct _adpt_command_request 	*next;
	U32 				*msg;
       	S32 				len;
       	S32 				timeout;
	atomic_t			fw_started_processing;
	atomic_t			fw_completed_processing;
	atomic_t			fw_timed_out;
	wait_queue_head_t		thread_processing_queue;
	struct timer_list		cmd_timeout_timer;
#ifdef __VMKERNEL_MODULE__
   struct semaphore io_done_sem;
#endif
}adpt_command_request,*padpt_command_request;

typedef struct _adpt_hba {
	struct 	_adpt_hba 	*next;
	struct 	pci_dev 	*pDev;
	struct 	Scsi_Host 	*host;
/*	struct tq_struct	process_lct_async_msg_bh; */
	i2o_status_block 	*status_block;
	i2o_hrt 		*hrt;
	i2o_lct 		*lct;
	dma_addr_t		hrt_bus_addr;
	dma_addr_t		lct_bus_addr;
	dma_addr_t		status_block_bus_addr;
	spinlock_t 		spinlock;
	adpt_channel 		channel[MAX_CHANNEL];
	adpt_cmnd		*SendQueueHead;
	adpt_cmnd		*SendQueueTail;
	adpt_cmnd		*DoneQueueHead;
	adpt_cmnd		*DoneQueueTail;
	adpt_cmnd		*LinkdownQueueHead;
	adpt_cmnd		*LinkdownQueueTail;
	adpt_cmnd		*FreeQueueHead;
	adpt_cmnd		*FreeQueueTail;
	caddr_t 		base_addr_phys;
	caddr_t 		base_addr_virt;	
	volatile U32 		*irq_mask;
	volatile U32 		*irq_status;
	U32			wakeup_flag;
	U32 			*ToIopFifo;
	U32 			*FromIopFifo;
	U32 			*FromIop_Pool;
	U32 		 	ToIop_Fifo_Size;
	U32  			FromIop_Fifo_Size;
	U32 			state;
	U32 			lct_size;
	U32			hrt_size;
	U32  			sg_tablesize;	
	U32			no_of_devs;
	U32			active_cmds;
	U32			aborted_cmd_count;
	U32			linkdowntimeout;
	U32			total_cmds;
	U32			fw_error_code;
	S32 			unit;
	S32 			host_no; 	/* SCSI host number */
	U8   			verifydone;
	U8 			initialized;
	U8 			in_use;
	U8  			top_scsi_channel;
	U8  			top_scsi_id;
	U8  			top_scsi_lun;
	S8 			name[32];
	S8 			detail[55];
	S8 			machine_name[256];
	adpt_btl		btl_map_info[MAX_TARGETS_SUPPORTED];
	kthread_t		thread_id;
	kthread_t		lct_thread_id;
	pget_target_list	ptarget_info_ioctl;
	padpt_command_request	pio_cmd_base_ptr;
	wait_queue_head_t	interrupt_triggered_event;
	wait_queue_head_t	wake_up_worker;
	wait_queue_head_t	wake_up_sr;
	wait_queue_head_t	lct_processing_complete;
	spinlock_t 		protect_io_cmd;
	S32			cmd_status;
	atomic_t		fw_drop_current_io;
	atomic_t		fw_completed_request;
#ifdef __VMKERNEL_MODULE__
   struct semaphore process_io_sem;
   struct semaphore wake_up_worker_sem;
#endif //__VMKERNEL_MODULE__
	dma_addr_t		ptarget_list_bus_addr;
	pget_device_list	pdevice_info_ioctl;
	dma_addr_t		pdevice_list_bus_addr;
	S8                      hostverifydoneflag; /* verify each adapter name */
	/* Virtual Addr Of FW Debug BLED */
	volatile U8 		*FwDebugBLEDflag_P;	
	/* Virtual Addr Of FW Debug BLED */
	volatile U8 		*FwDebugBLEDvalue_P;
        struct timer_list	hba_timer;
} adpt_hba;

struct sg_simple_element {
   	U32 flag_count;
   	U32 addr_low32;
#if (BITS_PER_LONG > 32)
	U32 addr_up32;
      	U32 reserved;
#endif
}; 

typedef wait_queue_head_t adpt_wait_queue_head_t;
#define ADPT_DECLARE_WAIT_QUEUE_HEAD(wait) DECLARE_WAIT_QUEUE_HEAD(wait)
typedef wait_queue_t adpt_wait_queue_t;

/*
 * Function Prototypes
 */
S32 		adpt_i2o_activate_hba(adpt_hba *pHba);
S32 		adpt_i2o_build_sys_table(void);
void 		adpt_i2o_delete_hba(adpt_hba* pHba);
S32 		adpt_i2o_enable_hba(adpt_hba *pHba);
const S8 	*adpt_i2o_get_class_name(S32 class);
S32			adpt_i2o_hba_scan(adpt_hba *pHba);
S32 		adpt_i2o_hrt_get(adpt_hba *pHba);
S32 		adpt_i2o_init_outbound_q(adpt_hba *pHba);
S32 		adpt_i2o_issue_params(S32 cmd, adpt_hba *pHba, S32 tid, 
		  	void *opblk, S32 oplen, void *resblk, S32 reslen);
S32 		adpt_i2o_lct_get(adpt_hba *pHba);
S32 		adpt_i2o_online_controller(adpt_hba *pHba);
S32 		adpt_i2o_parse_lct(adpt_hba *pHba);
S32 		adpt_i2o_parse_hrt(adpt_hba *pHba);
S32 		adpt_i2o_post_this(adpt_hba *pHba, U32 *data, S32 len);
S32 		adpt_i2o_post_wait(adpt_hba *pHba, U32 *msg, S32 len, 
			S32 timeout);
S32 		adpt_i2o_query_scalar(adpt_hba *pHba, S32 tid, 
			S32 group, S32 field, void *buf, S32 buflen);
S32 		adpt_i2o_quiesce_hba(adpt_hba *pHba);
S32 		adpt_i2o_parse_lct(adpt_hba *pHba);
S32 		adpt_i2o_reset_hba(adpt_hba *pHba);
S32 		adpt_i2o_status_get(adpt_hba *pHba);
void 		adpt_i2o_sys_shutdown(void);
S32	 		adpt_i2o_to_scsi(u_long reply, adpt_cmnd *pCmnd);
static S32	adpt_async_register_event(adpt_hba *pHba, U32 event_mask);
static void	adpt_async_send_notification(adpt_hba *pHba, 
			U8 reply_indicator);
S32 		adpt_close(struct inode *inode, struct file *file);
static void	adpt_cmd_timeout(u_long arg);
static void adpt_delay(S32 millisec);
static void	adpt_destroy_cmd_pool(adpt_hba *pHba);
static void adpt_done(adpt_hba *pHba, u_long reply, adpt_cmnd *pCmnd);
static adpt_cmnd *adpt_get_free_cmd(adpt_hba *pHba);
void 		adpt_fail_posted_scbs(adpt_hba *pHba);
adpt_target *adpt_get_target_from_lun_lct(adpt_hba *pHba, 
                                       i2o_lct_entry *lct_entry);
static void	adpt_free_cmd(adpt_hba *pHba, adpt_cmnd *pCmnd);
adpt_device	*adpt_get_device(adpt_target *pTarget, U16 tid, U16 scsi_lun);
S32 		adpt_init(void);
static U32	adpt_init_cmd_pool(adpt_hba *pHba);
static S32	adpt_initiate_bus_reset(adpt_hba *pHba, U8 channel_no);
static S32	adpt_initiate_session_recovery(adpt_hba *pHba,
			adpt_target *pTarget);
S32			adpt_install_hba(struct pci_dev *pDev);
S32 		adpt_ioctl(struct inode *inode, struct file *file, 
			U32 cmd, unsigned long arg);
void 		adpt_isr(S32 irq, void *dev_id, struct pt_regs *regs);
S32 		adpt_mgmt_ioctl(adpt_hba *pHba, U32 *arg);
S32 		adpt_open(struct inode *inode, struct file *file);
static inline void	adpt_process_done_queue(u_long arg);
static inline void	adpt_queue_done_command(Scsi_Cmnd *cmd, 
				void (*scsi_done) (Scsi_Cmnd *));
static S32	adpt_pci_dev_probe(struct pci_dev *pDev,
			const struct pci_device_id *id);;
static void	adpt_pci_dev_remove(struct pci_dev *pDev);
static void	adpt_process_event_completion(adpt_hba *pHba, u_long reply);
static void	adpt_process_lct_async_msg(void *data);
S32 		adpt_read_capacity(adpt_hba *pHba, adpt_device *d);
S32 		adpt_reinit(adpt_hba *pHba);
static void 	adpt_rescan(adpt_hba *pHba, U8 bus_scan_needed);
static void 	adpt_rescan_device(adpt_hba *pHba);
S32 		adpt_scsi_bus_reset(adpt_hba* pHba, U32 chan);
S32 		adpt_scsi_device_reset(adpt_hba* pHba, U8 chan, U8 id, U8 lun);
S32 		adpt_scsi_register(adpt_hba* pHba,Scsi_Host_Template * sht);
S32 		adpt_scsi_to_i2o(adpt_hba *pHba, adpt_cmnd *pCmnd, 
			adpt_device *device);
S32 		adpt_send_nop(adpt_hba *pHba, U32 m);
static void 	adpt_select_queue_depths(struct Scsi_Host *host, 
			Scsi_Device *devicelist);
static S32	adpt_shutdown_event(struct notifier_block *nb, u_long code,
			void *unused);
static void	adpt_unmap_sg_mapping(adpt_hba *pHba, adpt_cmnd *pCmnd);
static void 	parse_cmdline_params(S8 *str, S32 *ints);

S32 		getcontrollerattributes(adpt_hba *pHba);
S32 		getsettime(adpt_hba *pHba);
S32 		sendhostverifydone(adpt_hba *pHba, U8 mach_name_mismatched);
S32 		validatehostconfiguration(adpt_hba *pHba);
S32 		getbtlmapping(adpt_hba *pHba, U32 *user_msg);

static inline void adpt_insert_cmd_to_queue(adpt_cmnd **pQueueHead, 
			adpt_cmnd **pQueueTail, adpt_cmnd *pCmnd);

static inline adpt_cmnd	*adpt_find_cmd_in_queue(adpt_cmnd **pQueueHead, 
				adpt_cmnd **pQueueTail, Scsi_Cmnd *cmd);
inline U8		adpt_remove_cmd_fr_queue(adpt_cmnd **pQueueHead,
	       			adpt_cmnd **pQueueTail, adpt_cmnd *pCmnd); 
static void	adpt_start_io(adpt_hba *pHba);

unsigned long adpt_get_jiffies(void);
unsigned int adpt_check_queues_empty(adpt_hba * pHba);

static void adpt_timer (U32_64 arg);
static void adpt_complete_linkdown_queue(adpt_hba * pHba);
static void adpt_complete_queue(adpt_hba * pHba, U8 cmd_state);
static inline void adpt_queue_done_command_for_sr(Scsi_Cmnd *cmd, void (*scsi_done) (Scsi_Cmnd *), adpt_target *pTarget);

/* Added for notifying FW about fresh boot */
S32     adpt_set_driver_status(adpt_hba * pHba);
/* Initialies target params like timeout etc */
S32 	adpt_initialize_target_params(adpt_hba *pHba,
                                       adpt_target *pTarget,
                                       U8 channel_no,
                                       U16 scsi_id,
                                       i2o_lct_entry *lct_entry);
/* Gets iSCSI name given a tid */
S32 adpt_get_iscsi_name(adpt_hba *pHba, int tid, U8 *iscsi_name);
S32 is_existing_target(adpt_hba *pHba, U8 *iscsi_name,
                        adpt_target **pTarget);
/* maps a new target */
adpt_target * adpt_map_new_target(adpt_hba *pHba, i2o_lct_entry *lct_entry,
                     U8 channel_no, U16 scsi_id);
S32 adpt_initialize_lun_params(adpt_hba *pHba, adpt_target *pTarget,
            i2o_lct_entry * lct_entry,
            adpt_device **pLun);
/* check if a target has any LUNs in lct */
S32 adpt_check_target_has_lun(adpt_hba *pHba, i2o_lct_entry *lct_entry);
/*Added for the Persistent LUN*/
S32	validate_lct_table(adpt_hba *pHba);
S32 	sync_up_bt_with_fw(adpt_hba *pHba);
S32	set_btl_into_fw(adpt_hba *pHba);
S32 	adpt_start_worker_thread(adpt_hba *pHba);
void 	adpt_io_thread(kthread_t *kthread);
void 	adpt_lct_thread(kthread_t *kthread);
S32 	adpt_stop_worker_thread(adpt_hba *pHba);
S32 	process_io_request(adpt_hba *pHba,adpt_command_request *pio_request);
S32 	adpt_i2o_post_event_wake_up(adpt_hba *pHba);
S32 	delete_cmd_from_io_queue(adpt_hba *pHba,adpt_command_request *pio_request);
S32 	add_cmd_to_io_queue(adpt_hba *pHba,adpt_command_request *pio_request);
adpt_command_request *get_cmd_from_io_queue(adpt_hba *pHba);
void 	cmd_timeout_trigger(U32 dataptr);

/* Locking */
static inline void adpt_init_lock(adpt_hba *pHba);
static inline void adpt_lock(adpt_hba *pHba, U32_64 flags,
				U8 irqsave);
static inline void adpt_unlock(adpt_hba *pHba, U32_64 flags,
				U8 irqsave);

/*
 * Macros.
 */
#define BIT(x)	(1 << (x))

