/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#ifndef ISCSI
#define ISCSI
#endif

#define UE_MAX_HIMERRNO 100
#define UE_MAX_CDAERRNO  149 
#define UE_MIN_CMNERRNO  UE_MAX_CDAERRNO + 1
#define UE_MAX_CMNERRNO  199
#define UE_MAX_OSMERRNO 255 
#define UE_MAX_NUMERRS 255 
#define UE_MAX_CHAR 65  /* maximum number of characters in message */

/* ----------------------- end of tunables ---------------------*/

/*  severity Level */
#define UL_MASK     0xF0000000  /* severity  mask   */
#define UL_DONE     0x00000000  /* successful       */
#define UL_INFO     0x40000000  /* informational    */
#define UL_WARN     0x80000000  /* warning      */
#define UL_ERROR    0xC0000000  /* error        */
/* Phase */
#define UP_MASK     0x0F000000  /* phase mask       */
#define UP_INIT     0x00000000  /* initialization   */
#define UP_RUN      0x01000000  /* runtime      */
#define UP_SHUT     0x02000000  /* showdown     */
#define UP_OSM      0x03000000  /* OS Module specific   */
/* Source */
#define US_MASK     0x00F00000  /* source mask      */ 
#define US_HW       0x00000000  /* hardware     */
#define US_FW       0x00100000  /* firmware         */
#define US_DRV      0x00200000  /* software/driver  */
#define US_EXT      0x00300000  /* external device  */
#define US_SYS      0x00400000  /* system       */
/* Transport */
#define UT_MASK     0x000F0000  /* transport layer mask */
#define UT_SCSI     0x00000000  /* SCSI         */
#define UT_FIBRE    0x00010000  /* Fibre channel    */
#define UT_SSA      0x00020000  /* SSA      */
#define UT_ISCSI    0x00030000  /* ISCSI    */
/* Operating system */
#define UO_MASK     0x0000F000  /* OS mask      */
#define UO_CMN	    0x00000000  /* Common */
#define UO_LINUX    0x00008000  /* Linux 	*/

/* Custom | reserved */
#define UC_EXT_MASK 0x00000800	/* Custom bit for Extended error codes */
#define UC_NO_EXT   0x00000000  /* No Extension */
#define UC_EXT      0x00000800  /* with extension */
/* other Extended message(s) following this header.  the termination */
/* is the last message which is 0x0 type. everything is standard in */
/* the termination bit, unless, UE_EXT bit is set as shown */
/* err code */
#define UC_MASK     0x000000FF  /* error code mask  */

#ifdef ISCSI 

/**************************************** 
 * ISCSI Transport Specific definitions *
 ****************************************/

/***COMMON ERROR CODES***/

/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
 * (0xC04300xx)
 */
#define U_MALLOC_FAIL 	0x0
#define	U_ISR_FAIL	0x1
#define U_CMN_INVALID_DRVR 0x2
#define U_CMN_SCSI_BUSY 0x3
#define U_CMN_DU_DO 0x4
#define U_CMN_WRONG_REPLY   0x5

  /*** Hardware ***/
/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_HW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
 * (0xC00300xx)
 */
#define U_BUS_ARCH_NOT_SUPP 0x0
#define U_NO_SUPP_ADAPTER 0x1

  /*** Firmware ***/
/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT (0xC01300xx)
 */
#define U_HA_INIT_FAIL 0x0
#define U_HA_CONFIG_FAIL 0x1

  /*** Driver ***/
/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT (0xC02300xx)
 */

/*** Linux ERROR CODES ***/

/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
 * (0xC04380xx)
 */
#define U_PCI_ENABLE_FAIL	0x00	


/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_WARN | UP_INIT | US_HW | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
 * (0x800380xx)
 */
#define U_HA_MACH_NAME_MISMATCH	0x00
#define U_HA_NO_MACH_NAME	0x01


/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_WARN | UP_INIT | US_DRV | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
 * (0x802380xx)
 */
#define U_LX_INVALID_OPTION	0x00

#endif /*ISCSI*/


/* prototype */
const char *uni_err(unsigned long errno);
