/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

/* Not specific to any transport format. Common to SCSI, Fibre,etc. */
#define UM_CMN_UNKNOWN_ERR  "An unknown error occurred"
#define UM_CMN_DU_DO        "Data Overrun or Underrun" 

#ifdef ISCSI

/**************************************** 
 * ISCSI Transport Specific definitions *
 ****************************************/

/***COMMON ERROR CODES***/

/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
 * (0xC04300xx)
 */
#define UM_MALLOC_FAIL 	"Unable to allocate memory"
#define UM_ISR_FAIL	"Failed to register interrupt service routine - "\
			"possible interrupt conflict"

/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_HW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
 * (0xC00300xx)
 */
#define UM_BUS_ARCH_NOT_SUPP "Unsupported bus architecture"
#define UM_NO_SUPP_ADAPTER "Could not find Host Adapter" 

/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
 * (0xC01300xx)
 */
#define UM_HA_INIT_FAIL "Could not initialize Host Adapter"
#define UM_HA_CONFIG_FAIL "Could not configure Host Adapter"

/* The following are the Error Code definitions (a byte value) under the condtion
   UL_ERROR | UP_INIT | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT (0xC02300xx)*/
#define UM_CMN_INVALID_DRVR  "Invalid or different OS driver installed on"\
                             " system"
  /* i.e. NT4 driver should not run on W2K */
#define UM_CMN_SCSI_BUSY "Device busy"
#define UM_CMN_WRONG_REPLY "Wrong or unexpected reply packet received"

/***NetWare ERROR CODES***/

/* 
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_NETWARE | UC_NO_EXT | xx
 * (0xC04320xx)
 */
#define UM_NW_HAM_REGISTRATION_FAIL "Host Adapter Module failed to register "
#define UM_NW_NBI_NOT_LOADED "NBI.NLM is not loaded"
#define UM_NW_BUS_ACTIVATION_FAIL "Host Adapter failed to activate bus"
#define UM_NW_BUS_NOT_SUPPORTED "Host Adapter is plugged into a non-PCI bus"
#define UM_NW_ADD_SLOT_OPT_FAIL "Host Adapter Module failed to Add Slot Option "
#define UM_NW_PARSE_SLOT_OPT_FAIL "Host Adapter Module failed to Parse Slot Option "
#define UM_NW_ADD_IRQ_OPT_FAIL "Host Adapter Module failed to Add IRQ Option "
#define UM_NW_PARSE_IRQ_OPT_FAIL "Host Adapter Module failed to Parse IRQ Option "
#define UM_NW_ADD_MEM_OPT_FAIL "Host Adapter Module failed to Add Memory Option "
#define UM_NW_PARSE_MEM_OPT_FAIL "Host Adapter Module failed to Parse Memory Option "
#define UM_NW_REGISTER_OPT_FAIL "Host Adapter Module failed to Register Options "


/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_INFO | UP_INIT | US_DRV | UT_ISCSI | UO_NETWARE | UC_NO_EXT | xx
 * (0x402320xx)
 */
#define UM_NW_HA_LOADED "Host Adapter loaded "
#define UM_NW_HA_LOADED_ALREADY "Host Adapter already loaded"

/*
 * The following are the Error Code definitions (a byte value) under the condtion
 * UL_WARN | UP_INIT | US_DRV | UT_ISCSI | UO_NETWARE | UC_NO_EXT | xx
 * (0x802320xx)
 */
#define UM_NW_INVALID_OPTION "Invalid command line option "
#define UM_NW_TIMEOUT_MUST_BE_DECIMAL "Value for 'timeout' option must be a decimal number"


/*** Linux ERROR Codes ***/

/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx
 * (0xC04380xx)
 */
#define UM_PCI_ENABLE_FAIL	"Could not enable PCI device"


/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_WARN | UP_INIT | US_HW | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx
 * (0x800380xx)
 */
#define UM_HA_MACH_NAME_MISMATCH	"Machine Name mismatched with the "\
					"one stored in the EEPROM "
								 
#define UM_HA_NO_MACH_NAME		"No Machine Name found in EEPROM "


/* 
 * The following are the Error Code definitions (a byte value) under 
 * the condtion :
 * UL_WARN | UP_INIT | US_DRV | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx
 * (0x802380xx)
 */
#define UM_LX_INVALID_OPTION		"Invalid Command Line option"

#endif /*ISCSI*/
