/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "uni_err.h"

const char *uni_err(unsigned long errno)
{
    unsigned short  err_code;
    unsigned long   protocol_type;
    int i;
    UERROR_CODE *uerr_p;

    err_code =  (unsigned short) errno & UC_MASK;
    protocol_type = errno & UT_MASK;

    switch(protocol_type)
    {
#ifdef ISCSI
        case UT_ISCSI:
            for(uerr_p=uerr_iscsi, i=0;
            i<(sizeof(uerr_iscsi)/sizeof(UERROR_CODE));
            uerr_p++,i++) 
            {
                if (uerr_p->error_code == errno) {
                    return(uerr_p->descrip);
                }
            }
            return(UM_CMN_UNKNOWN_ERR);
		    break;
#endif

        default:
            return("Unknown Transport Protocol");
            break;
    }

}
