/*
Copyright (C) 2004  Kenney He

This program is free software; you can redistribute it and/or
modify it under the terms of the GNU General Public License
as published by the Free Software Foundation; either version 2
of the License, or (at your option) any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software
Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

*/

#include "uerrdef.h"
#include "uerrmsg.h"

typedef struct univ_error_code {
    unsigned long error_code;   /* universal error code */
    char          *descrip;     /* descriptive character string */
} UERROR_CODE;

#ifdef ISCSI

/********************************************* 
 * ISCSI Transport Specific Table definition *
 *********************************************/

UERROR_CODE uerr_iscsi[]= {

    /***COMMON ERROR CODES***/

    /* 
     * The following are the Error Code definitions (a byte value) under the condtion
     * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
     * (0xC04300xx)
     */
    {UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_CMN | UC_NO_EXT | U_MALLOC_FAIL, UM_MALLOC_FAIL},
    {UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_CMN | UC_NO_EXT | U_ISR_FAIL,
	    UM_ISR_FAIL},

    /*
     * The following are the Error Code definitions (a byte value) under the condtion
     * UL_ERROR | UP_INIT | US_HW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
     * (0xC00300xx)
     */
    {UL_ERROR | UP_INIT | US_HW | UT_ISCSI | UO_CMN | UC_NO_EXT | U_BUS_ARCH_NOT_SUPP, UM_BUS_ARCH_NOT_SUPP},
    {UL_ERROR | UP_INIT | US_HW | UT_ISCSI | UO_CMN | UC_NO_EXT | U_NO_SUPP_ADAPTER, UM_NO_SUPP_ADAPTER},

    /* 
     * The following are the Error Code definitions (a byte value) under the condtion
     * UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
     * (0xC01300xx)
     */
    {UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT | U_HA_INIT_FAIL, UM_HA_INIT_FAIL},
    {UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT | U_HA_CONFIG_FAIL, UM_HA_CONFIG_FAIL},

    /* 
     * The following are the Error Code definitions (a byte value) under the condtion
     * UL_ERROR | UP_INIT | US_FW | UT_ISCSI | UO_CMN | UC_NO_EXT | xx
     * (0xC02300xx)
     */
    {UL_ERROR | UP_INIT | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT | U_CMN_INVALID_DRVR, UM_CMN_INVALID_DRVR},
    {UL_ERROR | UP_RUN | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT | U_CMN_SCSI_BUSY, UM_CMN_SCSI_BUSY},
    {UL_ERROR | UP_RUN | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT | U_CMN_DU_DO, UM_CMN_DU_DO},
    {UL_ERROR | UP_RUN | US_DRV | UT_ISCSI | UO_CMN | UC_NO_EXT | U_CMN_WRONG_REPLY, UM_CMN_WRONG_REPLY},

    /*** Linux ERROR CODES ***/

    /* 
     * The following are the Error Code definitions (a byte value) under 
     * the condtion :
     * UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
     * (0xC04380xx)
     */
     {UL_ERROR | UP_INIT | US_SYS | UT_ISCSI | UO_LINUX | UC_NO_EXT | 
	     U_PCI_ENABLE_FAIL, UM_PCI_ENABLE_FAIL},

    /* 
     * The following are the Error Code definitions (a byte value) under 
     * the condtion :
     * UL_WARN | UP_INIT | US_HW | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
     * (0x800380xx)
     */
     {UL_WARN | UP_INIT | US_HW | UT_ISCSI | UO_LINUX | UC_NO_EXT | 
	     U_HA_MACH_NAME_MISMATCH, UM_HA_MACH_NAME_MISMATCH},

     {UL_WARN | UP_INIT | US_HW | UT_ISCSI | UO_LINUX | UC_NO_EXT | 
	     U_HA_NO_MACH_NAME, UM_HA_NO_MACH_NAME},

    /* 
     * The following are the Error Code definitions (a byte value) under 
     * the condtion :
     * UL_WARN | UP_INIT | US_DRV | UT_ISCSI | UO_LINUX | UC_NO_EXT | xx 
     * (0x802380xx)
     */
     {UL_WARN | UP_INIT | US_DRV | UT_ISCSI | UO_LINUX | UC_NO_EXT | 
	     U_LX_INVALID_OPTION, UM_LX_INVALID_OPTION}
};
#endif /*ISCSI*/

