#ifndef HPSA_CMD_H
#define HPSA_CMD_H
/* ########################################################################## */
/* DEFINES                                                                    */
/* ########################################################################## */
#define HPSA_VERSION "1.00"

/* general boundary defintions */
#define SENSEINFOBYTES          32	/* note that this value may vary */
					/* between host implementations  */
#define MAXSGENTRIES            31
#define MAXREPLYQS              256

/* Command Status value */
#define CMD_SUCCESS             0x0000
#define CMD_TARGET_STATUS       0x0001
#define CMD_DATA_UNDERRUN       0x0002
#define CMD_DATA_OVERRUN        0x0003
#define CMD_INVALID             0x0004
#define CMD_PROTOCOL_ERR        0x0005
#define CMD_HARDWARE_ERR        0x0006
#define CMD_CONNECTION_LOST     0x0007
#define CMD_ABORTED             0x0008
#define CMD_ABORT_FAILED        0x0009
#define CMD_UNSOLICITED_ABORT   0x000A
#define CMD_TIMEOUT             0x000B
#define CMD_UNABORTABLE		0x000C

/* transfer direction */
#define XFER_NONE               0x00
#define XFER_WRITE              0x01
#define XFER_READ               0x02
#define XFER_RSVD               0x03

/* task attribute */
#define ATTR_UNTAGGED           0x00
#define ATTR_SIMPLE             0x04
#define ATTR_HEADOFQUEUE        0x05
#define ATTR_ORDERED            0x06
#define ATTR_ACA                0x07

/* cdb type */
#define TYPE_CMD				0x00
#define TYPE_MSG				0x01

/* config space register offsets */
#define CFG_VENDORID            0x00
#define CFG_DEVICEID            0x02
#define CFG_I2OBAR              0x10
#define CFG_MEM1BAR             0x14

/* i2o space register offsets */
#define I2O_IBDB_SET            0x20
#define I2O_IBDB_CLEAR          0x70
#define I2O_INT_STATUS          0x30
#define I2O_INT_MASK            0x34
#define I2O_IBPOST_Q            0x40
#define I2O_OBPOST_Q            0x44
#define I2O_DMA1_CFG            0x214

/* Configuration Table */
#define CFGTBL_ChangeReq        0x00000001l
#define CFGTBL_AccCmds          0x00000001l

#define CFGTBL_Trans_Simple     0x00000002l

#define CFGTBL_BusType_Ultra2   0x00000001l
#define CFGTBL_BusType_Ultra3   0x00000002l
#define CFGTBL_BusType_Fibre1G  0x00000100l
#define CFGTBL_BusType_Fibre2G  0x00000200l
typedef struct _vals32
{
        __u32   lower;
        __u32   upper;
} vals32;

typedef union _u64bit
{
   vals32	val32;
   __u64	val;
} u64bit;

/*  Type defs used in the following structs */
typedef vals32 QWORD; 

/* ######################################################################### */
/* STRUCTURES                                                                */
/* ######################################################################### */
#define NUM_GENDISK		2
#define HPSA_MAX_LUN		256
#define HPSA_MAX_PHYS_LUN	1024
#define MAX_TARGETS		16      // The maximum number of target devices per HBA.
#define MAX_DEVS		272     // HPSA_MAX_LUN + MAX_TARGETS


/* SCSI-3 Cmmands  */

#pragma pack(1)	

#define HPSA_INQUIRY 0x12
/* Data returned */
typedef struct _InquiryData_struct
{
  BYTE data_byte[36];
} InquiryData_struct;

#define HPSA_REPORT_LOG 0xc2    /* Report Logical LUNs */
#define HPSA_REPORT_PHYS 0xc3   /* Report Physical LUNs */
#define HPSA_DEFAULT_MAX_LUN 32 /* Default maximum number of luns */
/*  Data returned */
typedef struct _ReportLUNdata_struct
{
  BYTE LUNListLength[4];
  DWORD reserved;
  BYTE LUN[HPSA_DEFAULT_MAX_LUN][8];
} ReportLunData_struct;

#define HPSA_READ_CAPACITY 0x25 /* Read Capacity */ 
typedef struct _ReadCapdata_struct
{
  BYTE total_size[4];	/* Total size in blocks */
  BYTE block_size[4];	/* Size of blocks in bytes */
} ReadCapdata_struct;

/* 12 byte commands not implemented in firmware yet.  */
/* #define HPSA_READ 	0xa8	Read(12)	*/
/* #define HPSA_WRITE	0xaa	Write(12) 	*/
 #define HPSA_READ   0x28    /* Read(10) */
 #define HPSA_WRITE  0x2a    /* Write(10) */

/* BMIC commands */
#define BMIC_READ 0x26
#define BMIC_WRITE 0x27
#define BMIC_CACHE_FLUSH 0xc2
#define HPSA_CACHE_FLUSH 0x01	/* 0xC2 was already being used by HPSA */

typedef struct _CommandListHeader_struct {
  BYTE              ReplyQueue;
  BYTE              SGList;
  HWORD             SGTotal;
  QWORD             Tag;
  LUNAddr_struct    LUN;
} CommandListHeader_struct;

typedef struct _ErrDescriptor_struct {
  QWORD  Addr;
  DWORD  Len;
} ErrDescriptor_struct;

typedef struct _SGDescriptor_struct {
  QWORD  Addr;
  DWORD  Len;
  DWORD  Ext;
} SGDescriptor_struct;


/* Command types */
#define CMD_RWREQ       0x00
#define CMD_IOCTL_PEND  0x01
#define CMD_SCSI	0x03
#define CMD_MSG_DONE	0x04
#define CMD_MSG_TIMEOUT 0x05


typedef struct _CommandList_struct {
  CommandListHeader_struct Header;
  RequestBlock_struct      Request;
  ErrDescriptor_struct     ErrDesc;
  SGDescriptor_struct      SG[MAXSGENTRIES];
	/* information associated with the command */ 
  __u32			   busaddr; /* physical address of this record */
  ErrorInfo_struct * 	   err_info; /* pointer to the allocated mem */ 
  int			   ctlr;
  int			   cmd_type; 
  struct _CommandList_struct *prev;
  struct _CommandList_struct *next;
  struct request *	   rq;
  struct completion *waiting;
  int	 retry_count;
#if defined CONFIG_SCSI_HPSA || defined CONFIG_SCSI_HPSA_MODULE || defined __VMKERNEL_MODULE__
  void * scsi_cmd;
#endif
} CommandList_struct;

/* Configuration Table Structure */
typedef struct _HostWrite_struct {
  DWORD TransportRequest;
  DWORD Reserved;
  DWORD CoalIntDelay;
  DWORD CoalIntCount;
} HostWrite_struct;

typedef struct _CfgTable_struct {
  BYTE             Signature[4];
  DWORD            SpecValence;
  DWORD            TransportSupport;
  DWORD            TransportActive;
  HostWrite_struct HostWrite;
  DWORD            CmdsOutMax;
  DWORD            BusTypes;
  DWORD            Reserved; 
  BYTE             ServerName[16];
  DWORD            HeartBeat;
  DWORD		   SCSI_Prefetch;
} CfgTable_struct;

typedef struct _hpsa_pci_info_struct {
	unsigned char   bus;
	unsigned char   dev_fn;
	__u32           board_id;
} hpsa_pci_info_struct;

#pragma pack()	 
#endif /* HPSA_CMD_H */
