/*
 *    Disk Array driver for HP SA 5xxx and 6xxx Controllers, SCSI version
 *    Copyright 2001, 2008 Hewlett-Packard Development Company, L.P.
 *
 *    This program is free software; you can redistribute it and/or modify
 *    it under the terms of the GNU General Public License as published by
 *    the Free Software Foundation; either version 2 of the License, or
 *    (at your option) any later version.
 *
 *    This program is distributed in the hope that it will be useful,
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of
 *    MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE, GOOD TITLE or
 *    NON INFRINGEMENT.  See the GNU General Public License for more details.
 *
 *    You should have received a copy of the GNU General Public License
 *    along with this program; if not, write to the Free Software
 *    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 *    Questions/Comments/Bugfixes to iss_storagedev@hp.com
 *
 */
#if defined CONFIG_SCSI_HPSA || defined CONFIG_SCSI_HPSA_MODULE || defined __VMKERNEL_MODULE__
#ifndef _SCSI_HPSA_H
#define _SCSI_HPSA_H

#include <scsi/scsicam.h> /* possibly irrelevant, since we don't show disks */

		// the scsi id of the adapter...
#define SELF_SCSI_ID -1 
		// In case we ever want to present controller so sg will 
		// bind to it.  The scsi bus that's presented by the
		// driver to the OS is fabricated.  The "real" scsi-3
		// bus the hardware presents is fabricated too.
		// The actual, honest-to-goodness physical
		// bus that the devices are attached to is not
		// addressible natively, and may in fact turn
		// out to be not scsi at all.

#define SCSI_HPSA_CAN_QUEUE 512


struct hpsa_scsi_dev_t {
	int devtype;
	int bus, target, lun;		/* as presented to the OS */
	unsigned char scsi3addr[8];	/* as presented to the HW */
};

struct hpsa_scsi_hba_t {
	char name[16];
	int ndevices;
	struct hpsa_scsi_dev_t dev[MAX_DEVS];
};

#endif /* _SCSI_HPSA_H_ */
#endif /* CONFIG_SCSI_HPSA */
