/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Fibre Channel Host Bus Adapters.                                *
 * Refer to the README file included with this package for         *
 * driver version and adapter support.                             *
 * Copyright (C) 2003-2008 Emulex.  All rights reserved.           *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of the GNU General Public License     *
 * as published by the Free Software Foundation; either version 2  *
 * of the License, or (at your option) any later version.          *
 *                                                                 *
 * This program is distributed in the hope that it will be useful, *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
 * GNU General Public License for more details, a copy of which    *
 * can be found in the file COPYING included with this package.    *
 *******************************************************************/

/*
 * $Id: lpfc_crtn.h 1.4 2005/05/03 11:21:23EDT jsullivan Exp  $
 */

#ifndef _H_LPFC_CRTN
#define _H_LPFC_CRTN

#include <linux/interrupt.h>
#include <linux/delay.h>
#include <asm/uaccess.h>
#include <scsi.h>

#include "lpfc_dfc.h"
#include "lpfc_sli.h"
#include "lpfc_scsi.h"
#include "lpfc_logmsg.h"

#include "lpfc_compat.h"

#ifdef __VMKERNEL_MODULE__
#define timer_pending(x) (x)
#define sscanf(x, y, z) (!isascii(z[0] = x[0]))
#endif

void lpfc_get_hba_info(lpfcHBA_t *, uint32_t *, uint32_t *, uint32_t *, uint32_t *);
int lpfc_proc_info(char *, char **, off_t , int , int , int);
void lpfc_dump_mem(lpfcHBA_t *, LPFC_MBOXQ_t *, uint16_t);
void lpfc_read_nv(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_heart_beat(lpfcHBA_t *, LPFC_MBOXQ_t *);
int lpfc_read_la(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_clear_la(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_config_async(lpfcHBA_t *, LPFC_MBOXQ_t *, uint32_t);
void lpfc_config_link(lpfcHBA_t *, LPFC_MBOXQ_t *);
int lpfc_read_sparam(lpfcHBA_t *, LPFC_MBOXQ_t *, uint16_t);
void lpfc_read_config(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_read_lnk_stat(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_set_slim(lpfcHBA_t *, LPFC_MBOXQ_t *, uint32_t, uint32_t);
int lpfc_reg_login(lpfcHBA_t *, uint16_t, uint32_t, uint8_t *, LPFC_MBOXQ_t *, uint32_t);
void lpfc_unreg_login(lpfcHBA_t *, uint16_t, uint16_t, LPFC_MBOXQ_t *);
void lpfc_unreg_did(lpfcHBA_t *, uint16_t, uint32_t, LPFC_MBOXQ_t *);
void lpfc_reg_vpi(lpfcHBA_t *, uint16_t, uint32_t, LPFC_MBOXQ_t *);
int lpfc_read_vpi(lpfcHBA_t *, uint32_t, LPFC_MBOXQ_t *);
void lpfc_init_link(lpfcHBA_t *, LPFC_MBOXQ_t *, uint32_t, uint32_t);
uint32_t *lpfc_config_pcb_setup(lpfcHBA_t *);
int lpfc_read_rpi(lpfcHBA_t *, uint32_t, LPFC_MBOXQ_t *, uint32_t);
void lpfc_unreg_vpi(lpfcHBA_t *, uint16_t, LPFC_MBOXQ_t *);
lpfc_vport_t *lpfc_create_port(lpfcHBA_t *, int);
void lpfc_destroy_port(lpfc_vport_t *);
void lpfc_stop_vport_timers(lpfc_vport_t *);
void lpfc_destroy_host_all(lpfcHBA_t *);

int lpfc_linkdown(lpfcHBA_t *);
int lpfc_linkup(lpfcHBA_t *);
void lpfc_mbx_cmpl_hb(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_read_la(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_config_link(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_read_sparam(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_clear_la(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_reg_login(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_dflt_rpi(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_fabric_reg_login(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_reg_vpi(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_unreg_vpi(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_unreg_login_all(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_ns_reg_login(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbx_cmpl_fdmi_reg_login(lpfcHBA_t *, LPFC_MBOXQ_t *);
int lpfc_nlp_bind(lpfc_vport_t *, LPFC_BINDLIST_t *);
int lpfc_nlp_plogi(lpfc_vport_t *, LPFC_NODELIST_t *);
int lpfc_nlp_adisc(lpfc_vport_t *, LPFC_NODELIST_t *);
int lpfc_nlp_unmapped(lpfc_vport_t *, LPFC_NODELIST_t *);
int lpfc_nlp_mapped(lpfc_vport_t *, LPFC_NODELIST_t *, LPFC_BINDLIST_t *);
void lpfc_set_npr_tmo(lpfc_vport_t *, LPFCSCSITARGET_t *, LPFC_NODELIST_t *);
int lpfc_can_npr_tmo(lpfcHBA_t *, LPFCSCSITARGET_t *, LPFC_NODELIST_t *);
void lpfc_set_disctmo(lpfc_vport_t *);
int lpfc_can_disctmo(lpfc_vport_t *);
void lpfc_unreg_rpi_cleanup(lpfc_vport_t *);
int lpfc_driver_abort(lpfcHBA_t *, LPFC_NODELIST_t *);
int lpfc_no_rpi(lpfcHBA_t *, LPFC_NODELIST_t *);
int lpfc_new_rpi(lpfcHBA_t *, uint16_t);
void lpfc_dequenode(lpfc_vport_t *, LPFC_NODELIST_t *);
int lpfc_freenode(lpfc_vport_t *, LPFC_NODELIST_t *);
int lpfc_check_sli_ndlp(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *, 
			LPFC_NODELIST_t *);
int lpfc_nlp_remove(lpfc_vport_t *, LPFC_NODELIST_t *);
void lpfc_vport_purge_nodes(lpfc_vport_t *);
void lpfc_vport_read_rpi_counts(lpfcHBA_t *, uint32_t *, uint32_t *);
LPFC_NODELIST_t *lpfc_findnode_did(lpfc_vport_t *, uint32_t, uint32_t);
LPFC_NODELIST_t *lpfc_findnode_scsiid(lpfc_vport_t *, uint32_t);
LPFC_NODELIST_t *lpfc_findnode_wwpn(lpfc_vport_t *, uint32_t, NAME_TYPE *);
LPFC_NODELIST_t *lpfc_findnode_wwnn(lpfc_vport_t *, uint32_t, NAME_TYPE *);
void lpfc_disc_list_loopmap(lpfc_vport_t *);
void lpfc_disc_start(lpfc_vport_t *);
void lpfc_disc_flush_list(lpfc_vport_t *);
void lpfc_disc_timeout(unsigned long);
void lpfc_linkdown_timeout(unsigned long);
void lpfc_nodev_timeout(unsigned long);
LPFCSCSILUN_t *lpfc_find_lun(lpfc_vport_t *, uint32_t, uint64_t, int);
LPFC_SCSI_BUF_t *lpfc_build_scsi_cmd(lpfc_vport_t *, LPFC_NODELIST_t *, uint32_t,
 				    uint64_t);
int lpfc_disc_issue_rptlun(lpfc_vport_t *, LPFC_NODELIST_t *);
void lpfc_set_failmask(lpfc_vport_t *, LPFC_NODELIST_t *, uint32_t, uint32_t);
LPFC_NODELIST_t *lpfc_findnode_rpi(lpfc_vport_t * phba, uint16_t rpi);
int lpfc_discq_post_event(lpfcHBA_t *, void *, void *, uint32_t);
void lpfc_tasklet(unsigned long);
void lpfc_flush_disc_evtq(lpfcHBA_t *, lpfc_vport_t *);
int lpfc_disc_state_machine(lpfc_vport_t *, LPFC_NODELIST_t *, void *, uint32_t);
uint32_t lpfc_node_teardown (LPFC_NODELIST_t *);
uint32_t lpfc_disc_nodev(lpfcHBA_t *, LPFC_NODELIST_t *, void *, uint32_t);
uint32_t lpfc_disc_neverdev(lpfcHBA_t *, LPFC_NODELIST_t *, void *, uint32_t);

uint32_t lpfc_rcv_plogi_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_els_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_rcv_logo_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_els_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_device_rm_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_device_add_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_device_unk_unused_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_rcv_plogi_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_prli_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_logo_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_els_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_cmpl_plogi_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_cmpl_prli_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_logo_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_adisc_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_device_rm_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_device_unk_plogi_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_rcv_plogi_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_rcv_prli_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				      void *, uint32_t);
uint32_t lpfc_rcv_logo_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				      void *, uint32_t);
uint32_t lpfc_rcv_padisc_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_rcv_prlo_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
				      void *, uint32_t);
uint32_t lpfc_cmpl_plogi_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_cmpl_prli_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_cmpl_logo_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_cmpl_adisc_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_reglogin_issue(lpfc_vport_t *,
 					   LPFC_NODELIST_t *, void *, uint32_t);
uint32_t lpfc_device_rm_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_device_unk_reglogin_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_rcv_plogi_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_prli_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_rcv_logo_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_rcv_padisc_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_prlo_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_cmpl_plogi_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_prli_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_logo_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_adisc_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_device_rm_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_device_add_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_device_unk_prli_issue(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_plogi_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_prli_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_rcv_logo_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_rcv_padisc_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_prlo_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				  void *, uint32_t);
uint32_t lpfc_cmpl_logo_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_adisc_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				       void *, uint32_t);
uint32_t lpfc_device_rm_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_device_add_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_device_unk_prli_compl(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_plogi_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_rcv_prli_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_logo_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_rcv_padisc_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_rcv_prlo_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				   void *, uint32_t);
uint32_t lpfc_cmpl_logo_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_cmpl_adisc_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_cmpl_reglogin_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 					void *, uint32_t);
uint32_t lpfc_device_rm_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				    void *, uint32_t);
uint32_t lpfc_device_add_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);
uint32_t lpfc_device_unk_mapped_node(lpfc_vport_t *, LPFC_NODELIST_t *,
 				     void *, uint32_t);

int lpfc_check_sparm(lpfc_vport_t *, LPFC_NODELIST_t *, SERV_PARM *, uint32_t);
int lpfc_geportname(NAME_TYPE *, NAME_TYPE *);
uint32_t lpfc_add_bind(lpfc_vport_t * vport, uint8_t bind_type,
 		       void *bind_id, uint32_t scsi_id);
uint32_t lpfc_del_bind(lpfc_vport_t * vport, uint8_t bind_type,
 		       void *bind_id, uint32_t scsi_id);
int lpfc_initial_flogi(lpfc_vport_t *);
int lpfc_issue_els_flogi(lpfc_vport_t *, LPFC_NODELIST_t *, uint8_t);
int lpfc_els_abort_flogi(lpfcHBA_t *);
int lpfc_issue_els_fdisc(lpfc_vport_t *, LPFC_NODELIST_t *, int);
int lpfc_issue_els_plogi(lpfc_vport_t *, LPFC_NODELIST_t *, uint8_t);
int lpfc_issue_els_prli(lpfc_vport_t *, LPFC_NODELIST_t *, uint8_t);
int lpfc_issue_els_adisc(lpfc_vport_t *, LPFC_NODELIST_t *, uint8_t);
int lpfc_issue_els_logo(lpfc_vport_t *, LPFC_NODELIST_t *, uint8_t);
int lpfc_issue_els_fabric_logo(lpfc_vport_t *, LPFC_NODELIST_t * ndlp);
int lpfc_issue_els_scr(lpfc_vport_t *, uint32_t, uint8_t);
int lpfc_issue_els_farp(lpfc_vport_t *, uint8_t *, LPFC_FARP_ADDR_TYPE);
int lpfc_issue_els_farpr(lpfc_vport_t *, uint32_t, uint8_t);
LPFC_IOCBQ_t *lpfc_prep_els_iocb(lpfc_vport_t *, uint8_t expectRsp,
 				uint16_t, uint8_t, LPFC_NODELIST_t *, uint32_t);
int lpfc_els_free_iocb(lpfcHBA_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_flogi(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_plogi(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_prli(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_adisc(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_logo(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_cmd(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_acc(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_cmpl_els_logo_acc(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);

int lpfc_els_rsp_acc(lpfc_vport_t *, uint32_t, LPFC_IOCBQ_t *,
 		     LPFC_NODELIST_t *, LPFC_MBOXQ_t *, uint8_t);

int lpfc_els_rsp_reject(lpfc_vport_t *, uint32_t, LPFC_IOCBQ_t *,
 			LPFC_NODELIST_t *, LPFC_MBOXQ_t *);

int lpfc_els_rsp_adisc_acc(lpfc_vport_t *, LPFC_IOCBQ_t *, LPFC_NODELIST_t *);
int lpfc_els_rsp_prli_acc(lpfc_vport_t *, LPFC_IOCBQ_t *, LPFC_NODELIST_t *);
int lpfc_els_retry(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_els_retry_delay(unsigned long);
void lpfc_els_unsol_event(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *);
int lpfc_els_chk_latt(lpfcHBA_t *, LPFC_IOCBQ_t *);
void lpfc_loopback_event(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *);
int lpfc_els_handle_rscn(lpfc_vport_t *);
void lpfc_more_adisc(lpfc_vport_t *);
void lpfc_more_plogi(lpfc_vport_t *);
void lpfc_els_flush_rscn(lpfc_vport_t *);
void lpfc_els_flush_cmd(lpfc_vport_t *);
int lpfc_rscn_payload_check(lpfc_vport_t *, uint32_t);
void lpfc_els_timeout_handler(unsigned long ptr);

void lpfc_hb_timeout_handler(unsigned long);

void lpfc_ct_unsol_event(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *);
int lpfc_ns_cmd(lpfc_vport_t *, int, uint32_t);
void lpfc_ns_cmd_send(lpfcHBA_t *phba);
int lpfc_ct_cmd(lpfc_vport_t *, DMABUF_t *, DMABUF_t *,
 		LPFC_NODELIST_t *, 
		void (*cmpl) (struct lpfcHBA *, LPFC_IOCBQ_t *,
 			       LPFC_IOCBQ_t *), uint32_t);
int lpfc_free_ct_rsp(lpfcHBA_t *, DMABUF_t *);
int lpfc_ns_rsp(lpfc_vport_t *, DMABUF_t *, uint32_t);
int lpfc_issue_ct_rsp(lpfc_vport_t *, uint32_t, DMABUF_t *, DMABUFEXT_t *);
int lpfc_gen_req(lpfc_vport_t *, DMABUF_t *, DMABUF_t *, DMABUF_t *,
 		 void (*cmpl) (struct lpfcHBA *, LPFC_IOCBQ_t *,
 			       LPFC_IOCBQ_t *),
 		 LPFC_NODELIST_t *, uint32_t, uint32_t, uint32_t);

int lpfc_fdmi_cmd(lpfc_vport_t *, LPFC_NODELIST_t *, int);
void lpfc_cmpl_ct_cmd_fdmi(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
void lpfc_fdmi_tmo(unsigned long);

int lpfc_config_port_prep(lpfcHBA_t *);
int lpfc_config_port_post(lpfcHBA_t *);
int lpfc_hba_down_prep(lpfcHBA_t *);
int lpfc_hba_down_post(lpfcHBA_t *);
void lpfc_handle_eratt(lpfcHBA_t *, uint32_t);
void lpfc_handle_latt(lpfcHBA_t *);
void lpfc_hba_init(lpfcHBA_t *);
int lpfc_post_buffer(lpfcHBA_t *, LPFC_SLI_RING_t *, int, int);
void lpfc_cleanup(lpfc_vport_t *, uint32_t);
int lpfc_online(lpfcHBA_t *);
int lpfc_offline(lpfcHBA_t *);
int lpfc_scsi_free(lpfc_vport_t *);
int lpfc_parse_binding_entry(lpfcHBA_t *, uint8_t *, uint8_t *,
			     int, int, int, unsigned int *, int, int *);
void lpfc_decode_firmware_rev(lpfcHBA_t *, char *, int);
uint8_t *lpfc_get_lpfchba_info(lpfcHBA_t *, uint8_t *);
int lpfc_fcp_abort(lpfcHBA_t *, int, int, int);
int lpfc_put_event(lpfcHBA_t *, uint32_t, uint32_t, void *, void *);
int lpfc_hba_put_event(lpfcHBA_t *, uint32_t, uint32_t, uint32_t, uint32_t,
		      uint32_t);
void lpfc_get_hba_model_desc(lpfcHBA_t *, uint8_t *, uint8_t *);
void lpfc_get_hba_sym_node_name(lpfcHBA_t *, uint8_t *);

void lpfc_sli_queue_free(lpfcHBA_t *);
int lpfc_sli_queue_setup(lpfcHBA_t *);
int lpfc_sli_init_fast_lookup(lpfcHBA_t *);
void lpfc_slim_access(lpfcHBA_t *);


int lpfc_utsname_nodename_check(void);
void lpfc_ip_timeout_handler(unsigned long);
uint32_t fc_get_cfg_param(int, int);

void lpfc_qthrottle_up(unsigned long);
void lpfc_npr_timeout(unsigned long);
void lpfc_scsi_assign_rpi(lpfcHBA_t *, LPFCSCSITARGET_t *, uint16_t);
int lpfc_hba_reset(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
void lpfc_scsi_issue_inqsn(lpfcHBA_t *, void *, void *);
void lpfc_scsi_issue_inqp0(lpfcHBA_t *, void *, void *);
void lpfc_iocb_timeout_handler(unsigned long);

uint32_t lpfc_intr_prep(struct lpfcHBA *);
void lpfc_handle_eratt(struct lpfcHBA *, uint32_t);
void lpfc_handle_latt(struct lpfcHBA *);
irqreturn_t lpfc_intr_handler(int, void *, struct pt_regs *);

uint32_t lpfc_read_pci(struct lpfcHBA *, int);
void lpfc_setup_slim_access(struct lpfcHBA *);

void lpfc_read_rev(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_config_ring(lpfcHBA_t *, int, LPFC_MBOXQ_t *);
int lpfc_config_port(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_kill_board(lpfcHBA_t *, LPFC_MBOXQ_t *);
void lpfc_mbox_put(lpfcHBA_t *, LPFC_MBOXQ_t *);
LPFC_MBOXQ_t *lpfc_mbox_get(lpfcHBA_t *);

void lpfc_config_hbq(lpfcHBA_t *, LPFC_HBQ_INIT_t *, uint32_t ,
		     LPFC_MBOXQ_t *);
LPFC_HBQ_ENTRY *lpfc_sli_next_hbq_slot(lpfcHBA_t *, uint32_t);

int lpfc_mem_alloc(lpfcHBA_t *);
int lpfc_mem_free(lpfcHBA_t *);

int lpfc_sli_hba_setup(lpfcHBA_t *);
int lpfc_sli_hba_down(lpfcHBA_t *);
int lpfc_sli_ring_map(lpfcHBA_t *);
int lpfc_sli_intr(lpfcHBA_t *);
int lpfc_sli_issue_mbox(lpfcHBA_t *, LPFC_MBOXQ_t *, uint32_t);
void lpfc_mbox_abort(lpfcHBA_t *);
int lpfc_sli_issue_iocb(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *,
			uint32_t);
int lpfc_sli_resume_iocb(lpfcHBA_t *, LPFC_SLI_RING_t *);
int lpfc_sli_brdkill(lpfcHBA_t *);
int lpfc_sli_brdreset(lpfcHBA_t *, uint32_t);
int lpfc_sli_brdrestart(lpfcHBA_t *);
void lpfc_reset_barrier(lpfcHBA_t *);
int lpfc_sli_brdready(lpfcHBA_t *, uint32_t);

int lpfc_sli_setup(lpfcHBA_t *);
void lpfc_sli_pcimem_bcopy(uint32_t *, uint32_t *, uint32_t);
int lpfc_sli_ringpostbuf_put(lpfcHBA_t *, LPFC_SLI_RING_t *, DMABUF_t *);
DMABUF_t *lpfc_sli_ringpostbuf_get(lpfcHBA_t *, LPFC_SLI_RING_t *, dma_addr_t);

int lpfc_sli_hbqbuf_fill_hbqs(lpfcHBA_t *, uint32_t, uint32_t);
void lpfc_sli_hbqbuf_free_all(lpfcHBA_t *);
struct hbq_dmabuf *lpfc_sli_hbqbuf_find(lpfcHBA_t *, uint32_t);
void lpfc_sli_free_hbq(lpfcHBA_t *, struct hbq_dmabuf *);
int lpfc_sli_hbq_size(void);

void lpfc_sli_abort_req_cmpl(lpfcHBA_t * , LPFC_IOCBQ_t * , LPFC_IOCBQ_t *);
int lpfc_sli_abort_iocb(lpfcHBA_t *, LPFC_SLI_RING_t *, LPFC_IOCBQ_t *);
int lpfc_sli_issue_abort_iotag32(lpfcHBA_t *, LPFC_SLI_RING_t *,
				 LPFC_IOCBQ_t *);
int lpfc_sli_abort_iocb_ring(lpfcHBA_t *, LPFC_SLI_RING_t *, uint32_t);
int lpfc_vport_sli_abort_iocb_ring(lpfcHBA_t *, lpfc_vport_t *,LPFC_SLI_RING_t *, uint32_t);
int lpfc_sli_abort_iocb_ctx(lpfcHBA_t *, LPFC_SLI_RING_t *, uint32_t);
int lpfc_sli_abort_iocb_context1(lpfcHBA_t *, LPFC_SLI_RING_t *, void *);
int lpfc_sli_abort_iocb_lun(lpfc_vport_t *, LPFC_SLI_RING_t *, uint16_t, uint64_t);
int lpfc_sli_abort_iocb_tgt(lpfc_vport_t *, LPFC_SLI_RING_t *, uint16_t);
int lpfc_sli_abort_iocb_hba(lpfcHBA_t *, LPFC_SLI_RING_t *);

void lpfc_start_timer(lpfcHBA_t *, unsigned long, struct timer_list *,
	void (*func) (unsigned long), unsigned long, unsigned long, unsigned long); 
void lpfc_start_timer_ms(lpfcHBA_t *, unsigned long, struct timer_list *,
	void (*func) (unsigned long), unsigned long, unsigned long, unsigned long); 
void lpfc_stop_timer(struct clk_data *);

void lpfc_free_all_delayed_iocbs(lpfcHBA_t *);
void lpfc_free_delayed_iocbs_tmo(unsigned long);
void lpfc_free_delayed_iocbs(lpfcHBA_t *, LPFC_IOCBQ_t *);

void lpfc_sli_wake_iocb_wait(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);
int lpfc_sli_issue_iocb_wait(lpfcHBA_t *, LPFC_SLI_RING_t *,
			    LPFC_IOCBQ_t *, uint32_t, LPFC_IOCBQ_t *, uint32_t);
int lpfc_sli_issue_mbox_wait(lpfcHBA_t *, LPFC_MBOXQ_t *, uint32_t);
void lpfc_sli_wake_mbox_wait(lpfcHBA_t *, LPFC_MBOXQ_t *);
int lpfc_sleep(lpfcHBA_t *, void *, long tmo);
void lpfc_wakeup(lpfcHBA_t *, void *);

int lpfc_os_prep_io(lpfcHBA_t *, LPFC_SCSI_BUF_t *);
LPFC_SCSI_BUF_t *lpfc_get_scsi_buf(lpfcHBA_t *);
void lpfc_free_scsi_buf(LPFC_SCSI_BUF_t *);
LPFCSCSILUN_t *lpfc_find_lun_device(LPFC_SCSI_BUF_t *);
void lpfc_map_fcp_cmnd_to_bpl(lpfcHBA_t *, LPFC_SCSI_BUF_t *);
void lpfc_free_scsi_cmd(LPFC_SCSI_BUF_t *);
uint32_t lpfc_os_timeout_transform(lpfcHBA_t *, uint32_t);
void lpfc_os_return_scsi_cmd(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
int lpfc_scsi_cmd_start(LPFC_SCSI_BUF_t *);
int lpfc_scsi_prep_task_mgmt_cmd(lpfcHBA_t *, LPFC_SCSI_BUF_t *, uint8_t);
int lpfc_scsi_cmd_abort(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
int lpfc_scsi_lun_reset(lpfc_vport_t *, uint32_t, uint32_t, uint64_t,
			struct scsi_cmnd *, uint32_t);
int lpfc_scsi_tgt_reset(lpfc_vport_t *, uint32_t, uint32_t);

int lpfc_get_inst_by_phba(lpfcHBA_t *);
lpfcHBA_t *lpfc_get_phba_by_inst(int);
int lpfc_check_valid_phba(lpfcHBA_t * phba);

void lpfc_qfull_retry(unsigned long);
void lpfc_scsi_lower_lun_qthrottle(lpfc_vport_t *, LPFC_SCSI_BUF_t *);

int lpfc_sched_submit_command(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
void lpfc_sched_queue_command(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
void lpfc_sched_add_target_to_ring(lpfc_vport_t *, LPFCSCSITARGET_t *);
void lpfc_sched_remove_target_from_ring(lpfc_vport_t *, LPFCSCSITARGET_t *);
void lpfc_sched_add_lun_to_ring(lpfc_vport_t *, LPFCSCSILUN_t *);
void lpfc_sched_remove_lun_from_ring(lpfc_vport_t *, LPFCSCSILUN_t *);

int lpfc_sli_issue_iocb_wait_high_priority(lpfcHBA_t *,
					  LPFC_SLI_RING_t *,
					  LPFC_IOCBQ_t *, uint32_t,
					  LPFC_IOCBQ_t *,
					  uint32_t);
void lpfc_sli_wake_iocb_high_priority(lpfcHBA_t *, LPFC_IOCBQ_t *,
				     LPFC_IOCBQ_t *);

void *lpfc_hbq_alloc(lpfcHBA_t *, int, dma_addr_t *);
void lpfc_hbq_free(lpfcHBA_t *, void *, dma_addr_t);

void *lpfc_page_alloc(lpfcHBA_t *, int, dma_addr_t *);
void lpfc_page_free(lpfcHBA_t *, void *, dma_addr_t);
void *lpfc_mbuf_alloc(lpfcHBA_t *, int, dma_addr_t *);
void lpfc_mbuf_free(lpfcHBA_t *, void *, dma_addr_t);

LPFC_MBOXQ_t *lpfc_mbox_alloc(lpfcHBA_t *, int);
void lpfc_mbox_free(lpfcHBA_t *, LPFC_MBOXQ_t *);

LPFC_IOCBQ_t *lpfc_iocb_alloc(lpfcHBA_t *, int);
void lpfc_iocb_free(lpfcHBA_t *, LPFC_IOCBQ_t *);

LPFC_NODELIST_t *lpfc_nlp_alloc(lpfcHBA_t *, int);
void lpfc_nlp_free(lpfcHBA_t *, LPFC_NODELIST_t *);
LPFC_BINDLIST_t *lpfc_bind_alloc(lpfcHBA_t *, int);
void lpfc_bind_free(lpfcHBA_t *, LPFC_BINDLIST_t *);
int lpfc_bind_setup(lpfc_vport_t *);

void lpfc_sleep_ms(lpfcHBA_t *, int);
void lpfc_drvr_init_lock(lpfcHBA_t *);
void lpfc_drvr_lock(lpfcHBA_t *, unsigned long *);
void lpfc_drvr_unlock(lpfcHBA_t *, unsigned long *);
void lpfc_hipri_init_lock(lpfcHBA_t *);
void lpfc_hipri_lock(lpfcHBA_t *, unsigned long *);
void lpfc_hipri_unlock(lpfcHBA_t *, unsigned long *);

uint32_t lpfc_read_pci(lpfcHBA_t *, int);

void lpfc_nodev(unsigned long);

void lpfc_iodone(lpfc_vport_t *, LPFC_SCSI_BUF_t *, uint32_t);
void lpfc_scsi_done(lpfc_vport_t *, struct scsi_cmnd *, uint32_t);
int lpfc_scsi_delay_iodone(lpfc_vport_t *, LPFC_SCSI_BUF_t *);
void lpfc_unblock_requests(lpfcHBA_t *);
void lpfc_block_requests(lpfcHBA_t *);
void myprint(char *, void *, void *, void *, void *);

void lpfc_set_pkt_len(struct sk_buff *, uint32_t);
void *lpfc_get_pkt_data(struct sk_buff *);

void lpfc_scsi_cmd_iocb_cmpl(lpfcHBA_t *, LPFC_IOCBQ_t *, LPFC_IOCBQ_t *);

/* Function prototypes. */
int lpfc_revoke(struct scsi_device *);
int lpfc_queuecommand(struct scsi_cmnd *, void (*done) (struct scsi_cmnd *));
int lpfc_abort_handler(struct scsi_cmnd *);
int lpfc_reset_lun_handler(struct scsi_cmnd *);

/* Interface exported by fabric iocb scheduler */
int lpfc_issue_fabric_iocb(lpfcHBA_t *, LPFC_IOCBQ_t *);
void lpfc_fabric_abort_vport(lpfc_vport_t *);
void lpfc_fabric_abort_nport(lpfcHBA_t *, LPFC_NODELIST_t *);
void lpfc_fabric_abort_hba(lpfcHBA_t *);
void lpfc_fabric_abort_flogi(lpfcHBA_t *);

#ifdef __VMKERNEL_MODULE__
/* vport interface. */
int lpfc_vport_create(struct Scsi_Host *, struct vport_data *);
int lpfc_vport_delete(struct Scsi_Host *);
int lpfc_vport_getinfo(struct Scsi_Host *, struct vport_info *);
int lpfc_vport_tgt_remove(struct Scsi_Host *, unsigned int, unsigned int);
#endif
#endif
