/*******************************************************************
 * This file is part of the Emulex Linux Device Driver for         *
 * Fibre Channel Host Bus Adapters.                                *
 * Copyright (C) 2003-2008 Emulex.  All rights reserved.           *
 * EMULEX and SLI are trademarks of Emulex.                        *
 * www.emulex.com                                                  *
 *                                                                 *
 * This program is free software; you can redistribute it and/or   *
 * modify it under the terms of version 2 of the GNU General       *
 * Public License as published by the Free Software Foundation.    *
 * This program is distributed in the hope that it will be useful. *
 * ALL EXPRESS OR IMPLIED CONDITIONS, REPRESENTATIONS AND          *
 * WARRANTIES, INCLUDING ANY IMPLIED WARRANTY OF MERCHANTABILITY,  *
 * FITNESS FOR A PARTICULAR PURPOSE, OR NON-INFRINGEMENT, ARE      *
 * DISCLAIMED, EXCEPT TO THE EXTENT THAT SUCH DISCLAIMERS ARE HELD *
 * TO BE LEGALLY INVALID.  See the GNU General Public License for  *
 * more details, a copy of which can be found in the file COPYING  *
 * included with this package.                                     *
 *******************************************************************/

/*
 * $Id: lpfc_ioctl.h 3037 2007-05-22 14:02:22Z bsebastian $
 */

#ifndef _H_LPFC_IOCTL
#define _H_LPFC_IOCTL

#include "hbaapi.h"

#define MAX_LPFC_BRDS 32

/* Used for libdfc/lpfc driver rev lock*/
#define DFC_MAJOR_REV   4	
#define DFC_MINOR_REV	0	

/* LPFC Ioctls() 0x00 - 0x3F. */

/* LPFC_FIRST_COMMAND_USED	0x01	   First defines Ioctl used  */
#define LPFC_WRITE_PCI		0x01	/* Write to PCI */
#define LPFC_READ_PCI		0x06	/* Read from PCI */

/* LPFC COMMAND POSITION	0xc        available. */
#define LPFC_READ_MEM		0x0d	/* Read memory */
/* LPFC COMMAND POSITION	0xf        available. */

#define LPFC_MBOX		0x12	/* Issue a MB cmd */
#define LPFC_RESET		0x13	/* Reset the adapter */
#define LPFC_READ_HBA		0x14	/* Get adapter info */
/* LPFC COMMAND POSITION	0x15	   available. */
#define LPFC_WRITE_MEM		0x16	/* Write to SLIM memory */
#define LPFC_WRITE_CTLREG	0x17	/* Write to Control register */
#define LPFC_READ_CTLREG	0x18	/* Read from Control control register */
#define LPFC_INITBRDS		0x19	/* Initialize the adapters */
#define LPFC_SETDIAG		0x1a	/* Set/get board online/offline */
#define LPFC_INST		0x1b	/* get instance info */


/* Support call for dfc. */
#define LPFC_DEVP		0x1c	/* Get Device information */

#define LPFC_READ_BPLIST	0x2d	/* get list of buffers post */
#define LPFC_LINKINFO		0x2f	/* get link information */
#define LPFC_IOINFO  		0x30	/* get I/O stats */
#define LPFC_NODEINFO  		0x31	/* get node (NPort) information */


#define LPFC_ADD_BIND		0x36	/* Add a new binding */
#define LPFC_DEL_BIND		0x37	/* Del a binding */

#define LPFC_LIST_BIND		0x38	/* List binding */
#define LPFC_MENLO		0x39	/* Issue menlo cmd */

/*	LPFC_LAST_IOCTL_USED	0x39	Last LPFC Ioctl used  */


/* LPFC Ioctls() 0x40 - 0x7F */

/* LPFC_FIRST_IOCTL_USED		0x40     First defines Ioctl used  */
#define LPFC_LIP			0x41	/* Issue a LIP */
#define LPFC_CT				0x42	/* Send CT passthru command */
#define LPFC_LISTN			0x43	/* List nodes for adapter
						 * (by WWPN, WWNN and DID) */

/* Event definitions for RegisterForEvent */
#define FC_REG_LINK_EVENT       0x1     /* Register for link up / down events */
#define FC_REG_RSCN_EVENT       0x2     /* Register for RSCN events */
#define FC_REG_CT_EVENT         0x4     /* Register for CT request events */
#define FC_REG_DUMP_EVENT       0x10    /* Register for Dump events */
#define FC_REG_TEMPERATURE_EVENT 0x20   /* Register for temperature event */

/*  HBA API specific Ioctls() */
#define LPFC_HBA_ADAPTERATTRIBUTES	0x48	/* Get attributes of HBA */
#define LPFC_HBA_PORTATTRIBUTES		0x49	/* Get attributes of HBA Port */
#define LPFC_HBA_PORTSTATISTICS		0x4a	/* Get statistics of HBA Port */
#define LPFC_HBA_DISCPORTATTRIBUTES	0x4b	/* Get attibutes of the
						 * discovered adapter Ports */
#define LPFC_HBA_WWPNPORTATTRIBUTES	0x4c	/* Get attributes of the Port
						 * specified by WWPN */
#define LPFC_HBA_INDEXPORTATTRIBUTES	0x4d	/* Get attributes of the Port
						 * specified by index */
#define LPFC_HBA_FCPTARGETMAPPING	0x4e	/* Get info for all FCP tgt's */
#define LPFC_HBA_FCPBINDING		0x4f	/* Binding info for FCP tgts */



#define LPFC_HBA_SETMGMTINFO		0x50	/* Sets driver values with
						 * default HBA_MGMTINFO vals */
#define LPFC_HBA_GETMGMTINFO		0x51	/* Get driver values for
						 * HBA_MGMTINFO vals */
#define LPFC_HBA_RNID			0x52	/* Send an RNID request */
#define LPFC_HBA_GETEVENT		0x53	/* Get event data */
#define LPFC_HBA_SEND_SCSI		0x55	/* Send SCSI requests to tgt */
#define LPFC_HBA_REFRESHINFO		0x56	/* Do a refresh of the stats */
#define LPFC_SEND_ELS			0x57	/* Send out an ELS command */
#define LPFC_HBA_SEND_FCP		0x58	/* Send out a FCP command */
#define LPFC_HBA_SET_EVENT		0x59	/* Set FCP event(s) */
#define LPFC_HBA_GET_EVENT		0x5a	/* Get  FCP event(s) */
#define LPFC_HBA_SEND_MGMT_CMD		0x5b	/* Send a management command */
#define LPFC_HBA_SEND_MGMT_RSP		0x5c	/* Send a management response */

/* Support calls for dfc */
/* #define LPFC_COMMAND_POSITION        0x61       available */
#define LPFC_RESET_QDEPTH		0x62	/* Reset adapter Q depth */
#define LPFC_OUTFCPIO			0x63	/* Number of outstanding I/Os */

#define LPFC_GETCFG			0x64	/* Get config parameters */
#define LPFC_SETCFG			0x65	/* Set config parameters */
#define LPFC_STAT			0x67	/* Statistics for SLI/FC/IP */
#define LPFC_GET_DFC_REV		0x68	/* Get the rev of the ioctl driver */
#define LPFC_GET_VPD			0x69	/* Get Adapter VPD */

/* Future VPORT IOCTL API */
#define LPFC_CREATE_VPORT		0x6a    /* Create a new vport (deprecated)*/
#define LPFC_DELETE_VPORT		0x6b    /* Delete an existing vport (deprecated)*/
#define LPFC_GET_VPORT_INFO		0x6c    /* Get a VPORT's info  (deprecated)*/

#define LPFC_GET_LPFCDFC_INFO		0x70	/* Get lpfcdfc driver info */
#define LPFC_GET_DUMPREGION		0x71	/* Get Adapter Dump Region */
#define LPFC_LOOPBACK_TEST              0x72    /* Run Loopback test */
#define LPFC_LOOPBACK_MODE              0x73    /* Enter Loopback mode */
#define LPFC_TEMP_SENSOR_SUPPORT        0x74    /* Get temp sensor support */

/* DFC NPIV IOCTL Commands*/
#define LPFC_VPORT_GET_ATTRIB		0x80	/* Get vport attibutes */ 
#define LPFC_VPORT_GET_LIST		0x81	/* Get vports on this pport */
#define LPFC_VPORT_GET_RESRC		0x82	/* Get vport resources */
#define LPFC_VPORT_GET_NODE_INFO	0x83	/* Get vport node info by WWPN */
#define LPFC_NPIV_READY			0x84	/* NPIV Ready Test */
/*  LPFC_LAST_IOCTL_USED 	        0x84       Last LPFC Ioctl used  */


/* Data structure definitions: */

/*
 * Diagnostic (DFC) Command & Input structures: (LPFC)
 */
typedef struct lpfcCmdInput {
	short    lpfc_brd;
	short    lpfc_ring;
	short    lpfc_iocb;
	short    lpfc_flag;
	void    *lpfc_arg1;
	void    *lpfc_arg2;
	void    *lpfc_arg3;
	char    *lpfc_dataout;
	uint32_t lpfc_cmd;
	uint32_t lpfc_outsz;
	uint32_t lpfc_arg4;
	uint32_t lpfc_arg5;
} LPFCCMDINPUT_t;

#if defined(CONFIG_COMPAT) && !defined(__ia64__)
/* 32 bit version */
typedef struct lpfcCmdInput32 {
	short    lpfc_brd;
	short    lpfc_ring;
	short    lpfc_iocb;
	short    lpfc_flag;
	u32	lpfc_arg1;
	u32	lpfc_arg2;
	u32     lpfc_arg3;
	u32     lpfc_dataout;
	uint32_t lpfc_cmd;
	uint32_t lpfc_outsz;
	uint32_t lpfc_arg4;
	uint32_t lpfc_arg5;
} LPFCCMDINPUT32_t;
#endif


/* Structure for OUTFCPIO command */

struct out_fcp_devp {
	uint16_t target;
	uint16_t lun;
	uint16_t tx_count;
	uint16_t txcmpl_count;
	uint16_t delay_count;
	uint16_t sched_count;
	uint16_t lun_qdepth;
	uint16_t current_qdepth;
	uint32_t qcmdcnt;
	uint32_t iodonecnt;
	uint32_t errorcnt;
	uint8_t  pad[4]; /* pad structure to 8 byte boundary */
};

/* Structure for VPD command */

struct vpd {
	uint32_t version;
#define VPD_VERSION1     1
	uint8_t  ModelDescription[256];    /* VPD field V1 */
	uint8_t  Model[80];                /* VPD field V2 */
	uint8_t  ProgramType[256];         /* VPD field V3 */
	uint8_t  PortNum[20];              /* VPD field V4 */
};

#define MREC_MAX 16
#define arecord(a, b, c, d)

struct rec {
	void *arg0;
	void *arg1;
	void *arg2;
	void *arg3;
};

/* Structure used for transfering mailbox extension data */
struct ioctl_mailbox_ext_data {
	uint32_t in_ext_byte_len;
	uint32_t out_ext_byte_len;
	uint8_t  mbox_offset_word;
	uint8_t  mbox_extension_data[MAILBOX_EXT_SIZE];
};

/*
 * This structure needs to fit in di->fc_dataout alloc'ed memory
 * array in dfc_un for dfc.c / C_TRACE
 */
struct mrec {
	ulong reccnt;
	struct rec rectbl[MREC_MAX];
};

/* the DfcRevInfo structure */
typedef struct DFCREVINFO {
	uint32_t a_Major;
	uint32_t a_Minor;
} DfcRevInfo;

#define DFC_DRVID_STR_SZ 16 
#define DFC_FW_STR_SZ 32

/* the brdinfo structure */
typedef struct BRDINFO {
	uint32_t a_mem_hi;	/* memory identifier for adapter access */
	uint32_t a_mem_low;	/* memory identifier for adapter access */
	uint32_t a_flash_hi;	/* memory identifier for adapter access */
	uint32_t a_flash_low;	/* memory identifier for adapter access */
	uint32_t a_ctlreg_hi;	/* memory identifier for adapter access */
	uint32_t a_ctlreg_low;	/* memory identifier for adapter access */
	uint32_t a_intrlvl;	/* interrupt level for adapter */
	uint32_t a_pci;		/* PCI identifier (device / vendor id) */
	uint32_t a_busid;	/* identifier of PCI bus adapter is on */
	uint32_t a_devid;	/* identifier of PCI device number */
	uint8_t a_rsvd1;	/* reserved for future use */
	uint8_t a_rsvd2;	/* reserved for future use */
	uint8_t a_siglvl;	/* signal handler used by library */
	uint8_t a_ddi;		/* identifier device driver instance number */
	uint32_t a_onmask;	/* mask of ONDI primatives supported */
	uint32_t a_offmask;	/* mask of OFFDI primatives supported */
	uint8_t a_drvrid[DFC_DRVID_STR_SZ];	/* driver version */
	uint8_t a_fwname[DFC_FW_STR_SZ];	/* firmware version */
} brdinfo;

/* the dfc_brdinfo structure */
typedef struct DFC_BRDINFO {
	uint32_t a_mem_hi;	/* memory identifier for adapter access */
	uint32_t a_mem_low;	/* memory identifier for adapter access */
	uint32_t a_flash_hi;	/* memory identifier for adapter access */
	uint32_t a_flash_low;	/* memory identifier for adapter access */
	uint32_t a_ctlreg_hi;	/* memory identifier for adapter access */
	uint32_t a_ctlreg_low;	/* memory identifier for adapter access */
	uint32_t a_intrlvl;	/* interrupt level for adapter */
	uint32_t a_pci;		/* PCI identifier (device / vendor id) */
	uint32_t a_busid;	/* identifier of PCI bus adapter is on */
	uint32_t a_devid;	/* identifier of PCI device number */
	uint8_t  a_rsvd1;	/* reserved for future use */
	uint8_t  a_siglvl;	/* signal handler used by library */
	uint16_t a_ddi;		/* identifier device driver instance number */
	uint32_t a_onmask;	/* mask of ONDI primatives supported */
	uint32_t a_offmask;	/* mask of OFFDI primatives supported */
	uint8_t  a_drvrid[DFC_DRVID_STR_SZ];	/* driver version */
	uint8_t  a_fwname[DFC_FW_STR_SZ];	/* firmware version */
	uint8_t  a_wwpn[8];	/* worldwide portname */
} dfc_brdinfo;

typedef struct {
	uint8_t bind_type;
	uint8_t wwpn[8];
	uint8_t wwnn[8];
	uint32_t did;
	uint32_t scsi_id;
} bind_ctl_t;

struct dfc_info {
	uint32_t a_pci;
	uint32_t a_busid;
	uint32_t a_devid;
	uint32_t a_ddi;
	uint32_t a_onmask;
	uint32_t a_offmask;
	uint8_t  a_drvrid[DFC_DRVID_STR_SZ];
	uint8_t  a_fwname[DFC_FW_STR_SZ];
	uint8_t  a_wwpn[8];
};

#define LPFC_DFC_CMD_IOCTL_MAGIC 0xFC
#define LPFC_DFC_CMD_IOCTL _IOWR(LPFC_DFC_CMD_IOCTL_MAGIC, 0x1, LPFCCMDINPUT_t) 	/* Used for ioctl command */
#define LPFC_DFC_CMD_IOCTL32 _IOWR(LPFC_DFC_CMD_IOCTL_MAGIC, 0x1, LPFCCMDINPUT32_t) 	/* Used for ioctl command */

/* DFC specific data structures */

typedef struct dfcptr {
	uint32_t addrhi;
	uint32_t addrlo;
} dfcptr_t;

typedef struct dfcu64 {
	uint32_t hi;
	uint32_t lo;
} dfcu64_t;

typedef struct dfcringmask {
	uint8_t rctl;
	uint8_t type;
	uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcringmask_t;

typedef struct dfcringinit {
	dfcringmask_t prt[LPFC_MAX_RING_MASK];
	uint32_t num_mask;
	uint32_t iotag_ctr;
	uint16_t numCiocb;
	uint16_t numRiocb;
	uint8_t  pad[4]; /* pad structure to 8 byte boundary */
} dfcringinit_t;

typedef struct dfcsliinit {
	dfcringinit_t ringinit[LPFC_MAX_RING];
	uint32_t num_rings;
	uint32_t sli_flag;
} dfcsliinit_t;

typedef struct dfcsliring {
	uint16_t txq_cnt;
	uint16_t txq_max;
	uint16_t txcmplq_cnt;
	uint16_t txcmplq_max;
	uint16_t postbufq_cnt;
	uint16_t postbufq_max;
	uint32_t missbufcnt;
	dfcptr_t cmdringaddr;
	dfcptr_t rspringaddr;
	uint8_t  rspidx;
	uint8_t  cmdidx;
	uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcsliring_t;

typedef struct dfcslistat {
	dfcu64_t iocbEvent[LPFC_MAX_RING];
	dfcu64_t iocbCmd[LPFC_MAX_RING];
	dfcu64_t iocbRsp[LPFC_MAX_RING];
	dfcu64_t iocbCmdFull[LPFC_MAX_RING];
	dfcu64_t iocbCmdEmpty[LPFC_MAX_RING];
	dfcu64_t iocbRspFull[LPFC_MAX_RING];
	dfcu64_t mboxStatErr;
	dfcu64_t mboxCmd;
	dfcu64_t sliIntr;
	uint32_t errAttnEvent;
	uint32_t linkEvent;
} dfcslistat_t;

typedef struct dfcsli {
	dfcsliinit_t sliinit;
	dfcsliring_t ring[LPFC_MAX_RING];
	dfcslistat_t slistat;
	dfcptr_t MBhostaddr;
	uint16_t mboxq_cnt;
	uint16_t mboxq_max;
	uint32_t fcp_ring;
} dfcsli_t;

typedef struct dfcschedhba {
        uint32_t status;
        uint16_t targetCount;
        uint16_t maxOutstanding;
        uint16_t currentOutstanding;
        uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcschedhba_t;

typedef struct dfcschedlun {
        uint32_t status;
        uint16_t maxOutstanding;
        uint16_t currentOutstanding;
} dfcschedlun_t;

typedef struct dfcschedtarget {
        uint32_t status;
        uint16_t lunCount;
        uint16_t maxOutstanding;
        uint16_t currentOutstanding;
        uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcschedtarget_t;

typedef struct dfchba {
        dfcschedhba_t hbaSched;
        dfcsli_t sli;
        uint32_t hba_state;
        uint32_t cmnds_in_flight;
        uint8_t fc_busflag;
        uint8_t  pad[3]; /* pad structure to 8 byte boundary */
} dfchba_t;

typedef struct dfcnodelist {
	uint32_t nlp_failMask;
	uint16_t nlp_type;
	uint16_t nlp_rpi;
	uint16_t nlp_state;
	uint16_t nlp_xri;
	uint32_t nlp_flag;
	uint32_t nlp_DID;
	uint32_t nlp_oldDID;
	uint8_t  nlp_portname[8];
	uint8_t  nlp_nodename[8];
	uint16_t nlp_sid;
	uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcnodelist_t;

typedef struct dfcscsilun {
        dfcschedlun_t lunSched;
	dfcu64_t lun_id;
	uint32_t lunFlag;
	uint32_t failMask;
	uint8_t  InquirySN[LPFC_INQSN_SZ];
	uint8_t  Vendor[8];
	uint8_t  Product[16];
	uint8_t  Rev[4];
	uint8_t  sizeSN;
	uint8_t  pad[3]; /* pad structure to 8 byte boundary */
} dfcscsilun_t;


typedef struct dfcscsitarget {
        dfcschedtarget_t targetSched;
	dfcptr_t context;
	uint16_t max_lun;
	uint16_t scsi_id;
	uint16_t targetFlags;
	uint16_t addrMode;
        uint16_t rptLunState;
	uint8_t  pad[6]; /* pad structure to 8 byte boundary */
} dfcscsitarget_t;

typedef struct dfcbindlist {
	uint8_t  nlp_portname[8];
	uint8_t  nlp_nodename[8];
	uint16_t nlp_bind_type;
	uint16_t nlp_sid;
	uint32_t nlp_DID;
} dfcbindlist_t;

typedef struct dfcstat {
	uint32_t elsRetryExceeded;
	uint32_t elsXmitRetry;
	uint32_t elsRcvDrop;
	uint32_t elsRcvFrame;
	uint32_t elsRcvRSCN;
	uint32_t elsRcvRNID;
	uint32_t elsRcvFARP;
	uint32_t elsRcvFARPR;
	uint32_t elsRcvFLOGI;
	uint32_t elsRcvPLOGI;
	uint32_t elsRcvADISC;
	uint32_t elsRcvPDISC;
	uint32_t elsRcvFAN;
	uint32_t elsRcvLOGO;
	uint32_t elsRcvPRLO;
	uint32_t elsRcvPRLI;
        uint32_t elsRcvRRQ;
	uint32_t elsRcvLIRR;
	uint32_t elsRcvRPS;
	uint32_t elsRcvRPL;
	uint32_t frameRcvBcast;
	uint32_t frameRcvMulti;
	uint32_t strayXmitCmpl;
	uint32_t frameXmitDelay;
	uint32_t xriCmdCmpl;
	uint32_t xriStatErr;
	uint32_t LinkUp;
	uint32_t LinkDown;
	uint32_t LinkMultiEvent;
	uint32_t NoRcvBuf;
	uint32_t fcpCmd;
	uint32_t fcpCmpl;
	uint32_t fcpRspErr;
	uint32_t fcpRemoteStop;
	uint32_t fcpPortRjt;
	uint32_t fcpPortBusy;
	uint32_t fcpError;
} dfcstats_t;


typedef struct dfc_vpqos {  /* temporary holding place */
       uint32_t  buf;
} DFC_VPQoS ;

typedef struct dfc_VpAttrib {
        uint8_t ver;            /* [OUT]; Set to 2 for OUT functions. */
        uint8_t reserved1[3];
        HBA_WWN wwpn;           /* [OUT] virtual WWPN */
        HBA_WWN wwnn;           /* [OUT] virtual WWNN */
        char name[256];         /* [OUT] symbolic port name registered with the name server */
        uint32_t options;       /* Not Supported */
        uint32_t portFcId;      /* [OUT] Assigned DID by Fabric following succes sful FDISC. */
#define ATTRIB_STATE_UNKNOWN    0
#define ATTRIB_STATE_LINKDOWN   1
#define ATTRIB_STATE_INIT       2
#define ATTRIB_STATE_NO_NPIV    3
#define ATTRIB_STATE_NO_RESRC   4
#define ATTRIB_STATE_LOGO       5
#define ATTRIB_STATE_REJECT     6
#define ATTRIB_STATE_FAILED     7
#define ATTRIB_STATE_ACTIVE     8
#define ATTRIB_STATE_FAUTH      9
        uint8_t state;          /* [OUT] */
        uint8_t restrictLogin;  /* Not Supported */
        uint8_t reserved2[2];
        uint64_t buf;           /* [OUT]; platform dependent specific info, not supported */
        DFC_VPQoS QoS;          /* Not Supported */
        HBA_WWN fabricName;     /* [OUT] Fabric WWN */
        uint32_t checklist;     /* Not Supported */
        uint8_t accessKey[32];  /* Not Supported*/
} DFC_VPAttrib;

typedef struct dfc_NodeInfoEntry {
    uint32_t type ;
#define NODE_INFO_TYPE_DID          0x0
#define NODE_INFO_TYPE_WWNN         0x1
#define NODE_INFO_TYPE_WWPN         0x2
#define NODE_INFO_TYPE_AUTOMAP          0x4
#define NODE_INFO_TYPE_UNMASK_LUNS      0x8
#define NODE_INFO_TYPE_DISABLE_LUN_AUTOMAP  0x10
#define NODE_INFO_TYPE_ALPA         0x20
    HBA_SCSIID scsiId;
    HBA_FCPID fcpId ;
#define NODE_INFO_STATE_EXIST           0x1
#define NODE_INFO_STATE_READY           0x2
#define NODE_INFO_STATE_LINKDOWN        0x4
#define NODE_INFO_STATE_UNMAPPED        0x8
#define NODE_INFO_STATE_PERSISTENT      0x10
    uint32_t nodeState ;
    uint32_t reserved ;
} DFC_NodeInfoEntry;

typedef struct dfc_GetNodeInfo {
    uint32_t numberOfEntries ;  /* number of nodes */
    DFC_NodeInfoEntry nodeInfo[1];  /* start of the DFC_NodeInfo array */
} DFC_GetNodeInfo;


typedef struct dfc_VpEntry {
        HBA_WWN wwpn; /* vport wwpn */
        HBA_WWN wwnn; /* vport wwnn */
        uint32_t PortFcId; /* DID from successful FDISC. */
} DFC_VPEntry;


typedef struct DFC_VPENTRYLIST {
    uint32_t numberOfEntries;
    DFC_VPEntry vpentry[1];
} DFC_VPEntryList;

typedef struct DFC_VPRESOURCE {
        uint32_t vlinks_max;
        uint32_t vlinks_inuse;
        uint32_t rpi_max;
        uint32_t rpi_inuse;
} DFC_VPResource;




typedef union IOARG{
	struct {
		HBA_WWN  vport_wwpn; /* Input Arg */
		HBA_WWN  targ_wwpn;  /* Input Arg */  
	}Iarg;

	struct {
		uint32_t rspcnt; /* Output Arg */
		uint32_t snscnt; /* Output Arg */
	}Oarg;
} IOargUn;

#define BY_WWN_IOCTL_SUPPORT 1



#define CHECKLIST_BIT_NPIV	0x0001	/* Set if driver NPIV enabled */
#define	CHECKLIST_BIT_SLI3	0x0002	/* Set if SLI-3 enabled */
#define CHECKLIST_BIT_HBA	0x0004	/* Set if HBA support NPIV */
#define CHECKLIST_BIT_RSRC	0x0008	/* Set if resources available*/
#define CHECKLIST_BIT_LINK	0x0010	/* Set if link up */
#define CHECKLIST_BIT_FBRC	0x0020	/* Set if point-to-point fabric connection */
#define CHECKLIST_BIT_FSUP	0x0040	/* Set if Fabric support NPIV */
#define CHECKLIST_BIT_NORSRC	0x0080	/* Set if FDISC fails w/no LS_RJT reason*/
#endif				/* _H_LPFC_IOCTL */
