#/*******************************************************************
# * This file is part of the Emulex Linux Device Driver for         *
# * Enterprise Fibre Channel Host Bus Adapters.                     *
# * Refer to the README file included with this package for         *
# * driver version and adapter support.                             *
# * Copyright (C) 2004 Emulex Corporation.                          *
# * www.emulex.com                                                  *
# *                                                                 *
# * This program is free software; you can redistribute it and/or   *
# * modify it under the terms of the GNU General Public License     *
# * as published by the Free Software Foundation; either version 2  *
# * of the License, or (at your option) any later version.          *
# *                                                                 *
# * This program is distributed in the hope that it will be useful, *
# * but WITHOUT ANY WARRANTY; without even the implied warranty of  *
# * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the   *
# * GNU General Public License for more details, a copy of which    *
# * can be found in the file COPYING included with this package.    *
# *******************************************************************/

#%define    rel     1
%define    ver     LPFC_DRIVER_VERSION
%define    tarName lpfc-rpm.tar

Summary:   Emulex Fibre Channel driver for Linux
Name:      lpfcdriver
Version:   %ver
Release:   %rel
Copyright: Emulex Corp.
Group:     System Environment/Kernel
Source:    %tarName 
URL:       http://www.emulex.com
Vendor:    Emulex Corp.
Packager:  Regis.Goupil
Requires:  kernel >= 2.4.0
Requires:  rpm >= 3.0.4
BuildRoot: /tmp/lpfc-%{ver}-rpmbuildroot
Prefix: /usr/src/linux/drivers/scsi/lpfc

%description
Emulex Fibre Channel driver for Linux

%prep
%setup

%build

%install
rm -rf $RPM_BUILD_ROOT/usr/src/linux/drivers/scsi/lpfc
mkdir -p $RPM_BUILD_ROOT/usr/src/linux/drivers/scsi/lpfc
find . -print | cpio -pdumv $RPM_BUILD_ROOT/usr/src/linux/drivers/scsi/lpfc

%clean
rm -rf $RPM_BUILD_ROOT

%post
if test -e /etc/lpfc.conf
then
echo "Found /etc/lpfc.conf file possibly from old installation."
echo "Installing new /etc/lpfc.conf file. Your old /etc/lpfc.conf" 
echo "file will be moved to /etc/lpfc.conf.old."
mv /etc/lpfc.conf /etc/lpfc.conf.old
fi
ln -s $RPM_INSTALL_PREFIX/lpfc.conf /etc/lpfc.conf
echo "  "
echo "The Emulex Open Source Driver has been installed on your system." 
echo "Source files have been installed under $RPM_INSTALL_PREFIX"
echo "Please refer to the Emulex documentation for the next step."
echo "  "


%preun
echo "  "
echo "The lpfcdriver rpm is about to be removed from your system."
echo "All the source files under $RPM_INSTALL_PREFIX will be removed."
echo "  "

rm -f /etc/lpfc.conf
cd $RPM_INSTALL_PREFIX
rm -f *.o

%postun
rm -f /dev/lpfcdfc
echo "  "
echo "The Emulex Open Source Driver has been removed from your system."
echo "Remove the appropriate entry in modules.conf if this file was modified."
echo "  "

%files
/usr/src/linux/drivers/scsi/lpfc/lpfc.conf
/usr/src/linux/drivers/scsi/lpfc/lpfc.spec
/usr/src/linux/drivers/scsi/lpfc/COPYING
/usr/src/linux/drivers/scsi/lpfc/core.c
/usr/src/linux/drivers/scsi/lpfc/elx_cfgparm.h
/usr/src/linux/drivers/scsi/lpfc/elx_clock.h
/usr/src/linux/drivers/scsi/lpfc/elx_crtn.h
/usr/src/linux/drivers/scsi/lpfc/elx_disc.h
/usr/src/linux/drivers/scsi/lpfc/elx.h
/usr/src/linux/drivers/scsi/lpfc/elx_hw.h
/usr/src/linux/drivers/scsi/lpfc/elx_ioctl.h
/usr/src/linux/drivers/scsi/lpfc/elx_logmsg.h
/usr/src/linux/drivers/scsi/lpfc/elx_mem.h
/usr/src/linux/drivers/scsi/lpfc/elx_os.h
/usr/src/linux/drivers/scsi/lpfc/elx_os_scsiport.h
/usr/src/linux/drivers/scsi/lpfc/elx_sched.h
/usr/src/linux/drivers/scsi/lpfc/elx_scsi.h
/usr/src/linux/drivers/scsi/lpfc/elx_sli.h
/usr/src/linux/drivers/scsi/lpfc/elx_util.h
/usr/src/linux/drivers/scsi/lpfc/hbaapi.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_cfgparm.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_core.c
/usr/src/linux/drivers/scsi/lpfc/lpfc_crtn.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_diag.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_disc.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_hba.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_hw.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_ioctl.h
/usr/src/linux/drivers/scsi/lpfc/lpfc_ip.h
/usr/src/linux/drivers/scsi/lpfc/lpfcLINUXfcp.c
/usr/src/linux/drivers/scsi/lpfc/lpfcLINUXlan.c
/usr/src/linux/drivers/scsi/lpfc/lpfc_module_param.h
/usr/src/linux/drivers/scsi/lpfc/Makefile
/usr/src/linux/drivers/scsi/lpfc/prod_crtn.h
/usr/src/linux/drivers/scsi/lpfc/prod_linux.c
/usr/src/linux/drivers/scsi/lpfc/prod_os.h
/usr/src/linux/drivers/scsi/lpfc/README
/usr/src/linux/drivers/scsi/lpfc/Remove.sh
/usr/src/linux/drivers/scsi/lpfc/Install.sh

