#determine if library is installed
if [ "$1" = "clean" ]; then
	make -C ./extras clean >& /dev/null
	exit 0
fi
SDM_LIB="/usr/lib/libqlsdm.so"
LIB_VERSION=""
LIB_MAJ=""
LIB_MIN=""
LIB_BUILD=""
if [ -e $SDM_LIB ]; then
	#check version is greater than 3.00 build 6	
	LIB_VERSION=`strings $SDM_LIB | grep "library version" | sed "s/.*v//"`
	LIB_MAJ=`echo $LIB_VERSION | sed "s/\(.*\)\..*/\1/"`		
	if [ "$LIB_MAJ" = "" ]; then
		LIB_MAJ=0
	fi

	echo $LIB_MAJ | grep -w "^[0-9]\+$" >& /dev/null
	if [ $? -ne 0 ]; then
		echo "Maj version: $LIB_MAJ should be numeric"
		echo "Skipping  qla_gdmp build"
		exit 0
	fi
	LIB_MIN=`echo $LIB_VERSION | sed "s/.*\.\(.*\) build.*/\1/"`		
	if [ "$LIB_MIN" = "" ]; then
		LIB_MIN=0
	fi

	echo $LIB_MIN | grep -w "^[0-9]\+$" >& /dev/null
	if [ $? -ne 0 ]; then
		echo "Min version: $LIB_MIN should be numeric"
		echo "Skipping  qla_gdmp build"
		exit 0
	fi

	LIB_BUILD=`echo $LIB_VERSION | sed "s/.*build//"`		
	if [ "$LIB_BUILD" = "" ]; then
		LIB_BUILD=0
	fi

	echo $LIB_BUILD | grep -w "^[0-9]\+$" >& /dev/null
	if [ $? -ne 0 ]; then
		echo "Build version: $LIB_BUILD should be numeric"
		echo "Skipping  qla_gdmp build"
		exit 0
	fi

	if [ $LIB_MAJ -lt 3 ]; then
		echo "API Lib version should be greater than 3.00 build6"
		exit 0
	fi 

	if [ $LIB_MAJ -eq 3 ]; then
		if [ $LIB_BUILD -lt 6 ]; then
			if [ $LIB_MIN -eq 0 ]; then
				echo "API Lib venison should be greater than 3.00 build6"
				exit 0
			fi 
		fi
	fi
	make -C extras 
else
	echo "QL API SDM LIB not available"
fi
