/********************************************************************************
* QLogic ISP2xxx Firmware Dump Reader
* Copyright (C) 2006 QLogic Corporation
* (www.qlogic.com)
*
* This program is free software; you can redistribute it and/or modify it
* under the terms of the GNU General Public License as published by the
* Free Software Foundation; either version 2, or (at your option) any
* later version.
*
* This program is distributed in the hope that it will be useful, but
* WITHOUT ANY WARRANTY; without even the implied warranty of
* MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
* General Public License for more details.
*
******************************************************************************/

#ifndef	_QLA_GDMP_H
#define	_QLA_GDMP_H

#define SDMGT_HANDLE int

/* Error code */
#define SDMGT_BASE_ERROR_CODE                   0x20000000
#define SDMGT_NONE                              0

/* General routine call errors */
#define SDMGT_INVALID_PARAMETER                 (SDMGT_BASE_ERROR_CODE | 0x64)
#define SDMGT_INVALID_HANDLE                    (SDMGT_BASE_ERROR_CODE | 0x65)
#define SDMGT_COMMAND_NOT_SUPPORTED             (SDMGT_BASE_ERROR_CODE | 0x66)
#define SDMGT_DEVICE_BUSY                       (SDMGT_BASE_ERROR_CODE | 0x67)
#define SDMGT_REQUEST_PENDING                   (SDMGT_BASE_ERROR_CODE | 0x68)
#define SDMGT_REQUEST_SUSPENDED                 (SDMGT_BASE_ERROR_CODE | 0x69)
#define SDMGT_REQUEST_RETRY_PENDING             (SDMGT_BASE_ERROR_CODE | 0x6a)
#define SDMGT_DATA_OVERRUN                      (SDMGT_BASE_ERROR_CODE | 0x6b)
#define SDMGT_DATA_UNDERRUN                     (SDMGT_BASE_ERROR_CODE | 0x6c)
#define SDMGT_DEV_NOT_FOUND                     (SDMGT_BASE_ERROR_CODE | 0x6d)
#define SDMGT_COPY_ERR                          (SDMGT_BASE_ERROR_CODE | 0x6e)
#define SDMGT_FW_MAILBOX                        (SDMGT_BASE_ERROR_CODE | 0x6f)
#define SDMGT_UNSUPPORTED_SUBCODE               (SDMGT_BASE_ERROR_CODE | 0x70)
#define SDMGT_UNSUPPORTED_VERSION               (SDMGT_BASE_ERROR_CODE | 0x71)
#define SDMGT_BUFFER_TOO_SMALL                  (SDMGT_BASE_ERROR_CODE | 0x72)
#define SDMGT_INVALID_REQUEST                   (SDMGT_BASE_ERROR_CODE | 0x73)
#define SDMGT_OUT_OF_MEMORY                     (SDMGT_BASE_ERROR_CODE | 0x74)
#define SDMGT_UNKNOWN                           (SDMGT_BASE_ERROR_CODE | 0x75)
#define SDMGT_INVALID_REGISTRY_SETTING          (SDMGT_BASE_ERROR_CODE | 0x76)
#define SDMGT_API_BUILT_DATA                    (SDMGT_BASE_ERROR_CODE | 0x77)
#define SDMGT_PERSISTENT_STORAGE_ERROR          (SDMGT_BASE_ERROR_CODE | 0x78)

#define SDMGT_DEVICE_NOT_READY                  (SDMGT_BASE_ERROR_CODE | 0x79)
#define SDMGT_DEVICE_OFFLINE                    (SDMGT_BASE_ERROR_CODE | 0x7a)
#define SDMGT_HBA_NOT_READY                     (SDMGT_BASE_ERROR_CODE | 0x7b)
#define SDMGT_HBA_QUEUE_FULL                    (SDMGT_BASE_ERROR_CODE | 0x7c)

#define SDMGT_INVALID_CHECKSUM                  (SDMGT_BASE_ERROR_CODE | 0x7d)
#define SDMGT_INVALID_FW_STATE                  (SDMGT_BASE_ERROR_CODE | 0x7e)

#define SDMGT_CANNOT_RESERVE_MUTEX              (SDMGT_BASE_ERROR_CODE | 0x7f)

/* OS specific types */
typedef char SD_INT8, *SD_PINT8;
typedef short SD_INT16, *SD_PINT16;
typedef int SD_INT32, *SD_PINT32;
typedef long long SD_INT64, *SD_PINT64;
typedef unsigned char SD_UINT8, *SD_PUINT8;
typedef unsigned short SD_UINT16, *SD_PUINT16;
typedef unsigned int SD_UINT32, *SD_PUINT32;
typedef unsigned long long SD_UINT64, *SD_PUINT64;
typedef void SD_VOID, *SD_PVOID;

/*
 * Firmware Dump structure definition
 */
struct qla2100_fw_dump {
	uint16_t hccr;
	uint16_t pbiu_reg[8];
	uint16_t mailbox_reg[32];
	uint16_t dma_reg[48];
	uint16_t risc_hdw_reg[16];
	uint16_t risc_gp0_reg[16];
	uint16_t risc_gp1_reg[16];
	uint16_t risc_gp2_reg[16];
	uint16_t risc_gp3_reg[16];
	uint16_t risc_gp4_reg[16];
	uint16_t risc_gp5_reg[16];
	uint16_t risc_gp6_reg[16];
	uint16_t risc_gp7_reg[16];
	uint16_t frame_buf_hdw_reg[16];
	uint16_t fpm_b0_reg[64];
	uint16_t fpm_b1_reg[64];
	uint16_t risc_ram[0xf000];
};

struct qla2300_fw_dump {
	uint16_t hccr;
	uint16_t pbiu_reg[8];
	uint16_t risc_host_reg[8];
	uint16_t mailbox_reg[32];
	uint16_t resp_dma_reg[32];
	uint16_t dma_reg[48];
	uint16_t risc_hdw_reg[16];
	uint16_t risc_gp0_reg[16];
	uint16_t risc_gp1_reg[16];
	uint16_t risc_gp2_reg[16];
	uint16_t risc_gp3_reg[16];
	uint16_t risc_gp4_reg[16];
	uint16_t risc_gp5_reg[16];
	uint16_t risc_gp6_reg[16];
	uint16_t risc_gp7_reg[16];
	uint16_t frame_buf_hdw_reg[64];
	uint16_t fpm_b0_reg[64];
	uint16_t fpm_b1_reg[64];
	uint16_t risc_ram[0xf800];
	uint16_t stack_ram[0x1000];
	uint16_t data_ram[1];
};

struct qla24xx_fw_dump {
	uint32_t host_status;
	uint32_t host_reg[32];
	uint32_t shadow_reg[7];
	uint16_t mailbox_reg[32];
	uint32_t xseq_gp_reg[128];
	uint32_t xseq_0_reg[16];
	uint32_t xseq_1_reg[16];
	uint32_t rseq_gp_reg[128];
	uint32_t rseq_0_reg[16];
	uint32_t rseq_1_reg[16];
	uint32_t rseq_2_reg[16];
	uint32_t cmd_dma_reg[16];
	uint32_t req0_dma_reg[15];
	uint32_t resp0_dma_reg[15];
	uint32_t req1_dma_reg[15];
	uint32_t xmt0_dma_reg[32];
	uint32_t xmt1_dma_reg[32];
	uint32_t xmt2_dma_reg[32];
	uint32_t xmt3_dma_reg[32];
	uint32_t xmt4_dma_reg[32];
	uint32_t xmt_data_dma_reg[16];
	uint32_t rcvt0_data_dma_reg[32];
	uint32_t rcvt1_data_dma_reg[32];
	uint32_t risc_gp_reg[128];
	uint32_t lmc_reg[112];
	uint32_t fpm_hdw_reg[192];
	uint32_t fb_hdw_reg[176];
	uint32_t code_ram[0x2000];
	uint32_t ext_mem[1];
};

#define EFT_BYTES_PER_BUFFER    0x4000

struct qla2xxx_fw_dump {
	uint8_t signature[4];
	uint32_t version;

	uint32_t fw_major_version;
	uint32_t fw_minor_version;
	uint32_t fw_subminor_version;
	uint32_t fw_attributes;

	uint32_t vendor;
	uint32_t device;
	uint32_t subsystem_vendor;
	uint32_t subsystem_device;

	uint32_t fixed_size;
	uint32_t mem_size;
	uint32_t req_q_size;
	uint32_t rsp_q_size;

	uint32_t eft_size;
	uint32_t eft_addr_l;
	uint32_t eft_addr_h;

	uint32_t header_size;

	union {
		struct qla2100_fw_dump isp21;
		struct qla2300_fw_dump isp23;
		struct qla24xx_fw_dump isp24;
	} isp;
};

#endif /* _QLA_GDMP_H */ 
