/******************************************************************************
 *                  QLOGIC LINUX SOFTWARE
 *
 * QLogic qla3010ip network driver for Linux 2.4.x
 * Copyright (C) 2004 Qlogic Corporation
 * (www.qlogic.com)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 ******************************************************************************/

/****************************************************************************
	      Please see revision.notes for revision history.
*****************************************************************************/
#include "ql4nvram.h"

int   eepromSize  = FM93C66A_SIZE_16;
int   addrBits    = FM93C56A_NO_ADDR_BITS_16;
int   dataBits    = FM93C56A_DATA_BITS_16;
int   eepromCmdData = 0;

#define ISP_NVRAM   (u32 *)chip_addr


int FM93C56A_Select(u32 * chip_addr)
{
	QL4PRINT(QLP17, printk(KERN_ERR "FM93C56A_Select:\n"));
	eepromCmdData = AUBURN_EEPROM_CS_1 | 0x000f0000 ;
	WRT_REG_DWORD(chip_addr, eepromCmdData);
	return(1);
}
int FM93C56A_Cmd(int cmd, int addr, u32 *chip_addr)
{
	int   i;
	int   mask;
	int   dataBit;
	int   previousBit;

	QL4PRINT(QLP17, printk(KERN_ERR "FM93C56A_Cmd(%d, 0x%x)\n", cmd, addr));

	// Clock in a zero, then do the start bit
	WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | AUBURN_EEPROM_DO_1);
	WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | AUBURN_EEPROM_DO_1 | AUBURN_EEPROM_CLK_RISE);
	WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | AUBURN_EEPROM_DO_1 | AUBURN_EEPROM_CLK_FALL);

	mask = 1 << (FM93C56A_CMD_BITS-1);
	// Force the previous data bit to be different
	previousBit = 0xffff;
	for (i = 0; i < FM93C56A_CMD_BITS; i++) {
		dataBit = (cmd & mask) ? AUBURN_EEPROM_DO_1 : AUBURN_EEPROM_DO_0;
		if (previousBit != dataBit) {
			// If the bit changed, then change the DO state to match
			WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit);
			previousBit = dataBit;
		}
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit | AUBURN_EEPROM_CLK_RISE);
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit | AUBURN_EEPROM_CLK_FALL);
		cmd = cmd << 1;
	}

	mask = 1 << (addrBits-1);
	// Force the previous data bit to be different
	previousBit = 0xffff;
	for (i = 0; i < addrBits; i++) {
		dataBit = (addr & mask) ? AUBURN_EEPROM_DO_1 : AUBURN_EEPROM_DO_0;
		if (previousBit != dataBit) {
			// If the bit changed, then change the DO state to match
			WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit);
			previousBit = dataBit;
		}
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit | AUBURN_EEPROM_CLK_RISE);
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | dataBit | AUBURN_EEPROM_CLK_FALL);
		addr = addr << 1;
	}
	return(1);
}

int FM93C56A_Deselect(u32 *chip_addr)
{
	QL4PRINT(QLP17, printk(KERN_ERR "FM93C56A_Deselect:\n"));
	eepromCmdData = AUBURN_EEPROM_CS_0 | 0x000f0000 ;
	WRT_REG_DWORD(ISP_NVRAM, eepromCmdData);
	return(1);
}

int FM93C56A_DataIn(unsigned short *value, u32 *chip_addr)
{
	int   i;
	int   data = 0;
	int   dataBit;

	// Read the data bits
	// The first bit is a dummy.  Clock right over it.
	for (i = 0; i < dataBits; i++) {
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | AUBURN_EEPROM_CLK_RISE);
		WRT_REG_DWORD(ISP_NVRAM, eepromCmdData | AUBURN_EEPROM_CLK_FALL);
		dataBit = (RD_REG_DWORD(ISP_NVRAM) & AUBURN_EEPROM_DI_1) ? 1 : 0;
		data = (data << 1) | dataBit;
	}
	*value = data;
	QL4PRINT(QLP17, printk(KERN_ERR "FM93C56A_DataIn(0x%x)\n", *value));
	return(1);
}

int
EEPROM_ReadWord(int eepromAddr, u16 *value, scsi_qla_host_t *ha)
{
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_Reg addr %p\n", &ha->reg->NVRAM));
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_ReadWord(0x%x)\n", eepromAddr));

	FM93C56A_Select(&ha->reg->NVRAM);
	FM93C56A_Cmd(FM93C56A_READ, eepromAddr, &ha->reg->NVRAM);
	FM93C56A_DataIn(value, &ha->reg->NVRAM);
	FM93C56A_Deselect(&ha->reg->NVRAM);
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_ReadWord(0x%x, %d)\n", eepromAddr, *value));
	return(1);
}

u16
RD_NVRAM_WORD(scsi_qla_host_t *ha, u16 *offset)
{
	u16 val;
	/* NOTE: NVRAM uses half-word addresses */
	EEPROM_ReadWord((int)(u_long) offset >> 1, &val, ha);
	return(val);
}


/*
 * Overrides for Emacs so that we get a uniform tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 4
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * c-continued-statement-offset: 4
 * c-continued-brace-offset: 0
 * indent-tabs-mode: nil
 * tab-width: 8
 * End:
 */
