/************************************************************************/
/*                                                                      */
/*              NOTICE                                                  */
/*                                                                      */
/*       COPYRIGHT 2002-2004 QLOGIC CORPORATION                         */
/*            ALL RIGHTS RESERVED                                       */
/*                                                                      */
/*     This computer program  is  CONFIDENTIAL  and a TRADE SECRET      */
/*     of  QLOGIC CORPORATION.  The  receipt  or possesion of this      */
/*     program does not convey any rights to reproduce or disclose      */
/*     its contents, or to manufacture, use, or sell anything that      */
/*     it may describe, in whole or in part, without the  specific      */
/*     written consent of QLOGIC CORPORATION.  Any reproduction of      */
/*     this program  without the express written consent of QLOGIC      */
/*     CORPORATION  is a violation  of the copyright laws  and may      */
/*     subject you to criminal prosecution.                             */
/*                                                                      */
/************************************************************************/

/*
 * Module Name: ql3nvrm.h
 */


#ifndef _QL2XNVRM_H_
#define _QL2XNVRM_H_


//
// AM29LV Flash definitions
//
#define  FM93C56A_SIZE_8      0x100
#define  FM93C56A_SIZE_16     0x80
#define  FM93C66A_SIZE_8      0x200
#define  FM93C66A_SIZE_16     0x100

#define  FM93C56A_START       0x1

// Commands
#define  FM93C56A_READ        0x2
#define  FM93C56A_WEN         0x0
#define  FM93C56A_WRITE       0x1
#define  FM93C56A_WRITE_ALL   0x0
#define  FM93C56A_WDS         0x0
#define  FM93C56A_ERASE       0x3
#define  FM93C56A_ERASE_ALL   0x0

// Command Extentions
#define  FM93C56A_WEN_EXT        0x3
#define  FM93C56A_WRITE_ALL_EXT  0x1
#define  FM93C56A_WDS_EXT        0x0
#define  FM93C56A_ERASE_ALL_EXT  0x2

// Address Bits
#define  FM93C56A_NO_ADDR_BITS_16   8
#define  FM93C56A_NO_ADDR_BITS_8    9


// Data Bits
#define  FM93C56A_DATA_BITS_16   16
#define  FM93C56A_DATA_BITS_8    8

// Special Bits
#define  FM93C56A_READ_DUMMY_BITS   1
#define  FM93C56A_READY             0
#define  FM93C56A_BUSY              1
#define  FM93C56A_CMD_BITS          2

// Auburn Bits
#define  AUBURN_EEPROM_DI           0x8
#define  AUBURN_EEPROM_DI_0         0x0
#define  AUBURN_EEPROM_DI_1         0x8
#define  AUBURN_EEPROM_DO           0x4
#define  AUBURN_EEPROM_DO_0         0x0
#define  AUBURN_EEPROM_DO_1         0x4
#define  AUBURN_EEPROM_CS           0x2
#define  AUBURN_EEPROM_CS_0         0x0
#define  AUBURN_EEPROM_CS_1         0x2
#define  AUBURN_EEPROM_CLK_RISE     0x1
#define  AUBURN_EEPROM_CLK_FALL     0x0


//
// EEPROM format
//

typedef struct EEPROM_DATA_ {
   u8    id[4];	
   u8    version;
   u8    reserved;
		
   u16   boardId;
#  define   EEPROM_BOARDID_ELDORADO    1
#  define   EEPROM_BOARDID_PLACER      2

#  define EEPROM_SERIAL_NUM_SIZE    16
   u8    serialNumber[EEPROM_SERIAL_NUM_SIZE];

// ExtHwConfig:
// Offset = 24bytes
//
// | SSRAM Size|     |ST|PD|SDRAM SZ| W| B| SP  |  |
// |15|14|13|12|11|10| 9| 8 | 7| 6| 5| 4| 3| 2| 1| 0|
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
   u16   extHwConfig;				

   u8    mac0[6];
   u8    mac1[6];
   u8    mac2[6];
   u8    mac3[6];

   u16   etherMtu;
   u16   macConfig;
#define  MAC_CONFIG_ENABLE_ANEG     0x0001
#define  MAC_CONFIG_ENABLE_PAUSE    0x0002

   u16   phyConfig;
#define  PHY_CONFIG_PHY_ADDR_MASK             0x1f
#define  PHY_CONFIG_ENABLE_FW_MANAGEMENT_MASK 0x20

#  define EEPROM_UNUSED_1_SIZE   4
   u8    unused_1[EEPROM_UNUSED_1_SIZE];

   u16   bufletSize;
   u16   bufletCount;
   u16   bufletPauseThreshold;
   u16   tcpWindowThreshold50;
   u16   tcpWindowThreshold25;
   u16   tcpWindowThreshold0;
   u16   ipHashTableBaseHi;
   u16   ipHashTableBaseLo;
   u16   ipHashTableSize;
   u16   tcpHashTableBaseHi;
   u16   tcpHashTableBaseLo;
   u16   tcpHashTableSize;
   u16   ncbTableBaseHi;
   u16   ncbTableBaseLo;
   u16   ncbTableSize;
   u16   drbTableBaseHi;
   u16   drbTableBaseLo;
   u16   drbTableSize;

#  define EEPROM_UNUSED_2_SIZE   4
   u8    unused_2[EEPROM_UNUSED_2_SIZE];

   u16   ipReassemblyTimeout;
   u16   tcpMaxWindowSizeHi;
   u16   tcpMaxWindowSizeLo;

   u32   net_ip_addr0 ;	               /* Added for TOE functionality. */
   u32   net_ip_addr1 ;	
   u32   scsi_ip_addr0 ;	
   u32   scsi_ip_addr1 ;	
#  define EEPROM_UNUSED_3_SIZE   128	/* changed from 144 to account for ip addresses */
   u8    unused_3[EEPROM_UNUSED_3_SIZE];

   u16   subsysVendorId_f0;
   u16   subsysDeviceId_f0;

   // Address = 0x7F
#  define FM93C56A_SIGNATURE  0x9356
#  define FM93C66A_SIGNATURE  0x9366
   u16   signature;

#  define EEPROM_UNUSED_4_SIZE   250
   u8    unused_4[EEPROM_UNUSED_4_SIZE];

   u16   subsysVendorId_f1;
   u16   subsysDeviceId_f1;

   u16   checksum;

} EEPROM_DATA;

#endif // _QL2XNVRM_H_

/*
 * Overrides for Emacs so that we get a uniform tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 4
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * c-continued-statement-offset: 4
 * c-continued-brace-offset: 0
 * indent-tabs-mode: nil
 * tab-width: 8
 * End:
 */
