/******************************************************************************
 *                  QLOGIC LINUX SOFTWARE
 *
 * QLogic ISP4xxx device driver for Linux 2.4.x
 * Copyright (C) 2002 Qlogic Corporation
 * (www.qlogic.com)
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2, or (at your option) any
 * later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 ******************************************************************************/

#include <linux/version.h>

/*
 * This file set some defines that are required to compile the
 * command source for 4000 module
 *----------------------------------------------------------------------------*/
#define QLA4000
#define QLA4XXX_BOARD_ID		0x4000
#define QLA4XXX_BOARD_ID_STRING		"4000"
#define QLA4XXX_BOARD_NAME_STRING	"QLA4000"
#define QLA4XXX_BOARD_PORTS		1
#define QLA4XXX_PROC_NAME		"qla4000"

#define MEMORY_MAPPED_IO		1  /* Always set to 1,
					    * I/O Mapped not supported*/

#define REQ_Q_MEM_ALIGN_VALUE           (0x1000) /* Align on 4K boundary */
#define RSP_Q_MEM_ALIGN_VALUE           (0x1000)
#define MEM_ALIGN_VALUE           	(0x1000)

/*
 * Define Common Register Accesses (see qla4x_fw.h)
 *----------------------------------------------------------------------------*/
#define ISP_CLEAR_RSP_Q_INTR(ha)     (WRT_REG_DWORD(&ha->reg->interruptStatusOut, ISO_RSP_QUEUE_COMPLETE))
#define ISP_CLEAR_MBOX_INTR(ha,msts) (WRT_REG_DWORD(&ha->reg->mailboxOut0, msts))

#define ISP_RD_RSP_Q_IN(ha)	((uint16_t) RD_REG_DWORD(&ha->reg->responseQueueInPointer))
#define ISP_RD_REQ_Q_OUT(ha)	((uint16_t) RD_REG_DWORD(&ha->reg->requestQueueOutPointer))

#define ISP_RD_INTR_MASK(ha)	(RD_REG_DWORD(&ha->reg->interruptMaskOut))
#define ISP_RD_INTR_STATUS(ha)	(RD_REG_DWORD(&ha->reg->interruptStatusOut))

#define ISP_ENABLE_INTRS(ha)  	(WRT_REG_DWORD(&ha->reg->interruptMaskOut, ~((uint32_t)INTR_PENDING)))
#define ISP_DISABLE_INTRS(ha)	(WRT_REG_DWORD(&ha->reg->interruptMaskOut, (uint32_t) INTR_PENDING))

/*
 * Scsi_Host_template (see hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/

/*
 * max_sectors
 *
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,8)
#define TEMPLATE_MAX_SECTORS	max_sectors: 0,  /* OS defined */
#else
#define TEMPLATE_MAX_SECTORS
#endif

/*
 * name
 */
#define TEMPLATE_NAME		name: "QLogic iSCSI 4000",


/*
 * Include common source
 *----------------------------------------------------------------------------*/
#include "ql4drvr.c"

