/******************************************************************************
 *     Copyright (C)  2003 -2005 QLogic Corporation
 * QLogic ISP4xxx Device Driver
 *
 * This program includes a device driver for Linux 2.4.x that may be
 * distributed with QLogic hardware specific firmware binary file.
 * You may modify and redistribute the device driver code under the
 * GNU General Public License as published by the Free Software Foundation
 * (version 2 or a later version) and/or under the following terms,
 * as applicable:
 *
 * 	1. Redistribution of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above copyright
 *         notice, this list of conditions and the following disclaimer in
 *         the documentation and/or other materials provided with the
 *         distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 * 	
 * You may redistribute the hardware specific firmware binary file under
 * the following terms:
 * 	1. Redistribution of source code (only if applicable), must
 *         retain the above copyright notice, this list of conditions and
 *         the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above
 *         copyright notice, this list of conditions and the following
 *         disclaimer in the documentation and/or other materials provided
 *         with the distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 *
 * REGARDLESS OF WHAT LICENSING MECHANISM IS USED OR APPLICABLE,
 * THIS PROGRAM IS PROVIDED BY QLOGIC CORPORATION "AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * USER ACKNOWLEDGES AND AGREES THAT USE OF THIS PROGRAM WILL NOT CREATE
 * OR GIVE GROUNDS FOR A LICENSE BY IMPLICATION, ESTOPPEL, OR OTHERWISE
 * IN ANY INTELLECTUAL PROPERTY RIGHTS (PATENT, COPYRIGHT, TRADE SECRET,
 * MASK WORK, OR OTHER PROPRIETARY RIGHT) EMBODIED IN ANY OTHER QLOGIC
 * HARDWARE OR SOFTWARE EITHER SOLELY OR IN COMBINATION WITH THIS PROGRAM
 *
 ******************************************************************************
 * Function Table of Contents:
 *      qla4xxx_take_hw_semaphore
 *      qla4xxx_clear_hw_semaphore
 ****************************************************************************/



#ifdef QLA4000
#define  qla4xxx_sem_lock(ha, sem_mask, sem_bits) 1
#define  qla4xxx_sem_unlock(ha, sem_mask)
#define  qla4xxx_sem_spinlock(ha, sem_mask, sem_bits) 1
#else
int qla4xxx_sem_spinlock(scsi_qla_host_t *ha, u32 sem_mask, u32 sem_bits)
 {
    uint32_t      value;
    QL4PRINT(QLP25, printk(KERN_INFO "scsi%d : Trying to get SEM lock - mask= 0x%x, code = 0x%x\n",
	ha->host_no, sem_mask, sem_bits));
    while ( 1 ) {
        WRT_REG_DWORD(ISP_SEMAPHORE(ha), (sem_mask | sem_bits));
        value = RD_REG_DWORD(ISP_SEMAPHORE(ha));
        if ((value & (sem_mask >> 16)) == sem_bits) {
    		QL4PRINT(QLP25, printk(KERN_INFO "scsi%d : Got SEM LOCK - mask= 0x%x, code = 0x%x\n",
		ha->host_no, sem_mask, sem_bits));
            break;
	}
    }
   return (1);
 }

void qla4xxx_sem_unlock(scsi_qla_host_t *ha, u32 sem_mask)
{
    WRT_REG_DWORD(ISP_SEMAPHORE(ha), sem_mask);
    PCI_POSTING(ISP_SEMAPHORE(ha));
    QL4PRINT(QLP25, printk(KERN_INFO "scsi%d : UNLOCK SEM - mask= 0x%x\n",
	 ha->host_no, sem_mask));
}

int qla4xxx_sem_lock(scsi_qla_host_t *ha, u32 sem_mask, u32 sem_bits)
{
	uint32_t      value;
	WRT_REG_DWORD(ISP_SEMAPHORE(ha), (sem_mask | sem_bits));
	value = RD_REG_DWORD(ISP_SEMAPHORE(ha));
	if ((value & (sem_mask >> 16)) == sem_bits) {
		QL4PRINT(QLP25, printk(KERN_INFO "scsi%d : Got SEM LOCK - mask= 0x%x, code = 0x%x, sema code=0x%x\n",
				       ha->host_no, sem_mask, sem_bits, value));
		return(1);
	} else {
		return(0);
	}
}

#ifdef QLA4010
/* Semaphore Defines for 4010 */
#define QLA4010_DRVR_SEM_BITS    0x00000030
#define QLA4010_GPIO_SEM_BITS    0x000000c0
#define QLA4010_SDRAM_SEM_BITS   0x00000300
#define QLA4010_PHY_SEM_BITS     0x00000c00
#define QLA4010_NVRAM_SEM_BITS   0x00003000
#define QLA4010_FLASH_SEM_BITS   0x0000c000

#define QLA4010_DRVR_SEM_MASK    0x00300000
#define QLA4010_GPIO_SEM_MASK    0x00c00000
#define QLA4010_SDRAM_SEM_MASK   0x03000000
#define QLA4010_PHY_SEM_MASK     0x0c000000
#define	QLA4010_NVRAM_SEM_MASK	0x30000000
#define QLA4010_FLASH_SEM_MASK   0xc0000000


#define QLA4XXX_LOCK_FLASH(a) 	(qla4xxx_sem_spinlock(a, QLA4010_FLASH_SEM_MASK, QLA4010_FLASH_SEM_BITS))
#define QLA4XXX_LOCK_NVRAM(a)   (qla4xxx_sem_spinlock(a, QLA4010_NVRAM_SEM_MASK, QLA4010_NVRAM_SEM_BITS))
#define QLA4XXX_LOCK_GIO(a) 	(qla4xxx_sem_spinlock(a, QLA4010_GPIO_SEM_MASK, QLA4010_GPIO_SEM_BITS))
#define QLA4XXX_LOCK_PHY(a) 	(qla4xxx_sem_spinlock(a, QLA4010_PHY_SEM_MASK, QLA4010_PHY_SEM_BITS))
#define QLA4XXX_LOCK_DDR_RAM(a) (qla4xxx_sem_spinlock(a, QLA4010_SDRAM_SEM_MASK, QLA4010_SDRAM_SEM_BITS))
#define QLA4XXX_LOCK_DRVR(a)  	(qla4xxx_sem_lock(a, QLA4010_DRVR_SEM_MASK, QLA4010_DRVR_SEM_BITS))
#define QLA4XXX_UNLOCK_DRVR(a) 	(qla4xxx_sem_unlock(a, QLA4010_DRVR_SEM_MASK))
#define QLA4XXX_UNLOCK_GIO(a) 	(qla4xxx_sem_unlock(a, QLA4010_GPIO_SEM_MASK))
#define QLA4XXX_UNLOCK_DDR_RAM(a) (qla4xxx_sem_unlock(a, QLA4010_SDRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_PHY(a) 	(qla4xxx_sem_unlock(a, QLA4010_PHY_SEM_MASK))
#define QLA4XXX_UNLOCK_NVRAM(a) (qla4xxx_sem_unlock(a, QLA4010_NVRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_FLASH(a) (qla4xxx_sem_unlock(a, QLA4010_FLASH_SEM_MASK))
#else

#ifdef QLA4022
/* Semaphore Defines for 4022 */
#define QLA4022_RESOURCE_MASK_BASE_CODE 0x7
#define QLA4022_RESOURCE_BITS_BASE_CODE 0x4

#define QLA4022_DRVR_SEM_BITS    (QLA4022_RESOURCE_BITS_BASE_CODE << 1)
#define QLA4022_DDR_RAM_SEM_BITS (QLA4022_RESOURCE_BITS_BASE_CODE << 4)
#define QLA4022_PHY_GIO_SEM_BITS (QLA4022_RESOURCE_BITS_BASE_CODE << 7)
#define QLA4022_NVRAM_SEM_BITS   (QLA4022_RESOURCE_BITS_BASE_CODE << 10)
#define QLA4022_FLASH_SEM_BITS   (QLA4022_RESOURCE_BITS_BASE_CODE << 13)

#define QLA4022_DRVR_SEM_MASK    (QLA4022_RESOURCE_MASK_BASE_CODE << (1+16))
#define QLA4022_DDR_RAM_SEM_MASK (QLA4022_RESOURCE_MASK_BASE_CODE << (4+16))
#define QLA4022_PHY_GIO_SEM_MASK (QLA4022_RESOURCE_MASK_BASE_CODE << (7+16))
#define QLA4022_NVRAM_SEM_MASK   (QLA4022_RESOURCE_MASK_BASE_CODE << (10+16))
#define QLA4022_FLASH_SEM_MASK   (QLA4022_RESOURCE_MASK_BASE_CODE << (13+16))

#define QLA4XXX_LOCK_FLASH(a)   (qla4xxx_sem_spinlock(a, QLA4022_FLASH_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 13))
#define QLA4XXX_LOCK_NVRAM(a)   (qla4xxx_sem_spinlock(a, QLA4022_NVRAM_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 10))
#define QLA4XXX_LOCK_GIO(a) 	(qla4xxx_sem_spinlock(a, QLA4022_PHY_GIO_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 7))
#define QLA4XXX_LOCK_PHY(a) 	(qla4xxx_sem_spinlock(a, QLA4022_PHY_GIO_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 7))
#define QLA4XXX_LOCK_DDR_RAM(a) (qla4xxx_sem_spinlock(a, QLA4022_DDR_RAM_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 4))
#define QLA4XXX_LOCK_DRVR(a)    (qla4xxx_sem_lock(a, QLA4022_DRVR_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 1))
#define QLA4XXX_UNLOCK_DRVR(a)  (qla4xxx_sem_unlock(a, QLA4022_DRVR_SEM_MASK))
#define QLA4XXX_UNLOCK_GIO(a)   (qla4xxx_sem_unlock(a, QLA4022_PHY_GIO_SEM_MASK))
#define QLA4XXX_UNLOCK_DDR_RAM(a) (qla4xxx_sem_unlock(a, QLA4022_DDR_RAM_SEM_MASK))
#define QLA4XXX_UNLOCK_PHY(a)   (qla4xxx_sem_unlock(a, QLA4022_PHY_GIO_SEM_MASK))
#define QLA4XXX_UNLOCK_NVRAM(a) (qla4xxx_sem_unlock(a, QLA4022_NVRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_FLASH(a) (qla4xxx_sem_unlock(a, QLA4022_FLASH_SEM_MASK))


#endif /* QLA4022 */
#endif /* !QLA4010 */

void QLA4XXX_LOCK_DRVR_WAIT(scsi_qla_host_t *ha)
{
	int i = 0;
        while (1) {
		if (QLA4XXX_LOCK_DRVR(ha) == 0) {
			schedule_timeout(10); \
			if (!i) {
				QL4PRINT(QLP25, printk(KERN_INFO "scsi%d: %s Waiting for Global Init Semaphore...\n",ha->host_no,__func__));
				i++;
			}
		}
		else {
			QL4PRINT(QLP25, printk(KERN_INFO "scsi%d: %s: Global Init Semaphore acquired.\n",ha->host_no,__func__));
			break;
		}
        }
}

#endif /* !QLA4000 */


