/******************************************************************************
 *     Copyright (C)  2003 -2005 QLogic Corporation
 * QLogic ISP4xxx Device Driver
 *
 * This program includes a device driver for Linux 2.4.x that may be
 * distributed with QLogic hardware specific firmware binary file.
 * You may modify and redistribute the device driver code under the
 * GNU General Public License as published by the Free Software Foundation
 * (version 2 or a later version) and/or under the following terms,
 * as applicable:
 *
 * 	1. Redistribution of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above copyright
 *         notice, this list of conditions and the following disclaimer in
 *         the documentation and/or other materials provided with the
 *         distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 * 	
 * You may redistribute the hardware specific firmware binary file under
 * the following terms:
 * 	1. Redistribution of source code (only if applicable), must
 *         retain the above copyright notice, this list of conditions and
 *         the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above
 *         copyright notice, this list of conditions and the following
 *         disclaimer in the documentation and/or other materials provided
 *         with the distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 *
 * REGARDLESS OF WHAT LICENSING MECHANISM IS USED OR APPLICABLE,
 * THIS PROGRAM IS PROVIDED BY QLOGIC CORPORATION "AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * USER ACKNOWLEDGES AND AGREES THAT USE OF THIS PROGRAM WILL NOT CREATE
 * OR GIVE GROUNDS FOR A LICENSE BY IMPLICATION, ESTOPPEL, OR OTHERWISE
 * IN ANY INTELLECTUAL PROPERTY RIGHTS (PATENT, COPYRIGHT, TRADE SECRET,
 * MASK WORK, OR OTHER PROPRIETARY RIGHT) EMBODIED IN ANY OTHER QLOGIC
 * HARDWARE OR SOFTWARE EITHER SOLELY OR IN COMBINATION WITH THIS PROGRAM
 *
 ******************************************************************************/
#ifndef _QLA4022_H_
#define _QLA4022_H_

#include <linux/version.h>

/*
 * This file set some defines that are required to compile the
 * command source for 4000 module
 *----------------------------------------------------------------------------*/
#define QLA4022
//#define QLA4010
#define QLA4XXX_BOARD_ID		0x4022
#define QLA4XXX_BOARD_ID_STRING		"4022"
#define QLA4XXX_BOARD_NAME_STRING	"QLA4022"
#define QLA4XXX_BOARD_PORTS		1
#define QLA4XXX_PROC_NAME		"qla4022"

#define MEMORY_MAPPED_IO		1 /* 1=Memory Mapped (preferred),
					   * 0=I/O Mapped */

#define MEM_ALIGN_VALUE                 ((MAX(REQUEST_QUEUE_DEPTH,RESPONSE_QUEUE_DEPTH)) * sizeof(QUEUE_ENTRY))
#define REQ_Q_MEM_ALIGN_VALUE           (REQUEST_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))
#define RSP_Q_MEM_ALIGN_VALUE           (RESPONSE_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))

/*
 * Define Common Register Accesses
 *----------------------------------------------------------------------------*/
#define ISP_CLEAR_RSP_Q_INTR(ha) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_COMPLETION_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}
#define ISP_CLEAR_MBOX_INTR(ha,msts) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_PROCESSOR_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}

#define ISP_RD_RSP_Q_IN(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->responseQueueInPointer))
#define ISP_RD_REQ_Q_OUT(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->requestQueueOutPointer))

#define ISP_RD_INTR_MASK(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))
#define ISP_RD_INTR_STATUS(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))

#define ISP_ENABLE_INTRS(ha)  	{WRT_REG_DWORD(&ha->reg->InterruptMask, IMRW_SCSI_INTR_ENABLE); PCI_POSTING(&ha->reg->InterruptMask);}
#define ISP_DISABLE_INTRS(ha)	{WRT_REG_DWORD(&ha->reg->InterruptMask, IMRM_SCSI_INTR_ENABLE); PCI_POSTING(&ha->reg->InterruptMask);}

#define ISP_SEMAPHORE(ha)       (&ha->reg->Semaphore)
		




/*
 * Scsi_Host_template (see hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/

/*
 * max_sectors
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,8)
#define TEMPLATE_MAX_SECTORS	max_sectors: 128,  //max 64K xfers for now
#else
#define TEMPLATE_MAX_SECTORS
#endif

/*
 * name
 */
#define TEMPLATE_NAME		name: "QLogic iSCSI 4022",


/*
 * Include common source
 *----------------------------------------------------------------------------*/
#include "ql4drvr.c"

#if 0
#define SEM_FREE                                      0
#define SEM_ISCSI_DRIVER                              (pDevExt->pExt->lFunctionNumber)

#define NVRAMM_CLOCK                                  0x00010000
#define NVRAMM_CHIPSEL                                0x00020000
#define NVRAMM_DATAOUT                                0x00040000
#define NVRAMM_DATAIN                                 0x00080000

#define SEMM_DRIVER                                   0x000e0000
#define SEMM_DRAM                                     0x00700000
#define SEMM_GP                                       0x03800000
#define SEMM_PHYGBIC                                  0x03800000
#define SEMM_NVRAM                                    0x1c000000
#define SEMM_FLASH                                    0xe0000000

typedef union _SEM_REG
{
    struct
    {
        ULONG  bReserved                 :1;
        ULONG  bDriverSem                :3;
        ULONG  bSDRAMSem                 :3;
        ULONG  bGenPurposeOutSem         :3;
#define bPHYGBICSem                                   bGenPurposeOutSem
        ULONG  bNVRAMSem                 :3;
        ULONG  bFlashSem                 :3;
        ULONG  bMask                     :16;
    };
    ULONG   AsULONG;
} SEM_REG, *PSEM_REG;

#endif

#endif // _QLA4022_H_
