/******************************************************************************
 *     Copyright (C)  2003 -2005 QLogic Corporation
 * QLogic ISP4xxx Device Driver
 *
 * This program includes a device driver for Linux 2.4.x that may be
 * distributed with QLogic hardware specific firmware binary file.
 * You may modify and redistribute the device driver code under the
 * GNU General Public License as published by the Free Software Foundation
 * (version 2 or a later version) and/or under the following terms,
 * as applicable:
 *
 * 	1. Redistribution of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above copyright
 *         notice, this list of conditions and the following disclaimer in
 *         the documentation and/or other materials provided with the
 *         distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 * 	
 * You may redistribute the hardware specific firmware binary file under
 * the following terms:
 * 	1. Redistribution of source code (only if applicable), must
 *         retain the above copyright notice, this list of conditions and
 *         the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above
 *         copyright notice, this list of conditions and the following
 *         disclaimer in the documentation and/or other materials provided
 *         with the distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 *
 * REGARDLESS OF WHAT LICENSING MECHANISM IS USED OR APPLICABLE,
 * THIS PROGRAM IS PROVIDED BY QLOGIC CORPORATION "AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * USER ACKNOWLEDGES AND AGREES THAT USE OF THIS PROGRAM WILL NOT CREATE
 * OR GIVE GROUNDS FOR A LICENSE BY IMPLICATION, ESTOPPEL, OR OTHERWISE
 * IN ANY INTELLECTUAL PROPERTY RIGHTS (PATENT, COPYRIGHT, TRADE SECRET,
 * MASK WORK, OR OTHER PROPRIETARY RIGHT) EMBODIED IN ANY OTHER QLOGIC
 * HARDWARE OR SOFTWARE EITHER SOLELY OR IN COMBINATION WITH THIS PROGRAM
 *
 ******************************************************************************/

#ifndef _QLA4XXX_H           /* wrapper symbol for kernel use */
#define _QLA4XXX_H           /* subject to change without notice */

#if defined(__cplusplus)
extern "C" {
#endif

#define QLA4XXX_DRIVER_VERSION      "3.24"

/* XXX(dg): move to pci_ids.h */
#ifndef PCI_DEVICE_ID_QLOGIC_ISP4000
#define PCI_DEVICE_ID_QLOGIC_ISP4000	0x4000
#endif

#ifndef PCI_DEVICE_ID_QLOGIC_ISP4010
#define PCI_DEVICE_ID_QLOGIC_ISP4010	0x4010
#endif

#ifndef PCI_DEVICE_ID_QLOGIC_ISP4022
#define PCI_DEVICE_ID_QLOGIC_ISP4022	0x4022
#endif

#define IS_QLA4000(ha) (ha->pdev->device == PCI_DEVICE_ID_QLOGIC_ISP4000)
#define IS_QLA4010(ha) (ha->pdev->device == PCI_DEVICE_ID_QLOGIC_ISP4010)
#define IS_QLA4022(ha) (ha->pdev->device == PCI_DEVICE_ID_QLOGIC_ISP4022)

#if defined(CONFIG_PPC64) || defined(CONFIG_X86_64)
#define QLA_CONFIG_COMPAT
#endif

/*---------------------------------------------------------------------------*/
/*
 * Data bit definitions
 */
#define BIT_0	0x1
#define BIT_1	0x2
#define BIT_2	0x4
#define BIT_3	0x8
#define BIT_4	0x10
#define BIT_5	0x20
#define BIT_6	0x40
#define BIT_7	0x80
#define BIT_8	0x100
#define BIT_9	0x200
#define BIT_10	0x400
#define BIT_11	0x800
#define BIT_12	0x1000
#define BIT_13	0x2000
#define BIT_14	0x4000
#define BIT_15	0x8000
#define BIT_16	0x10000
#define BIT_17	0x20000
#define BIT_18	0x40000
#define BIT_19	0x80000
#define BIT_20	0x100000
#define BIT_21	0x200000
#define BIT_22	0x400000
#define BIT_23	0x800000
#define BIT_24	0x1000000
#define BIT_25	0x2000000
#define BIT_26	0x4000000
#define BIT_27	0x8000000
#define BIT_28	0x10000000
#define BIT_29	0x20000000
#define BIT_30	0x40000000
#define BIT_31	0x80000000

/*
 * Compile time Options:
 *            0 - Disable and 1 - Enable
 ****************************************/

#define STOP_ON_ERROR           STOP_ON_ABORT|STOP_ON_RESET_DEVICE|STOP_ON_RESET_BUS|STOP_ON_RESET_FIRMWARE|STOP_ON_RESET_ADAPTER|STOP_ON_FALTAL_ERROR|STOP_ON_LOST_AEN

#define STOP_ON_ABORT           0  /* Panic on abort */
#define STOP_ON_RESET_DEVICE    0  /* Panic on device reset */
#define STOP_ON_RESET_BUS       0  /* Panic on Bus reset */
#define STOP_ON_RESET_FIRMWARE  0  /* Panic on Reset firmware for a particular host adapter */
#define STOP_ON_RESET_ADAPTER   0  /* Panic on Hard reset of host adapter, write to bridge's
				    * PCI config space */
#define STOP_ON_FALTAL_ERROR    0  /* Panic on fatal error */
#define STOP_ON_LOST_AEN    	0  /* Panic on lost aen */

/*
 * The following compile time options are temporary,
 * used for debug purposes only.
 ****************************************/
#define ISP_RESET_TEST		0 /* Issues BIG HAMMER (reset) every 3 minutes */
#define TRACK_SPURIOUS_INTRS	1 /* Display spurious intr count in proc and timer displays */
#define QLA4040_SUPPORT_ENABLED 0
#define BYTE_ORDER_SUPPORT_ENABLED 0

/*
 * Under heavy I/O on SMP systems (8-way and IA64) with many command
 * timeouts, the scsi mid-layer will sometimes not wake-up the
 * error-handling thread when an error-condition occurs.
 *
 * This workaround, if enabled, will wakeup the error-handler if it is
 * stuck in this condition for sixty seconds.
 ****************************************/
#define EH_WAKEUP_WORKAROUND		0
#if SH_HAS_ATOMIC_HOST_BUSY  /* defined in makefile */
#define HOST_BUSY(ha)	atomic_read(&ha->host->host_busy)
#else
#define HOST_BUSY(ha)	ha->host->host_busy
#endif

/*---------------------------------------------------------------------------*/

#ifndef KERNEL_VERSION
#  define KERNEL_VERSION(x,y,z) (((x)<<16)+((y)<<8)+(z))
#endif

#if LINUX_VERSION_CODE < KERNEL_VERSION(2,4,0)
#	error "This code supports kernel versions 2.4.0 and above"
#endif

/*---------------------------------------------------------------------------*/

#define MIN(x,y)		((x)<(y)?(x):(y))
#define MAX(x,y)		((x)>(y)?(x):(y))
#define SYS_DELAY(x)		do {udelay(x);barrier();} while(0);
#define QLA4XXX_DELAY(sec)  	do {mdelay(sec * 1000);} while(0);
#define NVRAM_DELAY() 		do {udelay(500);} while(0); /* 500 microsecond delay */

/* delay 30 seconds */
#define RESET_DELAY()		do {int delay; for(delay=30; delay!=0; delay--) \
				{current->state = TASK_UNINTERRUPTIBLE; \
				schedule_timeout(1 * HZ);}} while(0);
				
#if QLA4040_SUPPORT_ENABLED
#define TOPCAT_RESET_DELAY()	do {udelay(1);} while(0);
#define TOPCAT_POST_RESET_DELAY() do {udelay(523);} while(0);
#endif

#define LSB(x)	((uint8_t)(x))
#define MSB(x)	((uint8_t)((uint16_t)(x) >> 8))
#define LSW(x)	((uint16_t)(x))
#define MSW(x)	((uint16_t)((uint32_t)(x) >> 16))
#define LSDW(x)	((uint32_t)((unsigned long)(x)))
#define MSDW(x)	((uint32_t)((((unsigned long)(x)) >> 16) >> 16))

#define _64BIT_TO_ULONG(x) LSDW(x)
#define _32BIT_TO_ULONG(x) (x)


#define IPAddrIsZero( _X1_ )   ((_X1_)[0] == 0 && \
                                (_X1_)[1] == 0 && \
                                (_X1_)[2] == 0 && \
                                (_X1_)[3] == 0)

#define IPAddrIsEqual(_X1_, _X2_) ((_X1_)[0] == (_X2_)[0] && \
                                   (_X1_)[1] == (_X2_)[1] && \
                                   (_X1_)[2] == (_X2_)[2] && \
                                   (_X1_)[3] == (_X2_)[3])
				
#define IPAddr2Uint32(_X1_,_X2_) { \
                                  *_X2_ = 0; \
				  *_X2_ |= _X1_[3] << 24; \
				  *_X2_ |= _X1_[2] << 16; \
				  *_X2_ |= _X1_[1] << 8;  \
				  *_X2_ |= _X1_[0];}

/*
 * I/O port access macros
 *************************/
#if MEMORY_MAPPED_IO
#   define RD_REG_BYTE(addr)	     readb(addr)
#   define RD_REG_WORD(addr)         readw(addr)
#   define RD_REG_DWORD(addr)        readl(addr)
#   define WRT_REG_BYTE(addr, data)  writeb(data, addr)
#   define WRT_REG_WORD(addr, data)  writew((data), addr)
#   define WRT_REG_DWORD(addr, data) writel((data), addr)
#else
#   define RD_REG_BYTE(addr)	     (inb((unsigned long)addr))
#   define RD_REG_WORD(addr)         (inw((unsigned long)addr))
#   define RD_REG_DWORD(addr)        (inl((unsigned long)addr))
#   define WRT_REG_BYTE(addr, data)  (outb(data,(unsigned long)addr))
#   define WRT_REG_WORD(addr, data)  (outw(data,(unsigned long)addr))
#   define WRT_REG_DWORD(addr, data) (outl(data,(unsigned long)addr))
#endif

#define RD_DMA_DWORD(ha, addr)    (*addr)
#define PCI_POSTING(a) (RD_REG_DWORD(a))

/*---------------------------------------------------------------------------*/

#define STATIC static


#if !defined(SH_HAS_HOST_LOCK)
#define HOST_SPIN_LOCK(ha)			spin_lock(&io_request_lock)
#define HOST_SPIN_UNLOCK(ha)			spin_unlock(&io_request_lock)
#define HOST_SPIN_LOCK_IRQ(ha)			spin_lock_irq(&io_request_lock)
#define HOST_SPIN_UNLOCK_IRQ(ha)		spin_unlock_irq(&io_request_lock)
#define HOST_SPIN_LOCK_IRQSAVE(ha, flags)	spin_lock_irqsave(&io_request_lock, flags)
#define HOST_SPIN_UNLOCK_IRQRESTORE(ha, flags)	spin_unlock_irqrestore(&io_request_lock, flags)
#else
#define HOST_SPIN_LOCK(ha)			spin_lock(ha->host->host_lock)
#define HOST_SPIN_UNLOCK(ha)			spin_unlock(ha->host->host_lock)
#define HOST_SPIN_LOCK_IRQ(ha)			spin_lock_irq(ha->host->host_lock)
#define HOST_SPIN_UNLOCK_IRQ(ha)		spin_unlock_irq(ha->host->host_lock)
#define HOST_SPIN_LOCK_IRQSAVE(ha, flags)	spin_lock_irqsave(ha->host->host_lock, flags)
#define HOST_SPIN_UNLOCK_IRQRESTORE(ha, flags)	spin_unlock_irqrestore(ha->host->host_lock, flags)
#endif

/*
 * Return status codes for internal routines
 ********************************************/
#define QLA_SUCCESS			0
#define QLA_ERROR			1

/*
 * Buffer sizes
 ***************/
#define REQUEST_QUEUE_DEPTH       	256
#define RESPONSE_QUEUE_DEPTH      	64
#define QUEUE_SIZE			64
#define DMA_BUFFER_SIZE 		512


/*
 * Host adapter default definitions
 ***********************************/
#define MAX_HBAS			16
#define MAX_BUSES       		1
#define MAX_TARGETS     		MAX_PRST_DEV_DB_ENTRIES + MAX_DEV_DB_ENTRIES
#define MAX_LUNS        		256
#define MAX_AEN_ENTRIES 		256 /* should be > EXT_DEF_MAX_AEN_QUEUE */
#define MAX_DDB_ENTRIES 		MAX_PRST_DEV_DB_ENTRIES + MAX_DEV_DB_ENTRIES
#define MAX_PDU_ENTRIES                 32
#define INVALID_ENTRY			0xFFFF
#define MAX_SRBS			MIN(REQUEST_QUEUE_DEPTH, MAX_CMDS_TO_RISC)
#define MBOX_AEN_REG_COUNT		4
#define MAX_INIT_RETRIES		5

/*
 * Retry & Timeout Values
 *************************/
#define MBOX_TOV			60
#define SOFT_RESET_TOV			30
#define RESET_INTR_TOV			3
#define SEMAPHORE_TOV			10
#define ADAPTER_INIT_TOV		120
#define ADAPTER_RESET_TOV		180
#define EXTEND_CMD_TOV			60
#define WAIT_CMD_TOV			30
#define EH_WAIT_CMD_TOV			120
#define FIRMWARE_UP_TOV			60
#define RESET_FIRMWARE_TOV        	30
#define LOGOUT_TOV			10
#define IOCB_TOV_MARGIN			10
#define RELOGIN_TOV			18
#define ISNS_DEREG_TOV			5

#define MAX_RESET_HA_RETRIES		2

/*
 * Misc
 *******/
#define MAC_ADDR_LEN			6 /* in bytes */
#define IP_ADDR_LEN			4 /* in bytes */
#define DRIVER_NAME			QLA4XXX_PROC_NAME

#define MAX_LINKED_CMDS_PER_LUN		3
#define MAX_REQS_SERVICED_PER_INTR	16

/* Number of seconds to subtract for internal command timer */
#define QLA_CMD_TIMER_DELTA             5

/*---------------------------------------------------------------------------*/

/*
 * SCSI definitions not defined in Linux's scsi.h
 */

/* The SCSISTAT values are defined in scsi.h,
 * but the values are shifted by one bit.
 * We re-define them here without bit shifting
 * to minimize confusion */
#define SCSISTAT_GOOD			0x00
#define SCSISTAT_CHECK_CONDITION	0x02
#define SCSISTAT_CONDITION_GOOD		0x04
#define SCSISTAT_BUSY			0x08
#define SCSISTAT_INTERMEDIATE_GOOD  	0x10
#define SCSISTAT_INTERMEDIATE_C_GOOD  	0x14
#define SCSISTAT_RESERVATION_CONFLICT 	0x18
#define SCSISTAT_COMMAND_TERMINATED   	0x22
#define SCSISTAT_QUEUE_FULL           	0x28

#define SENSE_KEY(sense_data) 	(sense_data[2] & 0x0f)
#define ASC(sense_data) 	sense_data[12]
#define ASCQ(sense_data) 	sense_data[13]

#ifndef REPORT_LUNS
#define REPORT_LUNS			0xA0
#endif

/* SAM-II compliant lun structure */
typedef struct
{
	uint8_t bus_identifier:6;
	uint8_t address_method:2;

	uint8_t single_level_lun;
	uint16_t second_level_lun;
	uint16_t third_level_lun;
	uint16_t fourth_level_lun;
} single_level_lun_t;

typedef struct
{
	uint32_t lun_list_length;
	uint8_t reserved[4];
	single_level_lun_t lun[MAX_LUNS];
} report_luns_t;

typedef struct
{
	uint8_t device_type;
	uint8_t device_type_qualifier;
	uint8_t version;
	uint8_t response_data_format;
	uint8_t addional_length;
	uint8_t reserved1;
	uint8_t support1;
	uint8_t support2;
	uint8_t vendor_id[8];
	uint8_t product_id[16];
	uint8_t revision[4];
} inquiry_t;

/*---------------------------------------------------------------------------*/

/*
 * LUN structure
 */
typedef struct
{
	uint8_t lun_state;		/* 00 x00 */
	#define LS_LUN_READY		0   /* LUN is ready to accept commands */
	#define LS_LUN_SUSPENDED	1   /* LUN is suspended until  */
	#define LS_LUN_RETRY		2
	#define LS_LUN_TIMEOUT		3
	#define LUN_STATE_TBL()		  \
	{				  \
		"READY"			, \
		"SUSPENDED"		, \
		"RETRY"			, \
		"TIMEOUT"		, \
		NULL			  \
	}

	uint8_t out_count;		/* 01 x01 */
	uint8_t lun;			/* 02 x02 */

	uint8_t retry_count;		/* 03 x03 */
	uint8_t max_retry_count;	/* 04 x04 */
	uint8_t max_recovery_retries;	/* 05 x05 */
	uint8_t inq_dev_type;		/* 06 x06 */
	uint8_t reserved[1];		/* 07 x07 */
	uint32_t tot_io_count;		/* 08 x08 */
	atomic_t suspend_timer;		/* 12 x0c */
	struct list_head list_entry;	/* 16 x10 For suspended lun list */
	spinlock_t lun_lock;		/* 24 x18 For suspended lun list */
} lun_entry_t;

/* Never set this to Zero */
#define SUSPEND_SECONDS	6		
#define SUSPEND_RETRIES	1

/*---------------------------------------------------------------------------*/

/*
 * Device Database (DDB) structure
 */

typedef struct
{
	struct list_head   list_entry;	/* 00 x00 */
	uint16_t bus;			/* 08 x08 */
	uint16_t target;		/* 10 x0a */
	uint16_t fw_ddb_index;		/* 12 x0c */
	uint16_t out_count;		/* 14 x0e */

	uint8_t  num_valid_luns;	/* 16 x10 */
	uint8_t  reserved[3];           /* 17 x11 */

	/* refer to MBOX_CMD_GET_DATABASE_ENTRY for fw_ddb_fw_ddb_device_state definitions   */
	uint32_t fw_ddb_device_state;	/* 20 x14 */
	uint32_t CmdSn;			/* 24 x18 */
	uint16_t target_session_id;	/* 28 x1c */
	uint16_t connection_id;		/* 30 x1e */
	uint16_t exe_throttle;		/* 32 x20 */
	uint16_t task_mgmt_timeout;	/* 34 x22 */
	uint16_t default_relogin_timeout;/*36 x24 Max time to wait for relogin to complete */
	uint16_t tcp_source_port_num;   /* 38 x26 */
	uint32_t default_time2wait;	/* 40 x28 Default Min time between relogins (+aens) */
	atomic_t port_down_timer;	/* 44 x2c Device down time */
	atomic_t retry_relogin_timer;	/* 48 x30 Min Time between relogins (4000 only)*/
	atomic_t relogin_timer;		/* 52 x34 Max Time to wait for relogin to complete */
	atomic_t relogin_retry_count;	/* 56 x38 Max times to retry relogin */
	atomic_t state;			/* 60 x3c */
#ifdef __VMKERNEL_MODULE__
	#define DEV_STATE_INVALID	0 /* We can no longer talk to this device */
	#define DEV_STATE_DEAD		1 /* We can no longer talk to this device */
	#define DEV_STATE_ONLINE	2 /* Device ready to accept commands */
	#define DEV_STATE_MISSING	3 /* Device logged off, trying to re-login */
	#define DEV_STATE_TBL()		  \
	{				  \
		"INVALID"			, \
		"DEAD"			, \
		"ONLINE"		, \
		"MISSING"		, \
		NULL			  \
	}
#else
	#define DEV_STATE_DEAD		0 /* We can no longer talk to this device */
	#define DEV_STATE_ONLINE	1 /* Device ready to accept commands */
	#define DEV_STATE_MISSING	2 /* Device logged off, trying to re-login */
	#define DEV_STATE_TBL()		  \
	{				  \
		"DEAD"			, \
		"ONLINE"		, \
		"MISSING"		, \
		NULL			  \
	}
#endif
	unsigned long flags;			/* 64 x40 */
	#define DF_RELOGIN		0	
	#define DF_NO_RELOGIN		1  /* Do not relogin if IOCTL logged it out */
	#define DF_ISNS_DISCOVERED	2

	unsigned long dev_scan_wait_to_start_relogin;
	unsigned long dev_scan_wait_to_complete_relogin;

	uint8_t	 ip_addr[4];		 /* 68 x44 */
	uint8_t	 iscsi_name[0x100];	 /* 72 x48 */
	lun_entry_t *lun_table[MAX_LUNS];/*328 x148 */
#if 1 || defined(__VMKERNEL_MODULE__)
        uint8_t relogin_done;
	uint8_t discover_done;           /* 842 x34A ignore figure below */
#endif
} ddb_entry_t;				 /*840 x348 */

/*---------------------------------------------------------------------------*/

/*
 * Asynchronous Event Queue structure
 */
typedef struct
{
	uint32_t mbox_sts[MBOX_AEN_REG_COUNT];
}aen_t;

/* We use the Scsi_Pointer structure that's included with each command
 * SCSI_Cmnd as a scratchpad for our SRB.
 *
 * SCp will always point to the SRB structure (defined in qla4xxx.h).
 * It is defined as follows: (see srb_t definition)
 *  - SCp.ptr  -- > pointer back to the cmd
 *  - SCp.this_residual --> used as forward pointer to next srb
 *  - SCp.buffer --> used as backward pointer to next srb
 *  - SCp.buffers_residual --> used as flags field
 *  - SCp.have_data_in --> not used
 *  - SCp.sent_command --> not used
 *  - SCp.phase --> not used
 */

//#define CMD_SP(Cmnd)	(&(Cmnd)->SCp)

#define CMD_SP(Cmnd)	    ((Cmnd)->SCp.ptr)

/* Additional fields used by ioctl passthru */
#define CMD_PASSTHRU_TYPE(Cmnd) ((unsigned long) (Cmnd)->SCp.buffer)
#define CMD_COMPL_STATUS(Cmnd)  ((Cmnd)->SCp.this_residual)
#define CMD_RESID_LEN(Cmnd)     ((Cmnd)->SCp.buffers_residual)
#define CMD_SCSI_STATUS(Cmnd)   ((Cmnd)->SCp.Status)
#define CMD_ACTUAL_SNSLEN(Cmnd) ((Cmnd)->SCp.have_data_in)
#define CMD_HOST_STATUS(Cmnd)   ((Cmnd)->SCp.Message)
#define CMD_ISCSI_RESPONSE(Cmnd)((Cmnd)->SCp.sent_command)
#define CMD_ISCSI_FLAGS(Cmnd)   ((Cmnd)->SCp.phase)

#define CMD_XFRLEN(Cmnd)	(Cmnd)->request_bufflen
#define CMD_CDBLEN(Cmnd)	(Cmnd)->cmd_len
#define CMD_CDBP(Cmnd)		(Cmnd)->cmnd
#define CMD_SNSP(Cmnd)		(Cmnd)->sense_buffer
#define CMD_SNSLEN(Cmnd)	(sizeof (Cmnd)->sense_buffer)
#define CMD_RESULT(Cmnd)	((Cmnd)->result)
#define CMD_HANDLE(Cmnd)	((Cmnd)->host_scribble)
#define CMD_TIMEOUT(Cmnd) 	((Cmnd)->timeout_per_command)

#define SCSI_BUS_32(scp)	((scp)->channel)
#define SCSI_TCN_32(scp)	((scp)->target)
#define SCSI_LUN_32(scp)	((scp)->lun)

/*
 * SCSI Request Block structure  (sp)  that is placed
 * on cmd->SCp location of every I/O     [We have 22 bytes available]
 */
typedef struct _srb_t
{
	struct list_head   list_entry;	/* 0x00 - 0x07   */
	uint16_t     flags;		/* 0x08 - 0x09 Status flags. */
	#define SRB_TIMEOUT          0x0001   /* Command timed out */
	#define SRB_ABORT_PENDING    0x0002   /* Command abort sent to device */
	#define SRB_ABORTED          0x0004   /* Command aborted command already */
	#define SRB_DMA_VALID        0x0008   /* The DMA Buffer has been mapped */
	#define SRB_GOT_SENSE        0x0010   /* Sense data was recieved */
	#define SRB_IOCTL_CMD	     0x0020   /* Command generated from an IOCTL */
	#define SRB_INTERNAL_CMD     0x0040   /* Command generated from driver internal */
	#define SRB_KERNEL_CMD	     0x0080   /* Command generated from kernel */
	#define SRB_TAPE	     0x0100   /* FCP2 (Tape) command. */

	uint8_t     state;		/* 0x0A - 0x0A Status flags. */
	#define SRB_NO_QUEUE_STATE	 0
	#define SRB_FREE_STATE		 1
	#define SRB_PENDING_STATE	 2
	#define SRB_ACTIVE_STATE	 3
	#define SRB_ACTIVE_TIMEOUT_STATE 4
	#define SRB_RETRY_STATE	 	 5
	#define SRB_DONE_STATE	 	 6
	#define SRB_STATE_TBL()	  	  \
	{	    			  \
            "NO_QUEUE"	        	, \
            "FREE"		        , \
            "PENDING"	        	, \
	    "ACTIVE"	        	, \
	    "ACTIVE_TIMEOUT"        	, \
	    "RETRY"	        	, \
	    "DONE"	        	, \
	    NULL			  \
	}

	uint8_t     entry_count;	/* 0x0B - 0x0B number of request queue
					 *     entries used */
	uint16_t    reserved2;          /* 0x0C - 0x0D */
	uint16_t    active_array_index; /* 0x0E - 0x0F */

	Scsi_Cmnd  *cmd;		/* 0x10 - 0x13 SCSI command block */
	dma_addr_t  saved_dma_handle;	/* 0x14 - 0x17 for unmap of single transfers */
	atomic_t    ref_count; 		/* 0x18 - 0x1B reference count for this srb */
	uint32_t    fw_ddb_index;       /* 0x1C - 0x1F */
	uint32_t    lun;                /* 0x20 - 0x23 */
	struct      timer_list   timer;	/* 0x24 - 0x43 used to timeout command */
	uint16_t    os_tov;             /* 0x44 - 0x45 */
	uint16_t    iocb_tov;           /* 0x46 - 0x47 */
	uint16_t    iocb_cnt;           /* 0x48 - 0x49 */
	uint16_t    cc_stat;            /* 0x4A - 0x4B */
	u_long      r_start;  		/* 0x4C - 0x4F Time we recieve a cmd from OS*/
	u_long      u_start;  		/* 0x50 - 0x53 Time when we handed the cmd to F/W */
} srb_t;


/*
 * DMA buffer structure
 */
typedef struct
{
	void      *virt_addr;
	dma_addr_t phys_addr;
	uint32_t   buf_len;
} dma_buf_t;

typedef struct
{
	QUEUE_ENTRY             request_queue[REQUEST_QUEUE_DEPTH];	//0x40*0x100=0x4000
	QUEUE_ENTRY             response_queue[RESPONSE_QUEUE_DEPTH];	//0x40*0x40=0x1000
#ifndef QLA4000
	DMA_ISP_REGS            dma_registers;				//0x80
	uint8_t			pdu_buffs[MAX_PDU_ENTRIES][PAGE_SIZE];  //0x20*0x400=0x8000
	ISNS_DISCOVERED_TARGET  isns_discovered_target_database[MAX_ISNS_DISCOVERED_TARGETS]; // x148*x200=x29000
#endif
} dma_mem_blk_t;

/*
 * NOTE: This structure definition really belongs in the ql4isns.h file,
 *       but it's easier to compile when the structure is defined here.
 */
typedef struct _ATTRIBUTE_LIST {
    uint32_t isns_tag;
#define ISNS_ATTR_TYPE_EMPTY      1   // Used for delimiter attr. & operating attr. for query.
#define ISNS_ATTR_TYPE_STRING     2   // UTF-8 encoded string
#define ISNS_ATTR_TYPE_ULONG      3
#define ISNS_ATTR_TYPE_ADDRESS    4   // 128-bit IPv6
    uint32_t type;
    unsigned long data;
} ATTRIBUTE_LIST;


#ifdef __VMKERNEL_MODULE__
/* A table to keep static mappings between iSCSI target names
 * and target ID's across resets (PR 106012)
 */
#define ISCSI_MAX_NAME_LEN 0x100
typedef struct {
   uint8_t iscsi_name[ISCSI_MAX_NAME_LEN + 1];
   uint32_t last_use;
} iscsi_target_mapping_t;
#endif

/*
 * Linux Host Adapter structure
 */
typedef struct scsi_qla_host
{
	/* Linux adapter configuration data */
	struct Scsi_Host *host;	    /* pointer to host data */
	struct scsi_qla_host *next;

	uint32_t	tot_ddbs;

	unsigned long	flags;
	#define AF_ONLINE		0  /* 0x0001 */
	#define AF_INIT_DONE		1  /* 0x0002 */
	#define AF_MBOX_COMMAND 	2  /* 0x0004 */
	#define AF_MBOX_COMMAND_DONE 	3  /* 0x0008 */
	#define AF_DPC_SCHEDULED	5  /* 0x0020 */
	#define AF_INTERRUPTS_ON	6  /* 0x0040 Not Used */
	#define AF_GET_CRASH_RECORD	7  /* 0x0080 */
	#define AF_LINK_UP		8  /* 0x0100 */
	#define AF_TOPCAT_CHIP_PRESENT	9  /* 0x0200 */
	#define AF_IRQ_ATTACHED	      	10 /* 0x00000400 */

	unsigned long	dpc_flags;
	#define DPC_RESET_HA			1  /* 0x00000002 */
	#define DPC_RETRY_RESET_HA		2  /* 0x00000004 */
	#define DPC_RELOGIN_DEVICE		3  /* 0x00000008 */
	#define DPC_RESET_HA_DESTROY_DDB_LIST 	4  /* 0x00000010 */
	#define DPC_RESET_HA_INTR		5  /* 0x00000020 */
	#define DPC_IOCTL_ERROR_RECOVERY 	6  /* 0x00000040 */
	#define DPC_ISNS_RESTART		7  /* 0x00000080 */
	#define DPC_ISNS_RESTART_COMPLETION	8  /* 0x00000100 */
	#define DPC_AEN			      	9  /* 0x00000200 */
	#define DPC_WAIT_TO_RELOGIN_DEVICE   	13 /* 0x00002000 */
	#define DPC_GET_DHCP_IP_ADDR	     	15 /* 0x00008000 */

	uint16_t    iocb_cnt;
	uint16_t    iocb_hiwat;

	u_long          i_start;	/* jiffies at start of IOCTL */
	u_long          i_end;		/* jiffies at end of IOCTL */
	u_long          f_start;	/* jiffies at sending cmd to f/w */
	u_long          f_end;		/* jiffies at receiving cmd from f/w */

	/* pci information */
	struct pci_dev  *pdev;
	struct pci_dev *pci_brgdev; /* Pointer to Intel PCI Brigde on QLA4000*/

	uint8_t		marker_needed;
	uint8_t		rsvd1;

	/* adapter instance w.r.t. all scsi hosts in OS */
	uint16_t        host_no;

	/* adapter instance w.r.t. this driver */
	uint16_t        instance;

	void            *virt_mmapbase;
	uint32_t	function_number;

	/* ISP registers, Base Memory-mapped I/O address */
	ISP_REG_T       *reg;

	/* NVRAM registers */
	EEPROM_DATA     *nvram;

	/* Counters for general statistics */
	uint64_t        adapter_error_count;
	uint64_t        device_error_count;
	uint64_t        total_io_count;
	uint64_t        total_mbytes_xferred;
	uint64_t        isr_count;	    /* Interrupt count */
	uint64_t        link_failure_count;
	uint64_t        invalid_crc_count;

	uint32_t        spurious_int_count;
	uint32_t        aborted_io_count;
	uint32_t        io_timeout_count;
	uint32_t        mailbox_timeout_count;
	uint32_t        seconds_since_last_intr;
	uint32_t        seconds_since_last_heartbeat;
	uint32_t        mac_index;

	/* Info Needed for Management App */
	/* --- From GetFwVersion --- */
	uint32_t        firmware_version[2];
	uint32_t        patch_number;
	uint32_t        build_number;
	/* --- From Init_FW --- */
	uint16_t        firmware_options;
	uint16_t        tcp_options;
	uint8_t         ip_address[IP_ADDR_LEN];
	uint8_t         subnet_mask[IP_ADDR_LEN];
	uint8_t         gateway[IP_ADDR_LEN];
	uint8_t         isns_ip_address[IP_ADDR_LEN];
	uint16_t	isns_server_port_number;
	uint8_t		alias[32];
	uint8_t		name_string[256];
	uint8_t		heartbeat_interval;
	uint8_t		rsvd2;
	/* --- From FlashSysInfo --- */
	uint8_t         my_mac[MAC_ADDR_LEN];
	uint8_t 	serial_number[16];
	/* --- From GetFwState --- */
	uint32_t        firmware_state;
	uint32_t        board_id;
	uint32_t        addl_fw_state;

	/* iSNS information */
	unsigned long       	isns_flags;
	#define ISNS_FLAG_ISNS_ENABLED_IN_ISP   0  /* 0x00000001 */
	#define ISNS_FLAG_ISNS_SRV_ENABLED   	1  /* 0x00000002 */
	#define ISNS_FLAG_ISNS_SRV_REGISTERED   2  /* 0x00000004 */
	#define ISNS_FLAG_ISNS_SCN_REGISTERED   4  /* 0x00000010 */
	#define ISNS_FLAG_QUERY_SINGLE_OBJECT   5  /* 0x00000020 */
	#define ISNS_FLAG_SCN_IN_PROGRESS       6  /* 0x00000040 */
	#define ISNS_FLAG_SCN_RESTART           7  /* 0x00000080 */
	#define ISNS_FLAG_DEV_SCAN_DONE         27 /* 0x08000000 */
	#define ISNS_FLAG_REREGISTER            28 /* 0x10000000 */
	#define ISNS_FLAG_RESTART_SERVICE       31 /* 0x80000000 */
		
	uint16_t isns_connection_id;
	uint16_t isns_scn_conn_id;
	uint16_t isns_esi_conn_id;
	uint16_t isns_nsh_conn_id;
	uint16_t isns_remote_port_num;
	uint16_t isns_scn_port_num;
	uint16_t isns_esi_port_num;
	uint16_t isns_nsh_port_num;
	uint8_t  isns_entity_id[256];

	atomic_t isns_restart_timer;
	uint16_t isns_transaction_id;
	uint16_t isns_num_discovered_targets;

	ATTRIBUTE_LIST isns_reg_attr_list[13];
	ATTRIBUTE_LIST isns_dereg_attr_list[7];
	ATTRIBUTE_LIST isns_scn_reg_attr_list[5];
	ATTRIBUTE_LIST isns_scn_dereg_attr_list[3];
	ATTRIBUTE_LIST isns_dev_get_next_attr_list[5];
	ATTRIBUTE_LIST isns_dev_attr_qry_attr_list[13];

	/* SCSI Passthru cmd/completion */
	struct semaphore ioctl_cmpl_sem;
	struct timer_list ioctl_cmpl_timer;
	uint32_t        ioctl_tov;
	Scsi_Cmnd 	*ioctl_err_cmd;
	uint8_t         ioctl_scsi_pass_in_progress;
	uint8_t         ioctl_iocb_pass_in_progress;
	uint8_t		*ioctl_scrap_mem;
	uint32_t	ioctl_scrap_mem_size;
	uint32_t	ioctl_scrap_mem_used;

	/* Linux kernel thread */
	uint8_t         dpc_active;	 /* DPC routine is active */
	struct task_struct *dpc_handler; /* kernel thread */
	struct semaphore *dpc_wait;	 /* DPC waits on this semaphore */
	struct semaphore *dpc_notify;	 /* requester waits for DPC on this
					  * semaphore */

	/* Linux timer thread */
	struct timer_list timer;

	/* Recovery Timers */
	uint32_t        port_down_retry_count;
	uint32_t        discovery_wait;
	atomic_t        check_relogin_timeouts;
	uint32_t        retry_reset_ha_cnt;

#if ISP_RESET_TEST
	uint32_t        isp_reset_timer;
#endif

#if EH_WAKEUP_WORKAROUND
	int             eh_start;	/* To wake up the mid layer error
					 * handler thread */
#endif

	/* This spinlock must be held with irqs disabled in order to access
	 * the pending, retry and free srb queues.
	 *
	 * The list_lock spinlock is of lower priority than the io_request
	 * lock.
	 *-------------------------------------------------------------------*/
	spinlock_t      list_lock;

	/* internal srb queues */
	struct          list_head pending_srb_q;
	struct          list_head retry_srb_q;
	struct          list_head free_srb_q;
	uint16_t        pending_srb_q_count;
	uint16_t        retry_srb_q_count;
	uint16_t        free_srb_q_count;
	uint16_t        num_srbs_allocated;

	/* This spinlock must be held with irqs disabled in order to access
	 * the done srb queue and suspended_lun	queue.
	 *
	 * The adapter_lock spinlock is of lower priority than the
	 * io_request lock.
	 *------------------------------------------------------------------*/
	spinlock_t      adapter_lock;

	/* Done queue
	 * In order to avoid deadlocks with the list_lock,
	 * place all srbs to be returned to OS on this list.
	 * After the list_lock is released, return all of
	 * these commands to the OS */

	struct list_head done_srb_q;
	uint16_t  	done_srb_q_count;

	/* Suspended LUN queue (uses adapter_lock) */
	struct list_head suspended_lun_q;
	uint32_t        suspended_lun_q_count;


	/* This spinlock is used to protect "io transactions", you must	
	 * aquire it before doing any IO to the card, eg with RD_REG*() and
	 * WRT_REG*() for the duration of your entire command transaction.
	 * It is also used to protect the active_srb_array.
	 *
	 * The hardware_lock spinlock is of lower priority than the
	 * io request lock.
	 *-------------------------------------------------------------------*/
	spinlock_t      hardware_lock;

	/* Active array */
	srb_t           *active_srb_array[MAX_SRBS];
	uint16_t        active_srb_count;
	uint16_t        current_active_index;

	/* request and response queue variables */
	QUEUE_ENTRY     *req_queue_headv;	/* Starting address (Aligned). */
	QUEUE_ENTRY     *rsp_queue_headv;
	dma_addr_t      req_queue_headp;
	dma_addr_t      rsp_queue_headp;

	QUEUE_ENTRY     *request_ptr;	/* Current address. */
	QUEUE_ENTRY     *response_ptr;

	uint16_t        request_in;	/* Current indexes. */
	uint16_t        request_out;
	uint16_t        response_in;
	uint16_t        response_out;

	uint16_t        req_q_count;	/* Number of available entries. */

#ifndef QLA4000
	DMA_ISP_REGS    *dma_regsv;
	dma_addr_t      dma_regsp;
#endif

	/* This spinlock must be held with irqs disabled in order to access
	 * the aen queue.
	 *
	 * The aen_q_spinlock is of lower priority than the
	 * io_request lock.
	 *-------------------------------------------------------------------*/
	spinlock_t      aen_q_spinlock;

	/* aen queue variables */
	uint16_t        aen_q_count;	/* Number of available aen_q entries */
	uint16_t        aen_in;		/* Current indexes */
	uint16_t        aen_out;
	aen_t           aen_q[MAX_AEN_ENTRIES];

	/* pdu variables */
	uint16_t        pdu_count;	/* Number of available aen_q entries */
	uint16_t        pdu_in;		/* Current indexes */
	uint16_t        pdu_out;

	PDU_ENTRY	*free_pdu_top;
	PDU_ENTRY	*free_pdu_bottom;
	uint16_t	pdu_active;
	PDU_ENTRY	pdu_queue[MAX_PDU_ENTRIES];

	/* This semaphore protects several threads to do mailbox commands
	 * concurrently.
	 *-------------------------------------------------------------------*/
	struct semaphore  mbox_sem;
	wait_queue_head_t mailbox_wait_queue;

	/* temporary mailbox status registers */
	volatile uint8_t  mbox_status_count;
	volatile uint32_t mbox_status[MBOX_REG_COUNT];

	/* This semaphore protects several threads to do ioctl commands
	 * concurrently.
	 *-------------------------------------------------------------------*/
	struct semaphore  ioctl_sem;

	/* Generic DMA Buffer */
	dma_buf_t       dma_buf;
#if 0 && defined(__VMKERNEL_MODULE__)
	spinlock_t      dma_buf_spinlock;
#else
	struct semaphore dma_buf_sem;
	struct semaphore targ_array_sem;
#endif
	
	/* DMA Memory Block */
	uint32_t        dma_mem_blk_raw_len;
	dma_mem_blk_t   *dma_mem_blk_rawv;
	dma_addr_t      dma_mem_blk_rawp;

	dma_mem_blk_t   *dma_mem_blkv;	  /* Aligned */
	dma_addr_t	dma_mem_blkp;

	/* local device database list (contains internal ddb entries)*/
	struct list_head ddb_list;
#if 1 || defined(__VMKERNEL_MODULE__)
	spinlock_t	 ddb_list_spinlock;
#endif
#ifdef __VMKERNEL_MODULE__
        iscsi_target_mapping_t iscsi_target_mappings[MAX_TARGETS];
#endif

	/* Map ddb_list entry by SCSI target id */
	ddb_entry_t *target_map[MAX_TARGETS];

	/* Map ddb_list entry by FW ddb index */
	ddb_entry_t *fw_ddb_index_map[MAX_DDB_ENTRIES];

	/*
	 * There are several Scsi_Host members that are RHEL3 specific
	 * yet depend on the SCSI_HAS_HOST_LOCK define for visibility.
	 * Unfortuantely, it seems several RH kernels have the define
	 * set, but do not have a host_lock member.
	 *
	 * Use the SH_HAS_HOST_LOCK define determined during driver
	 * compilation rather than SCSI_HAS_HOST_LOCK.
	 */
		/* Scsi midlayer lock */
	#if defined(SH_HAS_HOST_LOCK)
 	spinlock_t		host_lock ____cacheline_aligned;
	#endif
#ifdef __VMKERNEL_MODULE__
	int should_die;
#endif //__VMKERNEL_MODULE__
}scsi_qla_host_t;

#define ADAPTER_UP(ha) ((test_bit(AF_ONLINE, &ha->flags) != 0) && (test_bit(AF_LINK_UP, &ha->flags) != 0))

typedef struct
{
	uint8_t ha_mac[MAX_HBAS][MAC_ADDR_LEN];
} mac_cfgs_t;


/*
 * Scsi_Host_template (see drivers/scsi/hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/
/* highmem_io */
#ifdef SHT_HAS_HIGHMEM_IO
#define TEMPLATE_HIGHMEM_IO	highmem_io: 1,
#else
#define TEMPLATE_HIGHMEM_IO
#endif
/* can_dma_32 */
#ifdef SHT_HAS_CAN_DMA_32
#define TEMPLATE_CAN_DMA_32	can_dma_32: 1,
#else
#define TEMPLATE_CAN_DMA_32
#endif
/* single_sg_ok A.S. 2.1 */
#ifdef SHT_HAS_SINGLE_SG_OK
#define TEMPLATE_SINGLE_SG_OK	single_sg_ok: 1,
#else
#define TEMPLATE_SINGLE_SG_OK
#endif
/* can_do_varyio -- A.S. 2.1 */
#ifdef SHT_HAS_CAN_DO_VARYIO
#define TEMPLATE_CAN_DO_VARYIO	can_do_varyio: 1,
#else
#define TEMPLATE_CAN_DO_VARYIO
#endif
/* vary_io -- SLES 8 */
#ifdef SHT_HAS_VARY_IO
#define TEMPLATE_VARY_IO	vary_io: 1,
#else
#define TEMPLATE_VARY_IO
#endif

#define QLA4XXX_LINUX_TEMPLATE {		                	\
	next: 			NULL,					\
	module: 		NULL,					\
	proc_dir: 		NULL,					\
	proc_info: 		qla4xxx_proc_info,			\
TEMPLATE_NAME								\
	detect: 		qla4xxx_detect,				\
	release: 		qla4xxx_release,			\
	info: 			qla4xxx_info,				\
	ioctl: 			qla4xxx_ioctl,				\
	command: 		NULL,					\
	queuecommand: 		qla4xxx_queuecommand,			\
	eh_strategy_handler: 	NULL,					\
	eh_abort_handler: 	qla4xxx_eh_abort,	       		\
	eh_device_reset_handler: qla4xxx_eh_device_reset,		\
	eh_bus_reset_handler: 	qla4xxx_eh_bus_reset, 			\
	eh_host_reset_handler: 	qla4xxx_eh_host_reset,			\
	abort: 			NULL,    				\
	reset: 			NULL,     				\
	slave_attach: 		NULL,					\
	bios_param: 		qla4xxx_biosparam,			\
	can_queue: 		MAX_SRBS,				\
	this_id: 		-1,	/* scsi id of host adapter    */\
	sg_tablesize: 		32, 	/* max scatter-gather cmds    */\
TEMPLATE_MAX_SECTORS							\
	cmd_per_lun: 		MAX_LINKED_CMDS_PER_LUN,    /* linked */\
	present: 		0,	/* number of 4000's present   */\
	unchecked_isa_dma: 	0,	/* no memory DMA restrictions */\
	use_clustering: 	ENABLE_CLUSTERING,			\
	use_new_eh_code: 	1,					\
	emulated: 		0,					\
	proc_name: 		QLA4XXX_PROC_NAME		        \
};

#if 0
//FIXME: Add above, then test
TEMPLATE_HIGHMEM_IO						\
TEMPLATE_CAN_DMA_32						\
TEMPLATE_SINGLE_SG_OK						\
TEMPLATE_CAN_DO_VARYIO						\
TEMPLATE_VARY_IO						\

#endif

/*---------------------------------------------------------------------------*/

/*
 * Prototypes for Global Functions
 */
static scsi_qla_host_t *qla4xxx_get_adapter_handle(uint16_t instance);
static uint8_t qla4xxx_mailbox_command(scsi_qla_host_t *ha,
				uint8_t inCount,
				uint8_t outCount,
				uint32_t *mbx_cmd,
				uint32_t *mbx_sts);
static uint8_t qla4xxx_alloc_dma_memory(struct pci_dev *pdev,
				 dma_buf_t *dma_buf,
				 uint32_t size);
static inline void qla4xxx_free_dma_memory(struct pci_dev *pdev,
				    dma_buf_t *dma_buf);
static uint8_t qla4xxx_resize_dma_buf(scsi_qla_host_t *ha,
			       dma_buf_t *dma_buf,
			       uint32_t size);
static uint8_t qla4xxx_get_ddb_entry(scsi_qla_host_t *,
			      uint16_t,
			      DEV_DB_ENTRY *,
				     dma_addr_t,
			      uint32_t *,
			      uint32_t *,
			      uint32_t *,
			      uint32_t *,
			      uint16_t *,
			      uint16_t *);
static uint8_t qla4xxx_set_ddb_entry(scsi_qla_host_t *,
			      uint16_t, DEV_DB_ENTRY *,
				     dma_addr_t);
static inline uint32_t qla4xxx_get_hba_count(void);
static ddb_entry_t *qla4xxx_lookup_ddb_by_SCSIID(scsi_qla_host_t *ha,
					  uint32_t bus,
					  uint32_t target);
static ddb_entry_t *qla4xxx_lookup_ddb_by_fw_index(scsi_qla_host_t *ha,
					    uint32_t fw_ddb_index);
static inline uint8_t qla4xxx_is_discovered_target(scsi_qla_host_t *ha,
					    uint8_t *ip_addr,
					    uint8_t *alias,
					    uint8_t *name_str);
static int         qla4xxx_queuecommand(Scsi_Cmnd *,
				 void (* done)(Scsi_Cmnd *));
static uint8_t qla4xxx_login_device(scsi_qla_host_t *ha,
			     uint16_t fw_ddb_index,
			     uint16_t connection_id);
static uint8_t qla4xxx_logout_device(scsi_qla_host_t *ha,
			      uint16_t fw_ddb_index,
			      uint16_t connection_id);
static uint8_t qla4xxx_delete_device(scsi_qla_host_t *ha,
			      uint16_t fw_ddb_index,
			      uint16_t connection_id);
#if 1 || __VMWARE__
static void qla4xxx_set_device_state(scsi_qla_host_t *ha,
				 ddb_entry_t *ddb_entry, uint32_t state);
#endif
static void qla4xxx_mark_device_missing(scsi_qla_host_t *ha,
				 ddb_entry_t *ddb_entry);
static void qla4xxx_flush_all_srbs(scsi_qla_host_t *ha,
			    ddb_entry_t *ddb_entry,
			    lun_entry_t *lun_entry);
static uint8_t qla4xxx_send_command_to_isp(scsi_qla_host_t *ha,
				    srb_t *srb);
static void qla4xxx_os_cmd_timeout(srb_t *srb);
static void qla4xxx_add_timer_to_cmd(srb_t *srb, int timeout);
static void qla4xxx_delete_timer_from_cmd(srb_t *srb);
static inline uint8_t WAIT_FOR_ADAPTER_UP(scsi_qla_host_t *ha);

static PDU_ENTRY *qla4xxx_get_pdu(scsi_qla_host_t *ha, uint32_t pdu_size);
static void qla4xxx_free_pdu(scsi_qla_host_t *ha, PDU_ENTRY *pdu_entry);
static uint8_t qla4xxx_send_passthru0_iocb(scsi_qla_host_t *ha,
                                    uint16_t fw_ddb_index,
				    uint16_t connection_id,
                                    dma_addr_t pdu_dma_data,
				    uint32_t send_len,
				    uint32_t recv_len,
				    uint16_t control_flags,
				    uint32_t handle);
static void qla4xxx_iocb_pass_done(scsi_qla_host_t *ha,
			    PASSTHRU_STATUS_ENTRY *sts_entry);


/* Defines for qla4xxx_initialize_adapter() and qla4xxx_recover_adapter() */
#define PRESERVE_DDB_LIST	0
#define REBUILD_DDB_LIST	1

/* Defines for qla4xxx_process_aen() */
#define PROCESS_ALL_AENS	 0
#define FLUSH_DDB_CHANGED_AENS	 1
#define RELOGIN_DDB_CHANGED_AENS 2

/* Defines for qla4xxx_relogin_all_targets() */
#define DO_RELOGIN	1
#define NO_RELOGIN	0

#if defined(__cplusplus)
}
#endif

#endif /*_QLA4XXX_H */

/*
 * Overrides for Emacs so that we get a uniform tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 4
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * c-continued-statement-offset: 4
 * c-continued-brace-offset: 0
 * indent-tabs-mode: nil
 * tab-width: 8
 * End:
 */
