/******************************************************************************
 *     Copyright (C)  2003 -2005 QLogic Corporation
 * QLogic ISP4xxx Device Driver
 *
 * This program includes a device driver for Linux 2.4.x that may be
 * distributed with QLogic hardware specific firmware binary file.
 * You may modify and redistribute the device driver code under the
 * GNU General Public License as published by the Free Software Foundation
 * (version 2 or a later version) and/or under the following terms,
 * as applicable:
 *
 * 	1. Redistribution of source code must retain the above copyright
 *         notice, this list of conditions and the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above copyright
 *         notice, this list of conditions and the following disclaimer in
 *         the documentation and/or other materials provided with the
 *         distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 * 	
 * You may redistribute the hardware specific firmware binary file under
 * the following terms:
 * 	1. Redistribution of source code (only if applicable), must
 *         retain the above copyright notice, this list of conditions and
 *         the following disclaimer.
 * 	2. Redistribution in binary form must reproduce the above
 *         copyright notice, this list of conditions and the following
 *         disclaimer in the documentation and/or other materials provided
 *         with the distribution.
 * 	3. The name of QLogic Corporation may not be used to endorse or
 *         promote products derived from this software without specific
 *         prior written permission
 *
 * REGARDLESS OF WHAT LICENSING MECHANISM IS USED OR APPLICABLE,
 * THIS PROGRAM IS PROVIDED BY QLOGIC CORPORATION "AS IS'' AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR
 * ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 *
 * USER ACKNOWLEDGES AND AGREES THAT USE OF THIS PROGRAM WILL NOT CREATE
 * OR GIVE GROUNDS FOR A LICENSE BY IMPLICATION, ESTOPPEL, OR OTHERWISE
 * IN ANY INTELLECTUAL PROPERTY RIGHTS (PATENT, COPYRIGHT, TRADE SECRET,
 * MASK WORK, OR OTHER PROPRIETARY RIGHT) EMBODIED IN ANY OTHER QLOGIC
 * HARDWARE OR SOFTWARE EITHER SOLELY OR IN COMBINATION WITH THIS PROGRAM
 *
 ******************************************************************************/
#ifndef _QLISIOLN_H_
#define _QLISIOLN_H_

#include <linux/ioctl.h>

#ifdef APILIB
#include <stdint.h>
#endif

#ifndef INT8
#define	INT8	int8_t
#endif
#ifndef INT16
#define	INT16	int16_t
#endif
#ifndef INT32
#define	INT32	int32_t
#endif
#ifndef UINT8
#define	UINT8	uint8_t
#endif
#ifndef UINT16
#define	UINT16	uint16_t
#endif
#ifndef UINT32
#define	UINT32	uint32_t
#endif

#ifndef UINT64
#define UINT64  unsigned long long
#endif

#ifndef BOOLEAN
#define BOOLEAN uint8_t
#endif


#if BITS_PER_LONG <= 32
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_32
#else
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_64
#endif


#define QLMULTIPATH_MAGIC 'y'

#define _QLBUILD   /* for qlisioct.h to enable include of qinsdmgt.h */



#define	EXT_DEF_MAX_HBA_OS		255	/* 0 - 0xFE */
#define	EXT_DEF_MAX_BUS_OS		1
#define	EXT_DEF_MAX_TARGET_OS		255	/* 0 - 0xFE */
#define	EXT_DEF_MAX_LUN_OS		255	/* 0 - 0xFE */

#define EXT_DEF_MAX_AEN_QUEUE_OS        64



/*****************/
/*                       Command codes                       */
/*****************/

/* These are regular command codes */
#define EXT_DEF_REG_CC_START_IDX	0x00

#define EXT_CC_QUERY_OS				/* QUERY */	\
    _IOWR(QLMULTIPATH_MAGIC, 0x00, sizeof(EXT_IOCTL_ISCSI))
	
#define EXT_CC_REG_AEN_OS			/* REG_AEN */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x01, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_GET_AEN_OS			/* GET_AEN */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x02, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_GET_DATA_OS			/* GET_DATA */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x03, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_SET_DATA_OS			/* SET_DATA */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x04, sizeof(EXT_IOCTL_ISCSI))
	
#define EXT_CC_SEND_SCSI_PASSTHRU_OS		/* SCSI_PASSTHRU */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x05, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_SEND_ISCSI_PASSTHRU_OS		/* ISCSI_PASSTHRU */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x06, sizeof(EXT_IOCTL_ISCSI))

#define EXT_DEF_REG_CC_END_IDX		0x06

/*
 * This is a Linux driver implementation specific command.
 */
#define EXT_DEF_DRV_SPC_CC_START_IDX	0xff

#define EXT_CC_GET_HBACNT			/* GET_HBACNT */ \
    _IOWR(QLMULTIPATH_MAGIC, 0xff, sizeof(EXT_IOCTL_ISCSI))

#define EXT_DEF_DRV_SPC_CC_END_IDX	0xff

/*
 * HBA Count
 */
typedef struct _EXT_HBA_COUNT {
	UINT16	HbaCnt;				/* 2 */
} EXT_HBA_COUNT, *PEXT_HBA_COUNT;		/* 2 */


#endif //_QLISIOLN_H_
