/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

/*
   FILE NAME = eeprom.h
   CONTENTS  = EEPROM definition for ISP4022
*/

#ifndef EEPROM_H
#define EEPROM_H

#define CHAR_BITFIELD   unsigned char
#define SHORT_BITFIELD  unsigned short

//
// Hardware definitions
//
#define  FM93C56A_SIZE_8      0x100
#define  FM93C56A_SIZE_16     0x80
#define  FM93C66A_SIZE_8      0x200
#define  FM93C66A_SIZE_16     0x100
#define  FM93C86A_SIZE_16     0x400

#ifdef SMALL_EEPROM
#define  EEPROM_SIZE          FM93C66A_SIZE_16
#else
#define  EEPROM_SIZE          FM93C86A_SIZE_16
#endif

// Address Bits
#define  FM93C56A_NO_ADDR_BITS_16   8
#define  FM93C56A_NO_ADDR_BITS_8    9
#define  FM93C86A_NO_ADDR_BITS_16  10

#ifdef SMALL_EEPROM
#define  EEPROM_NO_ADDR_BITS  FM93C56A_NO_ADDR_BITS_16
#else
#define  EEPROM_NO_ADDR_BITS  FM93C86A_NO_ADDR_BITS_16
#endif

// Data Bits
#define  FM93C56A_DATA_BITS_16   16
#define  FM93C56A_DATA_BITS_8    8

#define  EEPROM_NO_DATA_BITS  FM93C56A_DATA_BITS_16

//
// MAC Config data structure
//
typedef struct {
   // MTU MAC 0
   UINT16               etherMtu_mac;

   // Flow Control MAC 0
   UINT16               pauseThreshold_mac;
   UINT16               resumeThreshold_mac;
   UINT16               reserved[13];
} EEPROM_PORT_CFG;

//
// BIOS data structure
//
typedef struct {
   SHORT_BITFIELD       SpinDlyEn: 1,
                        disBios:  1,
                        EnMemMap: 1,
                        EnSelectBoot:  1,
                        Reserved:  12;

   CHAR_BITFIELD        bootID0:  7,
                        boodID0Valid:  1;
   UINT8                bootLun0[8];

   CHAR_BITFIELD        bootID1:  7,
                        boodID1Valid:  1;
   UINT8                bootLun1[8];

   UINT16               MaxLunsTrgt;
   UINT8                reserved[10];
} EEPROM_BIOS_CFG;

//
// Function Specific Data structure
//
typedef struct {
   UINT8                reserved[30];

   // MAC ADDR
   UINT8                macAddress[6];
   UINT8                macAddressSecondary[6];

   UINT16               subsysVendorId;
   UINT16               subsysDeviceId;
} EEPROM_FUNCTION_CFG;

//
// EEPROM format
//
typedef struct EEPROM_DATA_ {
   UINT8                asicId[4];                     //    0 (000h)
   UINT8                version;                       //    4 (004h)
   UINT8                reserved_5;                    //    5 (005h)

   UINT16               boardId;                       //    6 (006h)
   UINT8                boardIdStr[16];                //    8 (008h)
   UINT8                serialNumber[16];              //   24 (018h)

   // External Hardware Configuration
   UINT16               extHwConfig;                   //   40 (028h)

   // MAC 0 CONFIGURATION
   EEPROM_PORT_CFG macCfg_port0;                       //   42 (02Ah)

   // MAC 1 CONFIGURATION
   EEPROM_PORT_CFG macCfg_port1;                       //   74 (04Ah)

   // DDR SDRAM Configuration
   UINT16               bufletSize;                    //  106 (06Ah)
   UINT16               bufletCount;                   //  108 (06Ch)
   UINT16               tcpWindowThreshold50;          //  110 (06Eh)
   UINT16               tcpWindowThreshold25;          //  112 (070h)
   UINT16               tcpWindowThreshold0;           //  114 (072h)
   UINT16               ipHashTableBaseHi;             //  116 (074h)
   UINT16               ipHashTableBaseLo;             //  118 (076h)
   UINT16               ipHashTableSize;               //  120 (078h)
   UINT16               tcpHashTableBaseHi;            //  122 (07Ah)
   UINT16               tcpHashTableBaseLo;            //  124 (07Ch)
   UINT16               tcpHashTableSize;              //  126 (07Eh)
   UINT16               ncbTableBaseHi;                //  128 (080h)
   UINT16               ncbTableBaseLo;                //  130 (082h)
   UINT16               ncbTableSize;                  //  132 (084h)
   UINT16               drbTableBaseHi;                //  134 (086h)
   UINT16               drbTableBaseLo;                //  136 (088h)
   UINT16               drbTableSize;                  //  138 (08Ah)
   UINT16               reserved_142[4];               //  140 (08Ch)

   // TCP/IP Parameters
   UINT16               ipReassemblyTimeout;           //  148 (094h)
   UINT16               tcpMaxWindowSize;              //  150 (096h)
   UINT16               ipSecurity;                    //  152 (098h)

   UINT8                reserved_156[294];             //  154 (09Ah)
   UINT16               qDebug[8];  // QLOGIC USE ONLY     448 (1C0h)

   EEPROM_FUNCTION_CFG  funcCfg_fn0;                   //  464 (1D0h)
   UINT16               reserved_510;                  //  510 (1FEh)

   // Address = 512
   UINT8                oemSpace[432];                 //  512 (200h)

   EEPROM_BIOS_CFG      biosCfg_fn1;                   //  944 (3B0h)
   EEPROM_FUNCTION_CFG  funcCfg_fn1;                   //  976 (3D0h)
   UINT16               reserved_1022;                 // 1022 (3FEh)


   // Address = 1024
   UINT8                reserved_1024[464];            // 1024 (400h)
   EEPROM_FUNCTION_CFG  funcCfg_fn2;                   // 1488 (5D0h)

   UINT16               reserved_1534;                 // 1534 (5FEh)

   // Address = 1536
   UINT8                reserved_1536[432];            // 1536 (600h)
   EEPROM_BIOS_CFG      biosCfg_fn3;                   // 1968 (7B0h)
   EEPROM_FUNCTION_CFG  funcCfg_fn3;                   // 2000 (7D0h)

   UINT16               checksum;                      // 2046 (7FEh)

} EEPROM_DATA;


extern EEPROM_DATA  eepromData;

// QLOGIC Debug Data
#define Q_DEBUG_FLAGS  eepromData.qDebug[0]
#define Q_DEBUG_FLAG_SET_PROBE_MUX   0x0001
#define Q_DEBUG_PROBE_MUX eepromData.qDebug[1]

extern BOOL eepromFwManagePhy(void);

extern BOOL eepromUpdate(EEPROM_DATA *pEEPromData);
extern UINT16 eepromGetBoardId(void);
extern BOOL isEepromValid(void);

#endif /* EEPROM_H */

