/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#include "qla4xxx.h"
#include "ql4print.h"
#include "qlisioct.h"
#include "qlinioct.h"

#if defined QLA_CONFIG_COMPAT

#include <linux/file.h>

#define QL_IOCTL_CMD(idx)					\
    _IOWR(QLMULTIPATH_MAGIC, idx, sizeof(EXT_IOCTL_ISCSI))


/* fs/ioctl.c */
extern asmlinkage long sys_ioctl(unsigned int fd, unsigned int cmd, void *);

extern int register_ioctl32_conversion(unsigned int cmd,
    int (*handler)(unsigned int, unsigned int, unsigned long, struct file *));
extern int unregister_ioctl32_conversion(unsigned int cmd);


typedef struct {
	UINT64	Signature;				/* 8   */
	UINT16	AddrMode;				/* 2   */
	UINT16	Version;				/* 2   */
	UINT16	SubCode;				/* 2   */
	UINT16	Instance;				/* 2   */
	UINT32	Status;					/* 4   */
	UINT32	DetailStatus;				/* 4   */
	UINT32	Reserved1;				/* 4   */
	UINT32	RequestLen;				/* 4   */
	UINT32	ResponseLen;				/* 4   */
	UINT64	RequestAdr;				/* 8   */
	UINT64	ResponseAdr;				/* 8   */
	UINT16	HbaSelect;				/* 2   */
	UINT32	VendorSpecificStatus[11];		/* 44  */
	UINT64	Signature2;				/* 8   */
} __attribute__((packed)) EXT_IOCTL_ISCSI_32;


int
qla4xxx_ioctl32(unsigned int fd, unsigned int cmd, unsigned long arg,
    struct file *pfile)
{
	QL4PRINT(QLP4,
	    printk("%s: received cmd %x.\n", __func__, cmd));
	return (sys_ioctl(fd, cmd, (void *)arg));
}

static int
apidev_reg_increasing_idx(uint16_t low_idx, uint16_t high_idx)
{
	int	err = 0;
	int	i;
	unsigned int cmd;

	for (i = low_idx; i <= high_idx; i++) {
		cmd = (unsigned int)QL_IOCTL_CMD(i);
		err = register_ioctl32_conversion(cmd, qla4xxx_ioctl32);
		if (err) {
			QL4PRINT(QLP2|QLP4,
			    printk(
			    "%s: error registering cmd %x. err=%d.\n",
			    __func__, cmd, err));

			break;
		}
		QL4PRINT(QLP4,
		    printk("%s: registered cmd %x.\n", __func__, cmd));
	}

	return (err);
}

static int
apidev_reg_increasing_val(uint32_t low_val, uint32_t high_val)
{
	int		err = 0;
	uint32_t	i;

	for (i = low_val; i <= high_val; i++) {
		err = register_ioctl32_conversion(i, qla4xxx_ioctl32);
		if (err) {
			QL4PRINT(QLP2|QLP4,
			    printk(
			    "%s: error registering cmd %x. err=%d.\n",
			    __func__, i, err));

			break;
		}
		QL4PRINT(QLP4,
		    printk("%s: registered cmd %x.\n", __func__, i));
	}

	return (err);
}

static int
apidev_unreg_increasing_idx(uint16_t low_idx, uint16_t high_idx)
{
	int	err = 0;
	int	i;
	unsigned int cmd;

	for (i = low_idx; i <= high_idx; i++) {
		cmd = (unsigned int)QL_IOCTL_CMD(i);
		err = unregister_ioctl32_conversion(cmd);
		if (err) {
			QL4PRINT(QLP2|QLP4,
			    printk(
			    "%s: error unregistering cmd %x. err=%d.\n",
			    __func__, cmd, err));
			break;
		}
		QL4PRINT(QLP4,
		    printk("%s: unregistered cmd %x.\n", __func__, cmd));
	}

	return (err);
}

static int
apidev_unreg_increasing_val(uint32_t low_val, uint32_t high_val)
{
	int		err = 0;
	uint32_t	i;

	for (i = low_val; i <= high_val; i++) {
		err = unregister_ioctl32_conversion(i);
		if (err) {
			QL4PRINT(QLP2|QLP4,
			    printk(
			    "%s: error unregistering cmd %x. err=%d.\n",
			    __func__, i, err));
			break;
		}
		QL4PRINT(QLP4,
		    printk("%s: unregistered cmd %x.\n", __func__, i));
	}

	return (err);
}

void
ql4_apidev_init_32ioctl(void)
{
	int	err;

	ENTER(__func__);

	QL4PRINT(QLP4,
	    printk("%s: going to register ioctl32 cmds.\n",
	    __func__));

	/* regular external ioctl codes */
	err = apidev_reg_increasing_idx(EXT_DEF_REG_CC_START_IDX,
	    EXT_DEF_REG_CC_END_IDX);
	if (!err) {
		/* regular internal ioctl codes */
		err = apidev_reg_increasing_val(INT_CC_START_VAL,
		    INT_CC_END_VAL);
	}
	if (!err) {
		/* LN Drvr specific codes are defined in decreasing order */
		err = apidev_reg_increasing_idx(EXT_DEF_DRV_SPC_CC_END_IDX,
		    EXT_DEF_DRV_SPC_CC_START_IDX);
	}
	if (err) {
		QL4PRINT(QLP2|QLP4,
		    printk("%s: register failed.\n",
		    __func__));
	}

	LEAVE(__func__);
}

void
ql4_apidev_cleanup_32ioctl(void)
{
	int	err;

	ENTER(__func__);

	QL4PRINT(QLP4,
	    printk("%s: going to unregister ioctl32 cmds.\n",
	    __func__));

	/* regular external ioctl codes */
	err = apidev_unreg_increasing_idx(EXT_DEF_REG_CC_START_IDX,
	    EXT_DEF_REG_CC_END_IDX);
	if (!err) {
		/* regular internal ioctl codes */
		err = apidev_unreg_increasing_val(INT_CC_START_VAL,
		    INT_CC_END_VAL);
	}
	if (!err) {
		/* LN Drvr specific codes are defined in decreasing order */
		err = apidev_unreg_increasing_idx(EXT_DEF_DRV_SPC_CC_END_IDX,
		    EXT_DEF_DRV_SPC_CC_START_IDX);
	}

	if (err) {
		QL4PRINT(QLP2|QLP4,
		    printk("%s: unregister failed.\n",
		    __func__));
	}

	LEAVE(__func__);
}

#endif /* QLA_CONFIG_COMPAT */
