/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

/******************************************************************************
 * Function Table of Contents:
 *      qla4xxx_take_hw_semaphore
 *      qla4xxx_clear_hw_semaphore
 ****************************************************************************/



#ifdef QLA4000
#define  qla4xxx_sem_lock(ha, sem_mask, sem_bits) 1
#define  qla4xxx_sem_unlock(ha, sem_mask)
#define  qla4xxx_sem_spinlock(ha, sem_mask, sem_bits) 1
#else
int qla4xxx_sem_spinlock(scsi_qla_host_t *ha, u32 sem_mask, u32 sem_bits)
 {
    uint32_t      value;
    QL4PRINT(QLP26, printk(KERN_INFO "scsi%d : Trying to get SEM lock - mask= 0x%x, code = 0x%x\n",
	ha->host_no, sem_mask, sem_bits));
    while ( 1 ) {
        WRT_REG_DWORD(ISP_SEMAPHORE(ha), (sem_mask | sem_bits));
        value = RD_REG_DWORD(ISP_SEMAPHORE(ha));
        if ((value & (sem_mask >> 16)) == sem_bits) {
    		QL4PRINT(QLP26, printk(KERN_INFO "scsi%d : Got SEM LOCK - mask= 0x%x, code = 0x%x\n",
		ha->host_no, sem_mask, sem_bits));
            break;
	}
    }
   return (1);
 }

void qla4xxx_sem_unlock(scsi_qla_host_t *ha, u32 sem_mask)
{
    WRT_REG_DWORD(ISP_SEMAPHORE(ha), sem_mask);
    PCI_POSTING(ISP_SEMAPHORE(ha));
    QL4PRINT(QLP26, printk(KERN_INFO "scsi%d : UNLOCK SEM - mask= 0x%x\n",
	 ha->host_no, sem_mask));
}

int qla4xxx_sem_lock(scsi_qla_host_t *ha, u32 sem_mask, u32 sem_bits)
{
	uint32_t      value;
	WRT_REG_DWORD(ISP_SEMAPHORE(ha), (sem_mask | sem_bits));
	value = RD_REG_DWORD(ISP_SEMAPHORE(ha));
	if ((value & (sem_mask >> 16)) == sem_bits) {
		QL4PRINT(QLP26, printk(KERN_INFO "scsi%d : Got SEM LOCK - mask= 0x%x, code = 0x%x, sema code=0x%x\n",
				       ha->host_no, sem_mask, sem_bits, value));
		return(1);
	} else {
		return(0);
	}
}

#ifdef QLA4010
/* Semaphore Defines for 4010 */
#define QLA4010_DRVR_SEM_BITS    0x00000030
#define QLA4010_GPIO_SEM_BITS    0x000000c0
#define QLA4010_SDRAM_SEM_BITS   0x00000300
#define QLA4010_PHY_SEM_BITS     0x00000c00
#define QLA4010_NVRAM_SEM_BITS   0x00003000
#define QLA4010_FLASH_SEM_BITS   0x0000c000

#define QLA4010_DRVR_SEM_MASK    0x00300000
#define QLA4010_GPIO_SEM_MASK    0x00c00000
#define QLA4010_SDRAM_SEM_MASK   0x03000000
#define QLA4010_PHY_SEM_MASK     0x0c000000
#define	QLA4010_NVRAM_SEM_MASK	0x30000000
#define QLA4010_FLASH_SEM_MASK   0xc0000000


#define QLA4XXX_LOCK_FLASH(a) 	(qla4xxx_sem_spinlock(a, QLA4010_FLASH_SEM_MASK, QLA4010_FLASH_SEM_BITS))
#define QLA4XXX_LOCK_NVRAM(a)   (qla4xxx_sem_spinlock(a, QLA4010_NVRAM_SEM_MASK, QLA4010_NVRAM_SEM_BITS))
#define QLA4XXX_LOCK_GIO(a) 	(qla4xxx_sem_spinlock(a, QLA4010_GPIO_SEM_MASK, QLA4010_GPIO_SEM_BITS))
#define QLA4XXX_LOCK_PHY(a) 	(qla4xxx_sem_spinlock(a, QLA4010_PHY_SEM_MASK, QLA4010_PHY_SEM_BITS))
#define QLA4XXX_LOCK_DDR_RAM(a) (qla4xxx_sem_spinlock(a, QLA4010_SDRAM_SEM_MASK, QLA4010_SDRAM_SEM_BITS))
#define QLA4XXX_LOCK_DRVR(a)  	(qla4xxx_sem_lock(a, QLA4010_DRVR_SEM_MASK, QLA4010_DRVR_SEM_BITS))
#define QLA4XXX_UNLOCK_DRVR(a) 	(qla4xxx_sem_unlock(a, QLA4010_DRVR_SEM_MASK))
#define QLA4XXX_UNLOCK_GIO(a) 	(qla4xxx_sem_unlock(a, QLA4010_GPIO_SEM_MASK))
#define QLA4XXX_UNLOCK_DDR_RAM(a) (qla4xxx_sem_unlock(a, QLA4010_SDRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_PHY(a) 	(qla4xxx_sem_unlock(a, QLA4010_PHY_SEM_MASK))
#define QLA4XXX_UNLOCK_NVRAM(a) (qla4xxx_sem_unlock(a, QLA4010_NVRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_FLASH(a) (qla4xxx_sem_unlock(a, QLA4010_FLASH_SEM_MASK))
#else

#ifdef QLA4022
/* Semaphore Defines for 4022 */
#define QLA4022_RESOURCE_MASK_BASE_CODE 0x7
#define QLA4022_RESOURCE_BITS_BASE_CODE 0x4

#define QLA4022_DRVR_SEM_BITS    (QLA4022_RESOURCE_BITS_BASE_CODE << 1)
#define QLA4022_DDR_RAM_SEM_BITS (QLA4022_RESOURCE_BITS_BASE_CODE << 4)
#define QLA4022_PHY_GIO_SEM_BITS (QLA4022_RESOURCE_BITS_BASE_CODE << 7)
#define QLA4022_NVRAM_SEM_BITS   (QLA4022_RESOURCE_BITS_BASE_CODE << 10)
#define QLA4022_FLASH_SEM_BITS   (QLA4022_RESOURCE_BITS_BASE_CODE << 13)

#define QLA4022_DRVR_SEM_MASK    (QLA4022_RESOURCE_MASK_BASE_CODE << (1+16))
#define QLA4022_DDR_RAM_SEM_MASK (QLA4022_RESOURCE_MASK_BASE_CODE << (4+16))
#define QLA4022_PHY_GIO_SEM_MASK (QLA4022_RESOURCE_MASK_BASE_CODE << (7+16))
#define QLA4022_NVRAM_SEM_MASK   (QLA4022_RESOURCE_MASK_BASE_CODE << (10+16))
#define QLA4022_FLASH_SEM_MASK   (QLA4022_RESOURCE_MASK_BASE_CODE << (13+16))

#define QLA4XXX_LOCK_FLASH(a)   (qla4xxx_sem_spinlock(a, QLA4022_FLASH_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 13))
#define QLA4XXX_LOCK_NVRAM(a)   (qla4xxx_sem_spinlock(a, QLA4022_NVRAM_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 10))
#define QLA4XXX_LOCK_GIO(a) 	(qla4xxx_sem_spinlock(a, QLA4022_PHY_GIO_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 7))
#define QLA4XXX_LOCK_PHY(a) 	(qla4xxx_sem_spinlock(a, QLA4022_PHY_GIO_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 7))
#define QLA4XXX_LOCK_DDR_RAM(a) (qla4xxx_sem_spinlock(a, QLA4022_DDR_RAM_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 4))
#define QLA4XXX_LOCK_DRVR(a)    (qla4xxx_sem_lock(a, QLA4022_DRVR_SEM_MASK, (QLA4022_RESOURCE_BITS_BASE_CODE | (a->mac_index)) << 1))
#define QLA4XXX_UNLOCK_DRVR(a)  (qla4xxx_sem_unlock(a, QLA4022_DRVR_SEM_MASK))
#define QLA4XXX_UNLOCK_GIO(a)   (qla4xxx_sem_unlock(a, QLA4022_PHY_GIO_SEM_MASK))
#define QLA4XXX_UNLOCK_DDR_RAM(a) (qla4xxx_sem_unlock(a, QLA4022_DDR_RAM_SEM_MASK))
#define QLA4XXX_UNLOCK_PHY(a)   (qla4xxx_sem_unlock(a, QLA4022_PHY_GIO_SEM_MASK))
#define QLA4XXX_UNLOCK_NVRAM(a) (qla4xxx_sem_unlock(a, QLA4022_NVRAM_SEM_MASK))
#define QLA4XXX_UNLOCK_FLASH(a) (qla4xxx_sem_unlock(a, QLA4022_FLASH_SEM_MASK))


#endif /* QLA4022 */
#endif /* !QLA4010 */

int qla4xxx_lock_drvr_wait(scsi_qla_host_t *ha)
{
	int i = 0;
        while (1) {
		if (QLA4XXX_LOCK_DRVR(ha) == 0) {
			schedule_timeout(10);
			if (!i) {
				QL4PRINT(QLP26, printk(KERN_INFO "scsi%d: %s Waiting for Global Init Semaphore...\n",ha->host_no,__func__));
				i++;
			}
		}
		else {
			QL4PRINT(QLP26, printk(KERN_INFO "scsi%d: %s: Global Init Semaphore acquired.\n",ha->host_no,__func__));
			return QLA_SUCCESS;
		}
        }
	return QLA_ERROR;
}

#endif /* !QLA4000 */


