
/*****************************************/
/*   ISP Boards supported by this driver */
/*****************************************/

#define QLA4XXX_BOARD_PORTS		1

typedef struct _ql4boards
{
        unsigned char   bd_id_str[9];       /* Board ID String             */
        unsigned char   bd_name_str[9];      /* Board name String          */
        unsigned long   device_id;       /* Device ID                   */
        int   num_ports;                  /* number of loops on adapter  */
}  ql4_boards_t;



static struct _ql4boards   ql4brdtbl[NUM_OF_ISP_DEVICES] =
{
	/* Name ,  Board PCI Device ID,         Number of ports */
#if defined(QLA4022)
	{"4022", "QLA4022", QLA4022_DEVICE_ID, QLA4XXX_BOARD_PORTS},
	{"4032", "QLE4032", QLA4032_DEVICE_ID, QLA4XXX_BOARD_PORTS},

#endif

#if defined(QLA4010)
	{"4010", "QLA4010", QLA4010_DEVICE_ID,QLA4XXX_BOARD_PORTS},
#endif

#if defined(QLA4000)
	{"4000", "QLA4000", QLA4000_DEVICE_ID,QLA4XXX_BOARD_PORTS},
#endif

	{"         ", "         ",       0,           0}
};



