/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#include <asm/delay.h>
#include "ql4nvram.h"

int   eepromSize  = EEPROM_SIZE;
int   addrBits    = EEPROM_NO_ADDR_BITS;
int   dataBits    = EEPROM_NO_DATA_BITS;
int   eepromCmdData = 0;

#define ISP_NVRAM   (u32 *)chip_addr

#define write_eeprom(cmd)  \
{	   \
	WRT_REG_DWORD(ISP_NVRAM, cmd); \
	PCI_POSTING(ISP_NVRAM);	 \
	udelay(1); \
}


static int qla4xxx_FM93C56A_Select(u32 * chip_addr)
{
	QL4PRINT(QLP17, printk(KERN_ERR "%s:\n", __func__));
	eepromCmdData = AUBURN_EEPROM_CS_1 | 0x000f0000 ;
	write_eeprom(eepromCmdData);
	return(1);
}
static int qla4xxx_FM93C56A_Cmd(int cmd, int addr, u32 *chip_addr)
{
	int   i;
	int   mask;
	int   dataBit;
	int   previousBit;

	QL4PRINT(QLP17, printk(KERN_ERR "%s(%d, 0x%x)\n",
			       __func__, cmd, addr));

	// Clock in a zero, then do the start bit
	write_eeprom(eepromCmdData | AUBURN_EEPROM_DO_1);
	write_eeprom(eepromCmdData | AUBURN_EEPROM_DO_1 | AUBURN_EEPROM_CLK_RISE);
	write_eeprom(eepromCmdData | AUBURN_EEPROM_DO_1 | AUBURN_EEPROM_CLK_FALL);

	mask = 1 << (FM93C56A_CMD_BITS-1);
	// Force the previous data bit to be different
	previousBit = 0xffff;
	for (i = 0; i < FM93C56A_CMD_BITS; i++) {
		dataBit = (cmd & mask) ? AUBURN_EEPROM_DO_1 : AUBURN_EEPROM_DO_0;
		if (previousBit != dataBit) {
			// If the bit changed, then change the DO state to match
			write_eeprom(eepromCmdData | dataBit);
			previousBit = dataBit;
		}
		write_eeprom(eepromCmdData | dataBit | AUBURN_EEPROM_CLK_RISE);
		write_eeprom(eepromCmdData | dataBit | AUBURN_EEPROM_CLK_FALL);
		cmd = cmd << 1;
	}

	mask = 1 << (addrBits-1);
	// Force the previous data bit to be different
	previousBit = 0xffff;
	for (i = 0; i < addrBits; i++) {
		dataBit = (addr & mask) ? AUBURN_EEPROM_DO_1 : AUBURN_EEPROM_DO_0;
		if (previousBit != dataBit) {
			// If the bit changed, then change the DO state to match
			write_eeprom(eepromCmdData | dataBit);
			previousBit = dataBit;
		}
		write_eeprom(eepromCmdData | dataBit | AUBURN_EEPROM_CLK_RISE);
		write_eeprom(eepromCmdData | dataBit | AUBURN_EEPROM_CLK_FALL);
		addr = addr << 1;
	}
	return(1);
}

static int qla4xxx_FM93C56A_Deselect(u32 *chip_addr)
{
	QL4PRINT(QLP17, printk(KERN_ERR "%s:\n", __func__));
	eepromCmdData = AUBURN_EEPROM_CS_0 | 0x000f0000 ;
	write_eeprom(eepromCmdData);
	return(1);
}

static int qla4xxx_FM93C56A_DataIn(unsigned short *value, u32 *chip_addr)
{
	int   i;
	int   data = 0;
	int   dataBit;

	// Read the data bits
	// The first bit is a dummy.  Clock right over it.
	for (i = 0; i < dataBits; i++) {
		write_eeprom(eepromCmdData | AUBURN_EEPROM_CLK_RISE);
		write_eeprom(eepromCmdData | AUBURN_EEPROM_CLK_FALL);
		dataBit = (RD_REG_DWORD(ISP_NVRAM) & AUBURN_EEPROM_DI_1) ? 1 : 0;
		data = (data << 1) | dataBit;
	}
	*value = data;
	QL4PRINT(QLP17, printk(KERN_ERR "%s: (0x%x)\n", __func__, *value));
	return(1);
}

static int
EEPROM_ReadWord(int eepromAddr, u16 *value, scsi_qla_host_t *ha)
{
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_Reg addr %p\n", &ha->reg->NVRAM));
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_ReadWord(0x%x)\n", eepromAddr));

	qla4xxx_FM93C56A_Select(&ha->reg->NVRAM);
	qla4xxx_FM93C56A_Cmd(FM93C56A_READ, eepromAddr, &ha->reg->NVRAM);
	qla4xxx_FM93C56A_DataIn(value, &ha->reg->NVRAM);
	qla4xxx_FM93C56A_Deselect(&ha->reg->NVRAM);
	QL4PRINT(QLP17, printk(KERN_ERR "EEPROM_ReadWord(0x%x, %d)\n", eepromAddr, *value));
	return(1);
}

/* NOTE: NVRAM uses half-word addresses */
static u16
RD_NVRAM_WORD(scsi_qla_host_t *ha, int offset)
{
	u16 val;
	EEPROM_ReadWord((int) offset, &val, ha)
	;
	return(val);
}

static uint8_t
qla4xxx_is_NVRAM_configuration_valid(scsi_qla_host_t *ha)
{
	uint16_t checksum = 0;
	uint32_t index;
	unsigned long   flags = 0;
	
	spin_lock_irqsave(&ha->hardware_lock, flags);
	for (index = 0; index < EEPROM_SIZE; index++)
		checksum += RD_NVRAM_WORD(ha, index);
	spin_unlock_irqrestore(&ha->hardware_lock, flags);

	if (checksum == 0)
		return QLA_SUCCESS;

	return QLA_ERROR;
}

/*
 * Overrides for Emacs so that we get a uniform tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 4
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * c-continued-statement-offset: 4
 * c-continued-brace-offset: 0
 * indent-tabs-mode: nil
 * tab-width: 8
 * End:
 */
