/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */


#ifndef _QL4NVRM_H_
#define _QL4NVRM_H_


//
// AM29LV Flash definitions
//
#define  FM93C56A_SIZE_8      0x100
#define  FM93C56A_SIZE_16     0x80
#define  FM93C66A_SIZE_8      0x200
#define  FM93C66A_SIZE_16     0x100
#define  FM93C86A_SIZE_16     0x400
	
#ifdef QLA4022
#define  EEPROM_SIZE          FM93C86A_SIZE_16
#else
#define  EEPROM_SIZE          FM93C66A_SIZE_16
#endif
	
#define  FM93C56A_START       0x1

// Commands
#define  FM93C56A_READ        0x2
#define  FM93C56A_WEN         0x0
#define  FM93C56A_WRITE       0x1
#define  FM93C56A_WRITE_ALL   0x0
#define  FM93C56A_WDS         0x0
#define  FM93C56A_ERASE       0x3
#define  FM93C56A_ERASE_ALL   0x0

// Command Extentions
#define  FM93C56A_WEN_EXT        0x3
#define  FM93C56A_WRITE_ALL_EXT  0x1
#define  FM93C56A_WDS_EXT        0x0
#define  FM93C56A_ERASE_ALL_EXT  0x2

// Address Bits
#define  FM93C56A_NO_ADDR_BITS_16   8
#define  FM93C56A_NO_ADDR_BITS_8    9
#define  FM93C86A_NO_ADDR_BITS_16   10

#ifdef QLA4022
#define  EEPROM_NO_ADDR_BITS  FM93C86A_NO_ADDR_BITS_16
#else
#define  EEPROM_NO_ADDR_BITS  FM93C56A_NO_ADDR_BITS_16
#endif

// Data Bits
#define  FM93C56A_DATA_BITS_16   16
#define  FM93C56A_DATA_BITS_8    8

#define  EEPROM_NO_DATA_BITS  FM93C56A_DATA_BITS_16

// Special Bits
#define  FM93C56A_READ_DUMMY_BITS   1
#define  FM93C56A_READY             0
#define  FM93C56A_BUSY              1
#define  FM93C56A_CMD_BITS          2

// Auburn Bits
#define  AUBURN_EEPROM_DI           0x8
#define  AUBURN_EEPROM_DI_0         0x0
#define  AUBURN_EEPROM_DI_1         0x8
#define  AUBURN_EEPROM_DO           0x4
#define  AUBURN_EEPROM_DO_0         0x0
#define  AUBURN_EEPROM_DO_1         0x4
#define  AUBURN_EEPROM_CS           0x2
#define  AUBURN_EEPROM_CS_0         0x0
#define  AUBURN_EEPROM_CS_1         0x2
#define  AUBURN_EEPROM_CLK_RISE     0x1
#define  AUBURN_EEPROM_CLK_FALL     0x0


//
// EEPROM format
//
#ifdef QLA4022

// NVRAM format
typedef struct _BIOS_PARAMS
{
    UINT16  SpinUpDelay                  :1;
    UINT16  BIOSDisable                  :1;
    UINT16  MMAPEnable                   :1;
    UINT16  BootEnable                   :1;
    UINT16  Reserved0                    :12;

    UINT8   bootID0                      :7;
    UINT8   bootID0Valid                 :1;

    UINT8   bootLUN0[8];

    UINT8   bootID1                      :7;
    UINT8   bootID1Valid                 :1;

    UINT8   bootLUN1[8];

    UINT16  MaxLunsPerTarget;
    UINT8   Reserved1[10];
} BIOS_PARAMS, *PBIOS_PARAMS;

typedef struct _EEPROM_PORT_CFG
{
   // MTU MAC 0
   u16               etherMtu_mac;

   // Flow Control MAC 0
   u16               pauseThreshold_mac;
   u16               resumeThreshold_mac;
   u16               reserved[13];
} EEPROM_PORT_CFG, *PEEPROM_PORT_CFG;

typedef struct _EEPROM_FUNCTION_CFG
{
   u8                reserved[30];

   // MAC ADDR
   u8                macAddress[6];
   u8                macAddressSecondary[6];

   u16               subsysVendorId;
   u16               subsysDeviceId;
} EEPROM_FUNCTION_CFG;

typedef struct EEPROM_DATA_
{
   u8                asicId[4];                     // x00
   u8                version;                       // x04
   u8                reserved_5;                    // x05

   u16               boardId;                       // x06
   u8                boardIdStr[16];                // x08
   u8                serialNumber[16];              // x18

   // External Hardware Configuration
   u16               extHwConfig;                   // x28

   // MAC 0 CONFIGURATION
   EEPROM_PORT_CFG macCfg_port0;                    // x2A

   // MAC 1 CONFIGURATION
   EEPROM_PORT_CFG macCfg_port1;                    // x4A

   // DDR SDRAM Configuration
   u16               bufletSize;                    // x6A
   u16               bufletCount;                   // x6C
   u16               tcpWindowThreshold50;          // x6E
   u16               tcpWindowThreshold25;          // x70
   u16               tcpWindowThreshold0;           // x72
   u16               ipHashTableBaseHi;             // x74
   u16               ipHashTableBaseLo;             // x76
   u16               ipHashTableSize;               // x78
   u16               tcpHashTableBaseHi;            // x7A
   u16               tcpHashTableBaseLo;            // x7C
   u16               tcpHashTableSize;              // x7E
   u16               ncbTableBaseHi;                // x80
   u16               ncbTableBaseLo;                // x82
   u16               ncbTableSize;                  // x84
   u16               drbTableBaseHi;                // x86
   u16               drbTableBaseLo;                // x88
   u16               drbTableSize;                  // x8A
   u16               reserved_142[4];               // x8C

   // TCP/IP Parameters
   u16               ipReassemblyTimeout;           // x94
   u16               tcpMaxWindowSize;              // x96
   u16               ipSecurity;                    // x98

   u8                reserved_156[294];             // x9A
   u16               qDebug[8];  // QLOGIC USE ONLY    x1C0

   EEPROM_FUNCTION_CFG  funcCfg_fn0;                // x1D0
   u16               reserved_510;                  // x1FE

   // Address = 512
   u8                oemSpace[432];                 // x200

   BIOS_PARAMS          sBIOSParams_fn1;            // x3B0
   EEPROM_FUNCTION_CFG  funcCfg_fn1;                // x3D0
   u16               reserved_1022;                 // x3FE


   // Address = 1024
   u8                reserved_1024[464];            // x400
   EEPROM_FUNCTION_CFG  funcCfg_fn2;                // x5D0

   u16               reserved_1534;                 // x5FE

   // Address = 1536
   u8                reserved_1536[432];            // x600
   BIOS_PARAMS          sBIOSParams_fn3;            // x7B0
   EEPROM_FUNCTION_CFG  funcCfg_fn3;                // x7D0

   u16               checksum;                      // x7FE
} EEPROM_DATA; /*EEPROM_RISC_PARAMS, *PEEPROM_RISC_PARAMS; */

#else
typedef struct EEPROM_DATA_ {
   u8    id[4];					// 0   (00h)
   u8    version;				// 4   (04h)
   u8    reserved;				// 5   (05h)
		
   u16   boardId;				// 6   (06h)
#  define   EEPROM_BOARDID_ELDORADO    1
#  define   EEPROM_BOARDID_PLACER      2

#  define EEPROM_SERIAL_NUM_SIZE    16
   u8    serialNumber[EEPROM_SERIAL_NUM_SIZE];	// 8   (08h)

// ExtHwConfig:
// Offset = 24bytes
//
// | SSRAM Size|     |ST|PD|SDRAM SZ| W| B| SP  |  |
// |15|14|13|12|11|10| 9| 8 | 7| 6| 5| 4| 3| 2| 1| 0|
// +--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+--+
   u16   extHwConfig;				// 24  (18h)

   u8    mac0[6];				// 26  (1Ah)
   u8    mac1[6];				// 32  (20h)
   u8    mac2[6];				// 38  (26h)
   u8    mac3[6];				// 44  (2Ch)

   u16   etherMtu;				// 50  (32h)
   u16   macConfig;				// 52  (34h)
#define  MAC_CONFIG_ENABLE_ANEG     0x0001
#define  MAC_CONFIG_ENABLE_PAUSE    0x0002

   u16   phyConfig;				// 54  (36h)
#define  PHY_CONFIG_PHY_ADDR_MASK             0x1f
#define  PHY_CONFIG_ENABLE_FW_MANAGEMENT_MASK 0x20

#  define EEPROM_UNUSED_1_SIZE   4
   u8    unused_1[EEPROM_UNUSED_1_SIZE];	// 56  (38h)

   u16   bufletSize;				// 60  (3Ch)
   u16   bufletCount;				// 62  (3Eh)
   u16   bufletPauseThreshold;			// 64  (40h)
   u16   tcpWindowThreshold50;			// 66  (42h)
   u16   tcpWindowThreshold25;			// 68  (44h)
   u16   tcpWindowThreshold0;			// 70  (46h)
   u16   ipHashTableBaseHi;			// 72  (48h)
   u16   ipHashTableBaseLo;			// 74  (4Ah)
   u16   ipHashTableSize;			// 76  (4Ch)
   u16   tcpHashTableBaseHi;			// 78  (4Eh)
   u16   tcpHashTableBaseLo;			// 80  (50h)
   u16   tcpHashTableSize;			// 82  (52h)
   u16   ncbTableBaseHi;                        // 84  (54h)
   u16   ncbTableBaseLo;                        // 86  (56h)
   u16   ncbTableSize;                          // 88  (58h)
   u16   drbTableBaseHi;                        // 90  (5Ah)
   u16   drbTableBaseLo;                        // 92  (5Ch)
   u16   drbTableSize;                          // 94  (5Eh)

#  define EEPROM_UNUSED_2_SIZE   4
   u8    unused_2[EEPROM_UNUSED_2_SIZE];        // 96  (60h)

   u16   ipReassemblyTimeout;                   // 100 (64h)
   u16   tcpMaxWindowSizeHi;                    // 102 (66h)
   u16   tcpMaxWindowSizeLo;                    // 104 (68h)

   u32   net_ip_addr0 ;	               		// 106 (6Ah) /* Added for TOE functionality. */
   u32   net_ip_addr1 ;	                        // 110 (6Eh)
   u32   scsi_ip_addr0 ;	                // 114 (72h)
   u32   scsi_ip_addr1 ;	                // 118 (76h)
#  define EEPROM_UNUSED_3_SIZE   128	/* changed from 144 to account for ip addresses */
   u8    unused_3[EEPROM_UNUSED_3_SIZE];        // 122 (7Ah)

   u16   subsysVendorId_f0;                     // 250 (FAh)
   u16   subsysDeviceId_f0;                     // 252 (FCh)

   // Address = 0x7F
#  define FM93C56A_SIGNATURE  0x9356
#  define FM93C66A_SIGNATURE  0x9366
   u16   signature;                             // 254 (FEh)

#  define EEPROM_UNUSED_4_SIZE   250
   u8    unused_4[EEPROM_UNUSED_4_SIZE];        // 256 (100h)

   u16   subsysVendorId_f1;                     // 506 (1FAh)
   u16   subsysDeviceId_f1;                     // 508 (1FCh)

   u16   checksum;                              // 510 (1FEh)

} EEPROM_DATA;
#endif
#endif // _QL2XNVRM_H_

/*
 * Overrides for Emacs so that we get a uniform tabbing style.
 * Emacs will notice this stuff at the end of the file and automatically
 * adjust the settings for this buffer only.  This must remain at the end
 * of the file.
 * ---------------------------------------------------------------------------
 * Local variables:
 * c-indent-level: 4
 * c-brace-imaginary-offset: 0
 * c-brace-offset: -4
 * c-argdecl-indent: 4
 * c-label-offset: -4
 * c-continued-statement-offset: 4
 * c-continued-brace-offset: 0
 * indent-tabs-mode: nil
 * tab-width: 8
 * End:
 */
