/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#include <linux/version.h>

/*
 * This file set some defines that are required to compile the
 * command source for 4000 module
 *----------------------------------------------------------------------------*/
#define QLA4000
#define QLA4000_DEVICE_ID		0x4000
#define QLA4XXX_PROC_NAME		"qla4000"

#define NUM_OF_ISP_DEVICES	2

#define MEMORY_MAPPED_IO		1  /* Always set to 1,
					    * I/O Mapped not supported*/

#define REQ_Q_MEM_ALIGN_VALUE           (0x1000) /* Align on 4K boundary */
#define RSP_Q_MEM_ALIGN_VALUE           (0x1000)
#define MEM_ALIGN_VALUE           	(0x1000)

/*
 * Define Common Register Accesses (see qla4x_fw.h)
 *----------------------------------------------------------------------------*/
#define ISP_CLEAR_RSP_Q_INTR(ha)     {WRT_REG_DWORD(&ha->reg->interruptStatusOut, ISO_RSP_QUEUE_COMPLETE); PCI_POSTING(&ha->reg->interruptStatusOut);}
#define ISP_CLEAR_MBOX_INTR(ha,msts) {WRT_REG_DWORD(&ha->reg->mailboxOut0, msts); PCI_POSTING(&ha->reg->mailboxOut0);}

#define ISP_RD_RSP_Q_IN(ha)	((uint16_t) RD_REG_DWORD(&ha->reg->responseQueueInPointer))
#define ISP_RD_REQ_Q_OUT(ha)	((uint16_t) RD_REG_DWORD(&ha->reg->requestQueueOutPointer))

#define ISP_RD_INTR_MASK(ha)	(RD_REG_DWORD(&ha->reg->interruptMaskOut))
#define ISP_RD_INTR_STATUS(ha)	(RD_REG_DWORD(&ha->reg->interruptStatusOut))

#define ISP_ENABLE_INTRS(ha)  	{WRT_REG_DWORD(&ha->reg->interruptMaskOut, (uint32_t)(~INTR_PENDING)); PCI_POSTING(&ha->reg->interruptMaskOut);}
#define ISP_DISABLE_INTRS(ha)	{WRT_REG_DWORD(&ha->reg->interruptMaskOut, (uint32_t) INTR_PENDING)); PCI_POSTING(&ha->reg->interruptMaskOut);}

/*
 * Scsi_Host_template (see hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/

/*
 * max_sectors
 *
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,8)
#define TEMPLATE_MAX_SECTORS	max_sectors: 0,  /* OS defined */
#else
#define TEMPLATE_MAX_SECTORS
#endif

/*
 * name
 */
#define TEMPLATE_NAME		name: "QLogic iSCSI 4000",


/*
 * Include common source
 *----------------------------------------------------------------------------*/
#include "ql4drvr.c"

