/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#include <linux/version.h>

/*
 * This file set some defines that are required to compile the
 * command source for 4000 module
 *----------------------------------------------------------------------------*/
#define QLA4010
#define QLA4010_DEVICE_ID		0x4010
#define QLA4XXX_PROC_NAME		"qla4010"

#define NUM_OF_ISP_DEVICES	2

#define MEMORY_MAPPED_IO		1 /* 1=Memory Mapped (preferred),
					   * 0=I/O Mapped */

#define MEM_ALIGN_VALUE                 ((MAX(REQUEST_QUEUE_DEPTH,RESPONSE_QUEUE_DEPTH)) * sizeof(QUEUE_ENTRY))
#define REQ_Q_MEM_ALIGN_VALUE           (REQUEST_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))
#define RSP_Q_MEM_ALIGN_VALUE           (RESPONSE_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))

/*
 * Define Common Register Accesses
 *----------------------------------------------------------------------------*/
#define ISP_CLEAR_RSP_Q_INTR(ha) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_COMPLETION_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}
#define ISP_CLEAR_MBOX_INTR(ha,msts) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_PROCESSOR_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}

#define ISP_RD_RSP_Q_IN(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->responseQueueInPointer))
#define ISP_RD_REQ_Q_OUT(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->requestQueueOutPointer))

#define ISP_RD_INTR_MASK(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))
#define ISP_RD_INTR_STATUS(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))

#define ISP_ENABLE_INTRS(ha)  	{WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_INTR_ENABLE); PCI_POSTING(&ha->reg->ISPControlStatus);}
#define ISP_DISABLE_INTRS(ha)	{WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_INTR_DISABLE); PCI_POSTING(&ha->reg->ISPControlStatus);}

#define ISP_SEMAPHORE(ha)       (&ha->reg->NVRAM)
	
#define ISP_PROBE_MUX_ADDR(ha)  (&ha->reg->probe_mux_addr)
#define ISP_PROBE_MUX_DATA(ha)  (&ha->reg->probe_mux_data)
	


	
/*
 * Scsi_Host_template (see hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/

/*
 * max_sectors
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,8)
#define TEMPLATE_MAX_SECTORS	max_sectors: 0xFFFF,  //max 32MB xfers
#else
#define TEMPLATE_MAX_SECTORS
#endif

/*
 * name
 */
#define TEMPLATE_NAME		name: "QLogic iSCSI 4010",

						
/*
 * Include common source
 *----------------------------------------------------------------------------*/
#include "ql4drvr.c"

