/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#ifndef _QLA4022_H_
#define _QLA4022_H_

#include <linux/version.h>

/*
 * This file set some defines that are required to compile the
 * command source for 4000 module
 *----------------------------------------------------------------------------*/
#define QLA4022
#define QLA4022_DEVICE_ID		0x4022
#define QLA4032_DEVICE_ID		0x4032

#define QLA4XXX_PROC_NAME		"qla4022"

#define NUM_OF_ISP_DEVICES	3

#define MEMORY_MAPPED_IO		1 /* 1=Memory Mapped (preferred),
					   * 0=I/O Mapped */

#define MEM_ALIGN_VALUE                 ((MAX(REQUEST_QUEUE_DEPTH,RESPONSE_QUEUE_DEPTH)) * sizeof(QUEUE_ENTRY))
#define REQ_Q_MEM_ALIGN_VALUE           (REQUEST_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))
#define RSP_Q_MEM_ALIGN_VALUE           (RESPONSE_QUEUE_DEPTH * sizeof(QUEUE_ENTRY))

/*
 * Define Common Register Accesses
 *----------------------------------------------------------------------------*/
#define ISP_CLEAR_RSP_Q_INTR(ha) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_COMPLETION_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}
#define ISP_CLEAR_MBOX_INTR(ha,msts) {WRT_REG_DWORD(&ha->reg->ISPControlStatus, CSRW_SCSI_PROCESSOR_INTR); PCI_POSTING(&ha->reg->ISPControlStatus);}

#define ISP_RD_RSP_Q_IN(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->responseQueueInPointer))
#define ISP_RD_REQ_Q_OUT(ha)	((uint16_t) RD_DMA_DWORD(ha, &ha->dma_regsv->requestQueueOutPointer))

#define ISP_RD_INTR_MASK(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))
#define ISP_RD_INTR_STATUS(ha)	(RD_REG_DWORD(&ha->reg->ISPControlStatus))

#define ISP_ENABLE_INTRS(ha)  	{WRT_REG_DWORD(&ha->reg->InterruptMask, IMRW_SCSI_INTR_ENABLE); PCI_POSTING(&ha->reg->InterruptMask);}
#define ISP_DISABLE_INTRS(ha)	{WRT_REG_DWORD(&ha->reg->InterruptMask, IMRM_SCSI_INTR_ENABLE); PCI_POSTING(&ha->reg->InterruptMask);}

#define ISP_SEMAPHORE(ha)       (&ha->reg->Semaphore)
		
#if defined(__VMKERNEL_MODULE__)
#define ISP_PROBE_MUX_ADDR(ha)  (&ha->reg->pcs_regs.ProbeMuxAddr)
#define ISP_PROBE_MUX_DATA(ha)  (&ha->reg->pcs_regs.ProbeMuxData)
#else
#define ISP_PROBE_MUX_ADDR(ha)  (&ha->reg->ProbeMuxAddr)
#define ISP_PROBE_MUX_DATA(ha)  (&ha->reg->ProbeMuxData)
#endif




/*
 * Scsi_Host_template (see hosts.h)
 * Device driver Interfaces to mid-level SCSI driver.
 *----------------------------------------------------------------------------*/

/*
 * max_sectors
 */
#if LINUX_VERSION_CODE >= KERNEL_VERSION(2,4,8)
#define TEMPLATE_MAX_SECTORS	max_sectors: 0xFFFF,  //max 32MB xfers
#else
#define TEMPLATE_MAX_SECTORS
#endif

/*
 * name
 */
#define TEMPLATE_NAME		name: "QLogic iSCSI 4022",


/*
 * Include common source
 *----------------------------------------------------------------------------*/
#include "ql4drvr.c"

#if 0
#define SEM_FREE                                      0
#define SEM_ISCSI_DRIVER                              (pDevExt->pExt->lFunctionNumber)

#define NVRAMM_CLOCK                                  0x00010000
#define NVRAMM_CHIPSEL                                0x00020000
#define NVRAMM_DATAOUT                                0x00040000
#define NVRAMM_DATAIN                                 0x00080000

#define SEMM_DRIVER                                   0x000e0000
#define SEMM_DRAM                                     0x00700000
#define SEMM_GP                                       0x03800000
#define SEMM_PHYGBIC                                  0x03800000
#define SEMM_NVRAM                                    0x1c000000
#define SEMM_FLASH                                    0xe0000000

typedef union _SEM_REG
{
    struct
    {
        ULONG  bReserved                 :1;
        ULONG  bDriverSem                :3;
        ULONG  bSDRAMSem                 :3;
        ULONG  bGenPurposeOutSem         :3;
#define bPHYGBICSem                                   bGenPurposeOutSem
        ULONG  bNVRAMSem                 :3;
        ULONG  bFlashSem                 :3;
        ULONG  bMask                     :16;
    };
    ULONG   AsULONG;
} SEM_REG, *PSEM_REG;

#endif

#endif // _QLA4022_H_
