/*
 * QLogic iSCSI HBA Driver
 * Copyright (c)  2003-2006 QLogic Corporation
 *
 * See LICENSE.qla4xxx for copyright and licensing details.
 */

#ifndef _QLISIOLN_H_
#define _QLISIOLN_H_

#include <linux/ioctl.h>

#ifdef APILIB
#include <stdint.h>
#endif

#ifndef INT8
#define	INT8	int8_t
#endif
#ifndef INT16
#define	INT16	int16_t
#endif
#ifndef INT32
#define	INT32	int32_t
#endif
#ifndef UINT8
#define	UINT8	uint8_t
#endif
#ifndef UINT16
#define	UINT16	uint16_t
#endif
#ifndef UINT32
#define	UINT32	uint32_t
#endif

#ifndef UINT64
#define UINT64  unsigned long long
#endif

#ifndef BOOLEAN
#define BOOLEAN uint8_t
#endif


#if BITS_PER_LONG <= 32
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_32
#else
#define EXT_ADDR_MODE_OS  EXT_DEF_ADDR_MODE_64
#endif


#define QLMULTIPATH_MAGIC 'y'

#define _QLBUILD   /* for qlisioct.h to enable include of qinsdmgt.h */



#define	EXT_DEF_MAX_HBA_OS		255	/* 0 - 0xFE */
#define	EXT_DEF_MAX_BUS_OS		1
#define	EXT_DEF_MAX_TARGET_OS		255	/* 0 - 0xFE */
#define	EXT_DEF_MAX_LUN_OS		255	/* 0 - 0xFE */

#define EXT_DEF_MAX_AEN_QUEUE_OS        256



/*****************/
/* Command codes */
/*****************/

/* These are regular command codes */
#define EXT_DEF_REG_CC_START_IDX	0x00

#define EXT_CC_QUERY_OS					/* QUERY */	\
    _IOWR(QLMULTIPATH_MAGIC, 0x00, sizeof(EXT_IOCTL_ISCSI))
	
#define EXT_CC_REG_AEN_OS				/* REG_AEN */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x01, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_GET_AEN_OS				/* GET_AEN */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x02, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_GET_DATA_OS				/* GET_DATA */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x03, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_SET_DATA_OS				/* SET_DATA */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x04, sizeof(EXT_IOCTL_ISCSI))
	
#define EXT_CC_SEND_SCSI_PASSTHRU_OS			/* SCSI_PASSTHRU */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x05, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_SEND_ISCSI_PASSTHRU_OS			/* ISCSI_PASSTHRU */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x06, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_DISABLE_ACB_OS				/* DISABLE_ACB */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x07, sizeof(EXT_IOCTL_ISCSI))

#define EXT_CC_SEND_ROUTER_SOL_OS			/* SEND_ROUTER_SOL */ \
    _IOWR(QLMULTIPATH_MAGIC, 0x08, sizeof(EXT_IOCTL_ISCSI))


#define EXT_DEF_REG_CC_END_IDX		0x08

/*
 * This is a Linux driver implementation specific command.
 */
#define EXT_DEF_DRV_SPC_CC_START_IDX	0xff

#define EXT_CC_GET_HBACNT				/* GET_HBACNT */ \
    _IOWR(QLMULTIPATH_MAGIC, 0xff, sizeof(EXT_IOCTL_ISCSI))

#define EXT_DEF_DRV_SPC_CC_END_IDX	0xff

/*
 * HBA Count
 */
typedef struct _EXT_HBA_COUNT {
		UINT16	HbaCnt;				/* 2	*/
} EXT_HBA_COUNT, *PEXT_HBA_COUNT;	   		/* 2    */


#endif //_QLISIOLN_H_
