/*
 *  linux/arch/i386/kernel/vmnix.h
 *
 *  Copyright 2000 VMware, Inc.  All rights reserved. -- VMware Confidential
 */

#ifndef _ASM_VMNIX_H
#define _ASM_VMNIX_H

// CONFIG_VMNIX stuff
#define VMNIX_COS_GDT_ENTRIES	(32)  //see segment.h
#define VMNIX_GDT_ENTRIES 	2100

// Page used for AP startup
#define VMNIX_AP_STARTUP_PAGE	1

// Number of accessible COS virtual terminals
#define VMNIX_MAX_VT            6

#ifndef __ASSEMBLY__

#ifdef CONFIG_VMNIX
#define int64 long long
#define int32 int
#define int16 short
#define int8 char

#define uint64 unsigned long long
#define uint32 unsigned int
#define uint16 unsigned short
#define uint8 unsigned char
#endif

typedef struct VMnix_MemRange {
   unsigned startMPN;
   unsigned endMPN;
} VMnix_MemRange;
#define MAX_VMNIX_MEM_RANGES 32

#define MAKE_VMNIX_VERSION(major,minor) (((major) << 16) | (minor))
#define VMNIX_VERSION_MAJOR(version) ((version) >> 16)
#define VMNIX_VERSION_MINOR(version) ((version) & 0xffff)
#define VMNIX_VERSION MAKE_VMNIX_VERSION(61,0)

/*
 *  This structure contains the information the host passes to vmkernel
 *  on initialization.
 */
typedef struct VMnix_Init {
   unsigned nextMPN;
   VMnix_MemRange vmkMem[MAX_VMNIX_MEM_RANGES];
} VMnix_Init;

extern VMnix_Init vmnixInitBlock;

/*
 *  This structure is the functions that the linux kernel can call in
 *  the module.
 */

struct pt_regs;

typedef struct VMnix_VTable {
   int (*syscall)(unsigned cmd,
                  char *inBuffer, unsigned inBufferLength,
                  char *outBuffer, unsigned outBufferLength);
   void (*idle)(void);
   unsigned long (*lostTicks)(struct pt_regs *regs);
   void (*panic)(const char *msg, struct pt_regs *regs, char *logBuf, int logEnd, int logBufLen);
   int (*consoleCallback)(int nr);
   void (*setTimeOfDay)(const long long tod);
   unsigned int (*allowNetParams)(char *devName);
   void (*printk)(unsigned char alert, char *msg, int bufLen, unsigned char toggle);
} VMnix_VTable;

#ifdef CONFIG_VMNIX
#undef int64
#undef int32
#undef int16
#undef int8

#undef uint64
#undef uint32
#undef uint16
#undef uint8

struct e820map;
extern void vmnix_setup(struct e820map *e820, const char *cmdLine);
void vmnix_setup_early(struct e820map *srcE820);
extern unsigned long long vmnix_mem_size;
extern unsigned char *vmnix_maptemp(unsigned int phys, unsigned int size);
extern void vmnix_add_vmkernel_memory_region(unsigned long long start,
                                             unsigned long long size, int type);
extern void vmnix_limit_vmkernel_regions(unsigned long long size);
extern unsigned long vmnix_lost_ticks(struct pt_regs *regs);
void vmnix_clear_vmk_e820_map(void);
unsigned long long vmnix_get_total_ram(void);
void vmnix_printk(unsigned char alert, char *msg, int bufLen, unsigned char toggle);
#endif
#endif /* !__ASSEMBLY__ */
#endif /* _ASM_VMNIX_H */
