/* ****************************************************************
 * Portions Copyright 2004 VMware, Inc.
 *
 * ****************************************************************/

/*
 * Note there are 2 copies of this file: 
 *   one in console-os
 *   one in bora
 * They must be kept in sync.  
 */

//
// SCSI INQUIRY command definitions
#define SCSI_VPROD_SUPPORTED_PAGES	0x00
#define SCSI_VPROD_UNIT_SERIAL_NUMBER	0x80
#define SCSI_VPROD_ASCII_ID		0x82
#define SCSI_VPROD_DEVICE_ID		0x83
#define SCSI_VPROD_PAGE_LENGTH		255
#define SCSI_EVPD			1
#define SCSI_NAA_IDENTIFIER		0x3

#define SCSI_IDENTIFIERTYPE_VENDOR_SPEC 0x0
#define SCSI_IDENTIFIERTYPE_T10         0x1
#define SCSI_IDENTIFIERTYPE_EUI         0x2
#define SCSI_IDENTIFIERTYPE_NAA         0x3
#define SCSI_NAA_IDENTIFIER             0x3
#define SCSI_IDENTIFIERTYPE_RTPI        0x4
#define SCSI_IDENTIFIERTYPE_TPG         0x5
#define SCSI_IDENTIFIERTYPE_LUG         0x6
#define SCSI_IDENTIFIERTYPE_MD5         0x7
#define SCSI_IDENTIFIERTYPE_SNS         0x8
#define SCSI_IDENTIFIERTYPE_RESERVED    0x9

#define SCSI_PROTOCOLID_FCP2            0x0
#define SCSI_PROTOCOLID_SPI5            0x1
#define SCSI_PROTOCOLID_SSAS3P          0x2
#define SCSI_PROTOCOLID_SBP3            0x3
#define SCSI_PROTOCOLID_SRP             0x4
#define SCSI_PROTOCOLID_ISCSI           0x5
#define SCSI_PROTOCOLID_SAS             0x6
#define SCSI_PROTOCOLID_ADT             0x7
#define SCSI_PROTOCOLID_ATA             0x8
#define SCSI_PROTOCOLID_RESERVED        0xE
#define SCSI_PROTOCOLID_NO_PROTOCOL     0xF

#define SCSI_CODESET_BINARY             0x1
#define SCSI_CODESET_ASCII              0x2
#define SCSI_CODESET_ISOIEC             0x3
#define SCSI_CODESET_RESERVED           0xF

#define SCSI_ASSOCIATION_LUN            0x0
#define SCSI_ASSOCIATION_TARGET_PORT    0x1
#define SCSI_ASSOCIATION_TARGET_DEVICE  0x2
#define SCSI_ASSOCIATION_RESERVED       0x3 

#define INQUIRY_CMD_RESULT_LEN		256
#define INQUIRY_CMD_GENERIC_RESULT_LEN  36

// 
// Length of vendor name in SCSI inquiry 
#define SCSI_VENDOR_LENGTH		8
// 
// Offset of vendor name in SCSI inquiry 
#define SCSI_VENDOR_OFFSET		8
//
//  Length of model name in SCSI inquiry 
#define SCSI_MODEL_LENGTH		16
// 
// Offset of model name in SCSI inquiry
#define SCSI_MODEL_OFFSET		16

//
// Length of VMWare specific disk id
#define SCSI_DISK_ID_LEN		44 

//
// number of bytes of the device model to include in VMWare disk id
#define SCSI_DISK_ID_MODEL_LEN		6

/*
 * These values are written to disk for volumes and
 * RDMs. They should not be changed without providing
 * backward compatibility.
 */
#define VMWARE_SCSI_ID_ERROR			0xff
#define VMWARE_SCSI_ID_UNIQUE		        0x0
#define VMWARE_SCSI_ID_SERIAL_NUM		0x1
#define VMWARE_SCSI_ID_NAA			0x2
#define VMWARE_SCSI_ID_SYMM			0x3
#define VMWARE_SCSI_ID_SCSISTK			0x4
#define VMWARE_SCSI_ID_RESERVED		        0xfe

extern int scsi_vmware_get_disk_id(
   const char *name,
   unsigned char *inquiryBuffer,
   unsigned char *evpdBuffer,
   unsigned char *deviceIdBuffer,
   unsigned char *serialIdBuffer,
   char		 *diskId,
   int	         *diskIdlen);

extern int scsi_vmware_disk_is_pseudo_device(
   const char *name,
   int  lun,
   unsigned char *inquiryBuffer,
   unsigned char *modeSenseBuffer,
   unsigned char *readCapacityBuffer);

extern int scsi_vmware_disk_id_equal(
   unsigned char *id1,
   int           idLun1,
   unsigned char *id2,
   int           idLun2);

extern void scsi_vmware_log_disk_id(
   unsigned char *id,
   int           len);
   
extern int scsi_vmware_filter_lun(
   char          *scsi_result);

   
