#ifndef _LINUX_TIMER_H
#define _LINUX_TIMER_H

#include <linux/config.h>
#include <linux/list.h>
#include <linux/spinlock.h>
#include <linux/string.h>
#include <linux/kernel.h>

struct tvec_t_base_s;

struct timer_list {
	struct list_head entry;
	unsigned long expires;
	unsigned long data;
	void (*function)(unsigned long);

	unsigned long magic;
	unsigned long lock;
	struct tvec_t_base_s *base;
        int added;
};
#define ADDED_MAGIC 0xabcdef10

#define TIMER_INITIALIZER(_function, _expires, _data) {		\
		.function = (_function),			\
		.expires = (_expires),				\
		.data = (_data),				\
		.lock = 0,					\
		.base = NULL,					\
	}

/***
 * init_timer - initialize a timer.
 * @timer: the timer to be initialized
 *
 * init_timer() must be done to a timer prior calling *any* of the
 * other timer functions.
 */
static inline void init_timer(struct timer_list * timer)
{
        if (timer->added == ADDED_MAGIC) {
           static char fnBuf[256];
           static char* skipFnList[] = {
              "it_real_fn ",
              "tcp_keepalive_timer ",
              NULL };
           char **skipFn;
           int ksyms_lookup_symbol(unsigned long address, char *buffer, int buflen);
           if (ksyms_lookup_symbol((unsigned long)timer->function, fnBuf, 256)
                 < 0) {
              snprintf(fnBuf, 256, "%p", timer->function);
           }
           skipFn = skipFnList;
           while (*skipFn) {
              if (!strncmp(fnBuf, *skipFn, strlen(*skipFn))) {
                 break;
              }
              skipFn++;
           }
           if (!skipFn) {
              printk(KERN_INFO " timer: %p, fn: %s: magic: %x\n",
                    timer, fnBuf, timer->added);
           }
        }

	timer->magic = 0;
	timer->lock = 0;
	timer->base = NULL;
}

extern int timer_pending(struct timer_list * timer);
extern void add_timer(struct timer_list * timer);
extern int del_timer(struct timer_list * timer);
extern int mod_timer(struct timer_list *timer, unsigned long expires);
  
#ifdef CONFIG_SMP
  extern int del_timer_sync(struct timer_list * timer);
#else
# define del_timer_sync(t) del_timer(t)
#endif

extern void it_real_fn(unsigned long);

#define RATE_LIMIT(interval)					\
({								\
	static unsigned long expires;				\
	int ok = time_after(jiffies, expires);			\
	if (ok)							\
		expires = jiffies + (interval);			\
	ok;							\
})

#ifdef CONFIG_NO_IDLE_HZ
extern unsigned long next_timer_event(void);
#endif

#endif
