#!/usr/bin/python

import getopt
import time
from pyVim import vc
from pyVim import connect
from pyVim import invt
import sys

"""
Stateless esx (horde) script to add a host to esx.
Minimally functional preliminary version.
"""

def Usage(msg="Unknown error"):
   print "Error: " + msg
   print "Usage: addHost [-w wait for hostd] [-d datacenter] [-c DRS cluster] [-v VC server] [-u user] [-p passwd] esxserver"
   sys.exit(1)

def WaitForHostd():
   connected = None
   print "Waiting for hostd to come up ... "
   while connected is None:
      try:
         connect.Connect(host="localhost")
      except Exception, inst:
         print "Got exception: "
         print type(inst)
         print inst 
         print "\n"
         time.sleep(5)
         pass
      else:
         connected=True
   print "Done.\n"

def main():
   user="Administrator"
   pwd="ca$hc0w"
   dataCenter = "one host to rule them all"
   drsCluster = "in the darkness"
   vcServer = "192.168.73.249"

   try:
      opts,args = getopt.getopt(sys.argv[1:], "d:u:p:v:c:w")
   except getopt.GetoptError:
      Usage("Unknown arguments")

   if len(args) == 0:
      Usage("Host not specified")
   esxServer = args[0]

   for a,v in opts:
      if a=="-d":
         dataCenter = v
      if a=="-u":
         user = v
      if a=="-p":
         pwd = v
      if a=="-c":
         drsCluster = v
      if a=="-v":
         vcServer = v
      if a=="-w":
         WaitForHostd()

   connect.Connect(user=user, pwd=pwd, host=vcServer)

   if invt.GetDatacenter(dataCenter) is None:
      # No datacenter is specified, or the datacenter specified does not exist.
      print "Failed to find supplied datacenter: " + dataCenter
      return -1

   print "Adding host " + esxServer + "..."
   vc.AddHost(host=esxServer, dataCenter=dataCenter, clusterName=drsCluster)
   print "Done!"
   
if __name__ == "__main__":
   main()
