use strict;

use File::Basename;
use File::Spec;
use Test;

BEGIN {
   plan tests => 3;

   my $path = File::Spec->catfile(dirname($0), "..", "..", "..");
   push @INC, $path;
   push @INC, ".";
}

use VMware::Config::VMKConfigObj;

my $file = <<EOD;
boot/resMem = "700"
enabled = "true"
foo/bar = "zippy"
EOD

my $testFile = File::Spec->catfile(dirname($0), "vmk.conf");
open(FILE, ">$testFile") or die "Could not open $testFile: $!\n";
print FILE ($file) or die "Could not print to $testFile: $!\n";
close(FILE) or die "Could not close $testFile: $!\n";

my $cfg = new VMware::Config::VMKConfigObj::();
$cfg->LoadFromFile($testFile);
my $result = $cfg->ToString();

ok($cfg->Get("boot/resMem"), "700");
ok($cfg->GetBoolean("enabled"));
ok($cfg->Get("foo/bar"), "zippy");

unlink($testFile) or die "Could not remove test file: $!\n";

