##########################################################################
# Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential
##########################################################################

#
# UuidCacheEntry.pm --
#
#       A basic class that represents a uuid-label-device cache mapping.
#

package VMware::FileSys::UuidCacheEntry;

use strict;


########################################################################
#
# UuidCacheEntry::new --
#
#       Constructor for a VMware::FileSys::UuidCacheEntry object.
#
# Results:
#       The new object, or undef on error.
#
# Side effects:
#       None.
#
########################################################################

sub new
{
   my $class = shift;   # IN: Invoking class.

   my $self = {
      device => shift,  # IN: The device name
      uuid => shift,    # IN: The uuid
      label => shift,   # IN: The label
   };

   bless $self => $class;
   return $self;
}


#
# Trivial Accessor Functions
#

sub GetDevice
{
   my $self = shift;
   return $self->{device};
}

sub GetUuid
{ 
   my $self = shift;
   return $self->{uuid};
}

sub GetLabel
{
   my $self = shift;
   return $self->{label};
}


#######################################################################
#
# ToUuidSpec --
#
#       Create a spec string of the form UUID=<uuid> suitable for use
#       in fstab, grub, etc.
#
# Results:
#       The spec string, or undef if the entry uuid is undef or "".
#
# Side effects:
#       None
#
#######################################################################

sub ToUuidSpec
{
   my $self = shift;    # IN: Invoking instance.

   my $uuid = $self->GetUuid();
   if ($uuid) {
      return "UUID=$uuid";
   } else {
      return undef;
   }
}

1;
