
use strict;
use File::Basename;
use File::Spec;
use Test;

BEGIN {
   $| = 1;
   plan tests => 21;
   my $path = File::Spec->catfile(dirname($0), "..", "..", "..");
   push @INC, $path;
   push @INC, ".";
}

use VMware::Log::Format;

my $dateString = '[0-9]{4}(?:-[0-9]{2}){2}';
my $timeString = '[0-9]{2}(?::[0-9]{2}){2}';
my $codeString = '[^:]*:[0-9]+';
my $pidString = '\([0-9]+\)';
my $date = qr/$dateString/;
my $time = qr/$timeString/;
my $code = qr/$codeString/;
my $pid = qr/$pidString/;
my $id = qr/ID:  /;

my $data = "test data";

my $fmt = new VMware::Log::Format::();
ok(defined $fmt);

my $formatted = $fmt->Format("ID", $data);
$formatted =~ m/^$id$data$/;
ok($&, $formatted, "Bad match (default): |$`|$&|$'|\n");
ok($fmt->Description(), "FORMAT: 1");

$fmt->SetDate();
$formatted =~ m/^$date $id$data$/;
ok($&, $formatted, "Bad match (date): |$`|$&|$'|\n");
ok($fmt->Description(), "FORMAT: 1, datestamp, $dateString");

$fmt->SetTime();
$formatted =~ m/^$date $time $id$data$/;
ok($&, $formatted, "Bad match (date time): |$`|$&|$'|\n");
ok($fmt->Description(),
   "FORMAT: 1, datestamp, $dateString, timestamp, $timeString");

$fmt->SetCode();
$formatted =~ m/^$date $time $code $id$data$/;
ok($&, $formatted, "Bad match (date time code): |$`|$&|$'|\n");
ok($fmt->Description(),
   "FORMAT: 1, datestamp, $dateString, timestamp, $timeString, " .
   "codestamp, $codeString");

$fmt->SetPid();
$formatted =~ m/^$date $time $code $pid $id$data$/;
ok($&, $formatted, "Bad match (date time code pid): |$`|$&|$'|\n");
ok($fmt->Description(),
   "FORMAT: 1, datestamp, $dateString, timestamp, $timeString, " .
   "codestamp, $codeString, pidstamp, $pidString");

$fmt->ClearTime();
$formatted =~ m/^$date $code $pid $id$data$/;
ok($&, $formatted, "Bad match (date code pid): |$`|$&|$'|\n");
ok($fmt->Description(),
   "FORMAT: 1, datestamp, $dateString, codestamp, $codeString, " .
   "pidstamp, $pidString");

$fmt->ClearDate();
$formatted =~ m/^$code $pid $id$data$/;
ok($&, $formatted, "Bad match (code pid): |$`|$&|$'|\n");
ok($fmt->Description(),
   "FORMAT: 1, codestamp, $codeString, pidstamp, $pidString");

$fmt->ClearCode();
$formatted =~ m/^$pid $id$data$/;
ok($&, $formatted, "Bad match (pid): |$`|$&|$'|\n");
ok($fmt->Description(), "FORMAT: 1, pidstamp, $pidString");

$fmt->ClearPid();
$formatted =~ m/^$id$data$/;
ok($&, $formatted, "Bad match (all cleared): |$`|$&|$'|\n");
ok($fmt->Description(), "FORMAT: 1");

#
# Test for the new ability to pass parameters to set the initial format state.
#

my $fmt2 = VMware::Log::Format->new(1, 1, 0, 1);
my $formatted2 = $fmt2->Format("ID", $data);

$formatted2 =~ m/^$date $time $code $pid $id$data$/,
ok($&, $formatted2, "Bad match (date time code pid): |$`|$&|$'|\n");
ok($fmt2->Description(),
   "FORMAT: 1, datestamp, $dateString, timestamp, $timeString, " .
   "codestamp, $codeString, pidstamp, $pidString");

