##########################################################################
# Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential
##########################################################################

#
# Beacon.pm --
#
#       A basic class that contains information representing a beacon.
#       Information can be loaded from a configuration tree.
#

package VMware::Net::Beacon;

use strict;


########################################################################
#
# Beacon::new --
#
#       Constructor for a VMware::Net::Beacon object.
#
# Results:
#       The new object, or undef on error.
#
# Side effects:
#       None.
#
########################################################################

sub new
{
   my $class = shift;            # IN: Invoking class.
   my $cfgTree = (shift || {});  # IN: Tree structure of data from the
                                 #     config file.

   my $self = {
      cfgTree => $cfgTree,
   };

   bless $self => $class;
   return $self;
}


########################################################################
#
# Beacon::GetConfigData --
#
#       Get the config info for the beacon in vmacore structure form.
#
# Results:
#       The data structure.
#
# Side effects:
#       None.
#
########################################################################

sub GetConfigData
{
   my $self = shift; # IN: Invoking instance.
   return $self->{cfgTree};
}


#
# Trivial Accessor Functions
#

sub GetEnable
{
   my $self = shift;
   return $self->{cfgTree}->{enable};
}

sub GetThreshold
{
   my $self = shift;
   return $self->{cfgTree}->{threshold};
}

sub GetTimeout
{
   my $self = shift;
   return $self->{cfgTree}->{timeout};
}


#
# Trivial Mutator Functions
#

sub SetEnable
{
   my $self = shift;
   $self->{cfgTree}->{enable} = shift;
}

sub SetThreshold
{
   my $self = shift;
   $self->{cfgTree}->{threshold} = shift;
}

sub SetTimeout
{
   my $self = shift;
   $self->{cfgTree}->{timeout} = shift;
}


1;
