##########################################################################
# Copyright 2005 VMware, Inc.  All rights reserved. -- VMware Confidential
##########################################################################

#
# VMKNic.pm --
#
#       A class that contains information representing a vmkernel nic.
#       Information can be loaded from a configuration tree.
#

package VMware::Net::VMKNic;

use strict;


########################################################################
#
# VMKNic::new --
#
#       Constructor for a VMware::Net::VMKNic object.
#
# Results:
#       The new object, or undef on error.
#
# Side effects:
#       None.
#
########################################################################

sub new
{
   my $class = shift;            # IN: Invoking class.
   my $cfgTree = (shift || {});  # IN: Tree structure of data from the
                                 #     config file.

   my $self = {
      cfgTree => $cfgTree,
   };

   bless $self => $class;
   return $self;
}


########################################################################
#
# VMKNic::GetConfigData --
#
#       Get the vmknic info in a structure suitable for the config file.
#
# Results:
#       The data structure.
#
# Side effects:
#       None.
#
########################################################################

sub GetConfigData
{
   my $self = shift;  # IN: Invoking instance.
   return $self->{cfgTree};
}


#
# Trivial Mutator Functions
#

sub SetDHCP
{
   my $self = shift;
   $self->{cfgTree}->{dhcp} = shift;
}

sub SetEnable
{
   my $self = shift;
   $self->{cfgTree}->{enable} = shift;
}

sub SetIpV4Address
{
   my $self = shift;
   $self->{cfgTree}->{ipv4address} = shift;
}

sub SetIpV4Broadcast
{
   my $self = shift;
   $self->{cfgTree}->{ipv4broadcast} = shift;
}

sub SetIpV4Netmask
{
   my $self = shift;
   $self->{cfgTree}->{ipv4netmask} = shift;
}

sub SetPortGroup
{
   my $self = shift;
   $self->{cfgTree}->{portgroup} = shift;
}


1;
