# -*- coding: UTF-8 -*-

import sys
import re

"""
Compares the value of version_beta to version_alpha.  If
version_beta is greater, it returns true, otherwise it
returns false.  Expects both to be strings.

Arguments:
   version_alpha: version to be compared against
   version_beta: version being compared

Exceptions:
   None

Returns:
   Boolean value if the value of version_beta is greater than
   version_alpha
"""
def is_version_greater(version_alpha, version_beta):
   """Check if version_beta is greater than version alpha"""
   if version_alpha == version_beta:
      return False

   alpha = version_alpha.split('.')
   beta = version_beta.split('.')

   for i in range(0, min(len(alpha),len(beta))):
      if beta[i] > alpha[i]:
         return True
      elif beta[i] < alpha[i]:
         return False

   if len(beta) > len(alpha):
      return True

   return False


"""
Compares the value of version_beta to version_alpha.  If
version_beta is less, it returns true, otherwise it
returns false.  Expects both to be strings.

Arguments:
   version_alpha: version to be compared against
   version_beta: version being compared

Exceptions:
   None

Returns:
   Boolean value if the value of version_beta is less than
   version_alpha
"""
def is_version_less(version_alpha, version_beta):
   """Check if version_beta is less than version alpha"""
   if version_alpha == version_beta:
      return False

   alpha = version_alpha.split('.')
   beta = version_beta.split('.')

   for i in range(0, min(len(alpha), len(beta))):
      if beta[i] < alpha[i]:
         return True
      elif beta[i] > alpha[i]:
         return False

   if len(alpha) > len(beta):
      return True

   return False


"""
Compares the value of version_beta to version_alpha.  If
version_beta is equal to version_alpha it returns true,
otherwise it returns false.  Expects both to be strings.

Arguments:
   version_alpha: version to be compared against
   version_beta: version being compared

Exceptions:
   None

Returns:
   Boolean value if the value of version_beta is equal to
   version_alpha
"""
def is_version_equal(version_alpha, version_beta):
   """Check if version_beta is equal to version_alpha"""
   if version_alpha == version_beta:
      return True

   return False

"""
Checks if the python interpreter is of sufficient version
as the argument provided.  Expects a string argument.

Arguments:
   version: Minimum version needed

Exceptions:
   None

Returns:
   Boolean value if the version of the interpreter is sufficient
   to match the requirement
"""
def python_required(version):
   """Checks if the python interpreter is greater than or equal to version"""
   return is_version_greater(version, sys.version.split(' ')[0]) or \
          is_version_equal(version, sys.version.split(' ')[0])

"""
Read a file and return a list of lines

Arguments:
   file_path: string filepath
   comment_desc: string regex to ignore
   ignore_ws: boolean to ignore blank lines
   ignore_comments: boolean to ignore comments

Exceptions:
   File Access Exceptions (see errno)

Returns:
   list of lines in representing the file without comments
"""
def read_file(file_path, comment_desc='^#', ignore_ws=True, ignore_comments=True):
   """Reads a file into a list and returns it"""
   file = [ ]
   
   stream = open(file_path, 'r')
   read = stream.readline()

   if comment_desc is not None:
      comments = re.compile(comment_desc)
   else:
      comments = None

   line = re.compile(r'^\s*(.*)$')

   while read:
      if read.isspace() or read is '':
         if not ignore_ws:
            file.append(read)
      else:
         if not (ignore_comments and comments and comments.match(read)):
            if ignore_ws:
               file.append(line.match(read.split('\n')[0]).group(1))
            else:
               file.append(read.split('\n')[0])

      read = stream.readline()

   stream.close()

   return file

"""
Creates an indentation string

Arguments:
   level: depth of indent

Returns:
   String of tabs

Exceptions:
   None

This method will create a string of $level tabs
"""
def CreateIndent(level):
   indent = ''
   for i in range(0, level):
      indent += '\t'
   return indent
